/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.Device;
import org.mandas.docker.client.messages.HostConfig;
import org.mandas.docker.client.messages.LogConfig;
import org.mandas.docker.client.messages.PortBinding;
import org.mandas.docker.client.messages.mount.Mount;

final class ImmutableHostConfig
implements HostConfig {
    @Nullable
    private final List<String> binds;
    @Nullable
    private final Integer blkioWeight;
    @Nullable
    private final List<HostConfig.BlkioWeightDevice> blkioWeightDevice;
    @Nullable
    private final List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps;
    @Nullable
    private final List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps;
    @Nullable
    private final List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps;
    @Nullable
    private final List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps;
    @Nullable
    private final String containerIdFile;
    @Nullable
    private final List<HostConfig.LxcConfParameter> lxcConf;
    @Nullable
    private final Boolean privileged;
    @Nullable
    private final Map<String, List<PortBinding>> portBindings;
    @Nullable
    private final List<String> links;
    @Nullable
    private final Boolean publishAllPorts;
    @Nullable
    private final List<String> dns;
    @Nullable
    private final List<String> dnsOptions;
    @Nullable
    private final List<String> dnsSearch;
    @Nullable
    private final List<String> extraHosts;
    @Nullable
    private final List<String> groupAdd;
    @Nullable
    private final List<String> volumesFrom;
    @Nullable
    private final List<String> capAdd;
    @Nullable
    private final List<String> capDrop;
    @Nullable
    private final String networkMode;
    @Nullable
    private final List<String> securityOpt;
    @Nullable
    private final List<Device> devices;
    @Nullable
    private final Long memory;
    @Nullable
    private final Long memorySwap;
    @Nullable
    private final Long kernelMemory;
    @Nullable
    private final Integer memorySwappiness;
    @Nullable
    private final Long memoryReservation;
    @Nullable
    private final Long nanoCpus;
    @Nullable
    private final Long cpuPeriod;
    @Nullable
    private final Long cpuShares;
    @Nullable
    private final String cpusetCpus;
    @Nullable
    private final String cpusetMems;
    @Nullable
    private final Long cpuQuota;
    @Nullable
    private final String cgroupParent;
    @Nullable
    private final HostConfig.RestartPolicy restartPolicy;
    @Nullable
    private final LogConfig logConfig;
    @Nullable
    private final String ipcMode;
    @Nullable
    private final List<HostConfig.Ulimit> ulimits;
    @Nullable
    private final String pidMode;
    @Nullable
    private final Long shmSize;
    @Nullable
    private final Boolean oomKillDisable;
    @Nullable
    private final Integer oomScoreAdj;
    @Nullable
    private final Boolean autoRemove;
    @Nullable
    private final Integer pidsLimit;
    @Nullable
    private final Map<String, String> tmpfs;
    @Nullable
    private final Boolean readonlyRootfs;
    @Nullable
    private final Map<String, String> storageOpt;
    @Nullable
    private final String runtime;
    @Nullable
    private final List<Mount> mounts;
    @Nullable
    private final Boolean init;
    private final Map<String, String> sysctls;
    @Nullable
    private final List<String> capabilities;
    @Nullable
    private final List<HostConfig.DeviceRequest> deviceRequests;
    private final transient HostConfig.Builder toBuilder;

    private ImmutableHostConfig(@Nullable List<String> binds, @Nullable Integer blkioWeight, @Nullable List<HostConfig.BlkioWeightDevice> blkioWeightDevice, @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps, @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps, @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps, @Nullable List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps, @Nullable String containerIdFile, @Nullable List<HostConfig.LxcConfParameter> lxcConf, @Nullable Boolean privileged, @Nullable Map<String, List<PortBinding>> portBindings, @Nullable List<String> links, @Nullable Boolean publishAllPorts, @Nullable List<String> dns, @Nullable List<String> dnsOptions, @Nullable List<String> dnsSearch, @Nullable List<String> extraHosts, @Nullable List<String> groupAdd, @Nullable List<String> volumesFrom, @Nullable List<String> capAdd, @Nullable List<String> capDrop, @Nullable String networkMode, @Nullable List<String> securityOpt, @Nullable List<Device> devices, @Nullable Long memory, @Nullable Long memorySwap, @Nullable Long kernelMemory, @Nullable Integer memorySwappiness, @Nullable Long memoryReservation, @Nullable Long nanoCpus, @Nullable Long cpuPeriod, @Nullable Long cpuShares, @Nullable String cpusetCpus, @Nullable String cpusetMems, @Nullable Long cpuQuota, @Nullable String cgroupParent, @Nullable HostConfig.RestartPolicy restartPolicy, @Nullable LogConfig logConfig, @Nullable String ipcMode, @Nullable List<HostConfig.Ulimit> ulimits, @Nullable String pidMode, @Nullable Long shmSize, @Nullable Boolean oomKillDisable, @Nullable Integer oomScoreAdj, @Nullable Boolean autoRemove, @Nullable Integer pidsLimit, @Nullable Map<String, String> tmpfs, @Nullable Boolean readonlyRootfs, @Nullable Map<String, String> storageOpt, @Nullable String runtime, @Nullable List<Mount> mounts, @Nullable Boolean init, Map<String, String> sysctls, @Nullable List<String> capabilities, @Nullable List<HostConfig.DeviceRequest> deviceRequests) {
        this.binds = binds;
        this.blkioWeight = blkioWeight;
        this.blkioWeightDevice = blkioWeightDevice;
        this.blkioDeviceReadBps = blkioDeviceReadBps;
        this.blkioDeviceWriteBps = blkioDeviceWriteBps;
        this.blkioDeviceReadIOps = blkioDeviceReadIOps;
        this.blkioDeviceWriteIOps = blkioDeviceWriteIOps;
        this.containerIdFile = containerIdFile;
        this.lxcConf = lxcConf;
        this.privileged = privileged;
        this.portBindings = portBindings;
        this.links = links;
        this.publishAllPorts = publishAllPorts;
        this.dns = dns;
        this.dnsOptions = dnsOptions;
        this.dnsSearch = dnsSearch;
        this.extraHosts = extraHosts;
        this.groupAdd = groupAdd;
        this.volumesFrom = volumesFrom;
        this.capAdd = capAdd;
        this.capDrop = capDrop;
        this.networkMode = networkMode;
        this.securityOpt = securityOpt;
        this.devices = devices;
        this.memory = memory;
        this.memorySwap = memorySwap;
        this.kernelMemory = kernelMemory;
        this.memorySwappiness = memorySwappiness;
        this.memoryReservation = memoryReservation;
        this.nanoCpus = nanoCpus;
        this.cpuPeriod = cpuPeriod;
        this.cpuShares = cpuShares;
        this.cpusetCpus = cpusetCpus;
        this.cpusetMems = cpusetMems;
        this.cpuQuota = cpuQuota;
        this.cgroupParent = cgroupParent;
        this.restartPolicy = restartPolicy;
        this.logConfig = logConfig;
        this.ipcMode = ipcMode;
        this.ulimits = ulimits;
        this.pidMode = pidMode;
        this.shmSize = shmSize;
        this.oomKillDisable = oomKillDisable;
        this.oomScoreAdj = oomScoreAdj;
        this.autoRemove = autoRemove;
        this.pidsLimit = pidsLimit;
        this.tmpfs = tmpfs;
        this.readonlyRootfs = readonlyRootfs;
        this.storageOpt = storageOpt;
        this.runtime = runtime;
        this.mounts = mounts;
        this.init = init;
        this.sysctls = sysctls;
        this.capabilities = capabilities;
        this.deviceRequests = deviceRequests;
        this.toBuilder = Objects.requireNonNull(HostConfig.super.toBuilder(), "toBuilder");
    }

    @Override
    @JsonProperty(value="Binds")
    @Nullable
    public List<String> binds() {
        return this.binds;
    }

    @Override
    @JsonProperty(value="BlkioWeight")
    @Nullable
    public Integer blkioWeight() {
        return this.blkioWeight;
    }

    @Override
    @JsonProperty(value="BlkioWeightDevice")
    @Nullable
    public List<HostConfig.BlkioWeightDevice> blkioWeightDevice() {
        return this.blkioWeightDevice;
    }

    @Override
    @JsonProperty(value="BlkioDeviceReadBps")
    @Nullable
    public List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps() {
        return this.blkioDeviceReadBps;
    }

    @Override
    @JsonProperty(value="BlkioDeviceWriteBps")
    @Nullable
    public List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps() {
        return this.blkioDeviceWriteBps;
    }

    @Override
    @JsonProperty(value="BlkioDeviceReadIOps")
    @Nullable
    public List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps() {
        return this.blkioDeviceReadIOps;
    }

    @Override
    @JsonProperty(value="BlkioDeviceWriteIOps")
    @Nullable
    public List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps() {
        return this.blkioDeviceWriteIOps;
    }

    @Override
    @JsonProperty(value="ContainerIDFile")
    @Nullable
    public String containerIdFile() {
        return this.containerIdFile;
    }

    @Override
    @JsonProperty(value="LxcConf")
    @Nullable
    public List<HostConfig.LxcConfParameter> lxcConf() {
        return this.lxcConf;
    }

    @Override
    @JsonProperty(value="Privileged")
    @Nullable
    public Boolean privileged() {
        return this.privileged;
    }

    @Override
    @JsonProperty(value="PortBindings")
    @Nullable
    public Map<String, List<PortBinding>> portBindings() {
        return this.portBindings;
    }

    @Override
    @JsonProperty(value="Links")
    @Nullable
    public List<String> links() {
        return this.links;
    }

    @Override
    @JsonProperty(value="PublishAllPorts")
    @Nullable
    public Boolean publishAllPorts() {
        return this.publishAllPorts;
    }

    @Override
    @JsonProperty(value="Dns")
    @Nullable
    public List<String> dns() {
        return this.dns;
    }

    @Override
    @JsonProperty(value="DnsOptions")
    @Nullable
    public List<String> dnsOptions() {
        return this.dnsOptions;
    }

    @Override
    @JsonProperty(value="DnsSearch")
    @Nullable
    public List<String> dnsSearch() {
        return this.dnsSearch;
    }

    @Override
    @JsonProperty(value="ExtraHosts")
    @Nullable
    public List<String> extraHosts() {
        return this.extraHosts;
    }

    @Override
    @JsonProperty(value="GroupAdd")
    @Nullable
    public List<String> groupAdd() {
        return this.groupAdd;
    }

    @Override
    @JsonProperty(value="VolumesFrom")
    @Nullable
    public List<String> volumesFrom() {
        return this.volumesFrom;
    }

    @Override
    @JsonProperty(value="CapAdd")
    @Nullable
    public List<String> capAdd() {
        return this.capAdd;
    }

    @Override
    @JsonProperty(value="CapDrop")
    @Nullable
    public List<String> capDrop() {
        return this.capDrop;
    }

    @Override
    @JsonProperty(value="NetworkMode")
    @Nullable
    public String networkMode() {
        return this.networkMode;
    }

    @Override
    @JsonProperty(value="SecurityOpt")
    @Nullable
    public List<String> securityOpt() {
        return this.securityOpt;
    }

    @Override
    @JsonProperty(value="Devices")
    @Nullable
    public List<Device> devices() {
        return this.devices;
    }

    @Override
    @JsonProperty(value="Memory")
    @Nullable
    public Long memory() {
        return this.memory;
    }

    @Override
    @JsonProperty(value="MemorySwap")
    @Nullable
    public Long memorySwap() {
        return this.memorySwap;
    }

    @Override
    @JsonProperty(value="KernelMemory")
    @Nullable
    public Long kernelMemory() {
        return this.kernelMemory;
    }

    @Override
    @JsonProperty(value="MemorySwappiness")
    @Nullable
    public Integer memorySwappiness() {
        return this.memorySwappiness;
    }

    @Override
    @JsonProperty(value="MemoryReservation")
    @Nullable
    public Long memoryReservation() {
        return this.memoryReservation;
    }

    @Override
    @JsonProperty(value="NanoCpus")
    @Nullable
    public Long nanoCpus() {
        return this.nanoCpus;
    }

    @Override
    @JsonProperty(value="CpuPeriod")
    @Nullable
    public Long cpuPeriod() {
        return this.cpuPeriod;
    }

    @Override
    @JsonProperty(value="CpuShares")
    @Nullable
    public Long cpuShares() {
        return this.cpuShares;
    }

    @Override
    @JsonProperty(value="CpusetCpus")
    @Nullable
    public String cpusetCpus() {
        return this.cpusetCpus;
    }

    @Override
    @JsonProperty(value="CpusetMems")
    @Nullable
    public String cpusetMems() {
        return this.cpusetMems;
    }

    @Override
    @JsonProperty(value="CpuQuota")
    @Nullable
    public Long cpuQuota() {
        return this.cpuQuota;
    }

    @Override
    @JsonProperty(value="CgroupParent")
    @Nullable
    public String cgroupParent() {
        return this.cgroupParent;
    }

    @Override
    @JsonProperty(value="RestartPolicy")
    @Nullable
    public HostConfig.RestartPolicy restartPolicy() {
        return this.restartPolicy;
    }

    @Override
    @JsonProperty(value="LogConfig")
    @Nullable
    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Override
    @JsonProperty(value="IpcMode")
    @Nullable
    public String ipcMode() {
        return this.ipcMode;
    }

    @Override
    @JsonProperty(value="Ulimits")
    @Nullable
    public List<HostConfig.Ulimit> ulimits() {
        return this.ulimits;
    }

    @Override
    @JsonProperty(value="PidMode")
    @Nullable
    public String pidMode() {
        return this.pidMode;
    }

    @Override
    @JsonProperty(value="ShmSize")
    @Nullable
    public Long shmSize() {
        return this.shmSize;
    }

    @Override
    @JsonProperty(value="OomKillDisable")
    @Nullable
    public Boolean oomKillDisable() {
        return this.oomKillDisable;
    }

    @Override
    @JsonProperty(value="OomScoreAdj")
    @Nullable
    public Integer oomScoreAdj() {
        return this.oomScoreAdj;
    }

    @Override
    @JsonProperty(value="AutoRemove")
    @Nullable
    public Boolean autoRemove() {
        return this.autoRemove;
    }

    @Override
    @JsonProperty(value="PidsLimit")
    @Nullable
    public Integer pidsLimit() {
        return this.pidsLimit;
    }

    @Override
    @JsonProperty(value="Tmpfs")
    @Nullable
    public Map<String, String> tmpfs() {
        return this.tmpfs;
    }

    @Override
    @JsonProperty(value="ReadonlyRootfs")
    @Nullable
    public Boolean readonlyRootfs() {
        return this.readonlyRootfs;
    }

    @Override
    @JsonProperty(value="StorageOpt")
    @Nullable
    public Map<String, String> storageOpt() {
        return this.storageOpt;
    }

    @Override
    @JsonProperty(value="Runtime")
    @Nullable
    public String runtime() {
        return this.runtime;
    }

    @Override
    @JsonProperty(value="Mounts")
    @Nullable
    public List<Mount> mounts() {
        return this.mounts;
    }

    @Override
    @JsonProperty(value="Init")
    @Nullable
    public Boolean init() {
        return this.init;
    }

    @Override
    @JsonProperty(value="Sysctls")
    public Map<String, String> sysctls() {
        return this.sysctls;
    }

    @Override
    @JsonProperty(value="Capabilities")
    @Nullable
    public List<String> capabilities() {
        return this.capabilities;
    }

    @Override
    @JsonProperty(value="DeviceRequests")
    @Nullable
    public List<HostConfig.DeviceRequest> deviceRequests() {
        return this.deviceRequests;
    }

    @Override
    @JsonProperty(value="toBuilder")
    @JsonIgnore
    public HostConfig.Builder toBuilder() {
        return this.toBuilder;
    }

    public final ImmutableHostConfig withBinds(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(null, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(newValue, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBinds(@Nullable Iterable<String> elements) {
        if (this.binds == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(newValue, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioWeight(@Nullable Integer value) {
        if (Objects.equals(this.blkioWeight, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, value, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioWeightDevice(HostConfig.BlkioWeightDevice ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, null, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<HostConfig.BlkioWeightDevice> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, newValue, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioWeightDevice(@Nullable Iterable<? extends HostConfig.BlkioWeightDevice> elements) {
        if (this.blkioWeightDevice == elements) {
            return this;
        }
        List<HostConfig.BlkioWeightDevice> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, newValue, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceReadBps(HostConfig.BlkioDeviceRate ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, null, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, newValue, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceReadBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
        if (this.blkioDeviceReadBps == elements) {
            return this;
        }
        List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, newValue, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceWriteBps(HostConfig.BlkioDeviceRate ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, null, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, newValue, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceWriteBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
        if (this.blkioDeviceWriteBps == elements) {
            return this;
        }
        List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, newValue, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceReadIOps(HostConfig.BlkioDeviceRate ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, null, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, newValue, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceReadIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
        if (this.blkioDeviceReadIOps == elements) {
            return this;
        }
        List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, newValue, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceWriteIOps(HostConfig.BlkioDeviceRate ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, null, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<HostConfig.BlkioDeviceRate> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, newValue, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withBlkioDeviceWriteIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
        if (this.blkioDeviceWriteIOps == elements) {
            return this;
        }
        List<HostConfig.BlkioDeviceRate> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, newValue, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withContainerIdFile(@Nullable String value) {
        if (Objects.equals(this.containerIdFile, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, value, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withLxcConf(HostConfig.LxcConfParameter ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, null, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<HostConfig.LxcConfParameter> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, newValue, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withLxcConf(@Nullable Iterable<? extends HostConfig.LxcConfParameter> elements) {
        if (this.lxcConf == elements) {
            return this;
        }
        List<HostConfig.LxcConfParameter> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, newValue, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withPrivileged(@Nullable Boolean value) {
        if (Objects.equals(this.privileged, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, value, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withPortBindings(@Nullable Map<String, ? extends List<PortBinding>> entries) {
        if (this.portBindings == entries) {
            return this;
        }
        Map<String, List<PortBinding>> newValue = entries == null ? null : ImmutableHostConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, newValue, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withLinks(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, null, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, newValue, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withLinks(@Nullable Iterable<String> elements) {
        if (this.links == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, newValue, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withPublishAllPorts(@Nullable Boolean value) {
        if (Objects.equals(this.publishAllPorts, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, value, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDns(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, null, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, newValue, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDns(@Nullable Iterable<String> elements) {
        if (this.dns == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, newValue, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDnsOptions(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, null, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, newValue, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDnsOptions(@Nullable Iterable<String> elements) {
        if (this.dnsOptions == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, newValue, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDnsSearch(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, null, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, newValue, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDnsSearch(@Nullable Iterable<String> elements) {
        if (this.dnsSearch == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, newValue, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withExtraHosts(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, null, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, newValue, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withExtraHosts(@Nullable Iterable<String> elements) {
        if (this.extraHosts == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, newValue, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withGroupAdd(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, null, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, newValue, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withGroupAdd(@Nullable Iterable<String> elements) {
        if (this.groupAdd == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, newValue, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withVolumesFrom(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, null, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, newValue, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withVolumesFrom(@Nullable Iterable<String> elements) {
        if (this.volumesFrom == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, newValue, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCapAdd(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, null, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, newValue, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCapAdd(@Nullable Iterable<String> elements) {
        if (this.capAdd == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, newValue, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCapDrop(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, null, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, newValue, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCapDrop(@Nullable Iterable<String> elements) {
        if (this.capDrop == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, newValue, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withNetworkMode(@Nullable String value) {
        if (Objects.equals(this.networkMode, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, value, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withSecurityOpt(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, null, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, newValue, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withSecurityOpt(@Nullable Iterable<String> elements) {
        if (this.securityOpt == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, newValue, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDevices(Device ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, null, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<Device> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, newValue, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withDevices(@Nullable Iterable<? extends Device> elements) {
        if (this.devices == elements) {
            return this;
        }
        List<Device> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, newValue, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withMemory(@Nullable Long value) {
        if (Objects.equals(this.memory, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, value, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withMemorySwap(@Nullable Long value) {
        if (Objects.equals(this.memorySwap, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, value, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withKernelMemory(@Nullable Long value) {
        if (Objects.equals(this.kernelMemory, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, value, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withMemorySwappiness(@Nullable Integer value) {
        if (Objects.equals(this.memorySwappiness, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, value, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withMemoryReservation(@Nullable Long value) {
        if (Objects.equals(this.memoryReservation, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, value, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withNanoCpus(@Nullable Long value) {
        if (Objects.equals(this.nanoCpus, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, value, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCpuPeriod(@Nullable Long value) {
        if (Objects.equals(this.cpuPeriod, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, value, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCpuShares(@Nullable Long value) {
        if (Objects.equals(this.cpuShares, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, value, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCpusetCpus(@Nullable String value) {
        if (Objects.equals(this.cpusetCpus, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, value, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCpusetMems(@Nullable String value) {
        if (Objects.equals(this.cpusetMems, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, value, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCpuQuota(@Nullable Long value) {
        if (Objects.equals(this.cpuQuota, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, value, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCgroupParent(@Nullable String value) {
        if (Objects.equals(this.cgroupParent, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, value, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withRestartPolicy(@Nullable HostConfig.RestartPolicy value) {
        if (this.restartPolicy == value) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, value, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withLogConfig(@Nullable LogConfig value) {
        if (this.logConfig == value) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, value, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withIpcMode(@Nullable String value) {
        if (Objects.equals(this.ipcMode, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, value, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withUlimits(HostConfig.Ulimit ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, null, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<HostConfig.Ulimit> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, newValue, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withUlimits(@Nullable Iterable<? extends HostConfig.Ulimit> elements) {
        if (this.ulimits == elements) {
            return this;
        }
        List<HostConfig.Ulimit> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, newValue, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withPidMode(@Nullable String value) {
        if (Objects.equals(this.pidMode, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, value, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withShmSize(@Nullable Long value) {
        if (Objects.equals(this.shmSize, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, value, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withOomKillDisable(@Nullable Boolean value) {
        if (Objects.equals(this.oomKillDisable, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, value, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withOomScoreAdj(@Nullable Integer value) {
        if (Objects.equals(this.oomScoreAdj, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, value, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withAutoRemove(@Nullable Boolean value) {
        if (Objects.equals(this.autoRemove, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, value, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withPidsLimit(@Nullable Integer value) {
        if (Objects.equals(this.pidsLimit, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, value, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withTmpfs(@Nullable Map<String, ? extends String> entries) {
        if (this.tmpfs == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableHostConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, newValue, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withReadonlyRootfs(@Nullable Boolean value) {
        if (Objects.equals(this.readonlyRootfs, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, value, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withStorageOpt(@Nullable Map<String, ? extends String> entries) {
        if (this.storageOpt == entries) {
            return this;
        }
        Map<String, String> newValue = entries == null ? null : ImmutableHostConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, newValue, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withRuntime(@Nullable String value) {
        if (Objects.equals(this.runtime, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, value, this.mounts, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withMounts(Mount ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, null, this.init, this.sysctls, this.capabilities, this.deviceRequests));
        }
        List<Mount> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, newValue, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withMounts(@Nullable Iterable<? extends Mount> elements) {
        if (this.mounts == elements) {
            return this;
        }
        List<Mount> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, newValue, this.init, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withInit(@Nullable Boolean value) {
        if (Objects.equals(this.init, value)) {
            return this;
        }
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, value, this.sysctls, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withSysctls(Map<String, ? extends String> entries) {
        if (this.sysctls == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableHostConfig.createUnmodifiableMap(true, false, entries);
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, newValue, this.capabilities, this.deviceRequests));
    }

    public final ImmutableHostConfig withCapabilities(String ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, null, this.deviceRequests));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, newValue, this.deviceRequests));
    }

    public final ImmutableHostConfig withCapabilities(@Nullable Iterable<String> elements) {
        if (this.capabilities == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, newValue, this.deviceRequests));
    }

    public final ImmutableHostConfig withDeviceRequests(HostConfig.DeviceRequest ... elements) {
        if (elements == null) {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, null));
        }
        List<HostConfig.DeviceRequest> newValue = Arrays.asList(elements) == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, newValue));
    }

    public final ImmutableHostConfig withDeviceRequests(@Nullable Iterable<? extends HostConfig.DeviceRequest> elements) {
        if (this.deviceRequests == elements) {
            return this;
        }
        List<HostConfig.DeviceRequest> newValue = elements == null ? null : ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
        return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds, this.blkioWeight, this.blkioWeightDevice, this.blkioDeviceReadBps, this.blkioDeviceWriteBps, this.blkioDeviceReadIOps, this.blkioDeviceWriteIOps, this.containerIdFile, this.lxcConf, this.privileged, this.portBindings, this.links, this.publishAllPorts, this.dns, this.dnsOptions, this.dnsSearch, this.extraHosts, this.groupAdd, this.volumesFrom, this.capAdd, this.capDrop, this.networkMode, this.securityOpt, this.devices, this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits, this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs, this.readonlyRootfs, this.storageOpt, this.runtime, this.mounts, this.init, this.sysctls, this.capabilities, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableHostConfig && this.equalTo((ImmutableHostConfig)another);
    }

    private boolean equalTo(ImmutableHostConfig another) {
        return Objects.equals(this.binds, another.binds) && Objects.equals(this.blkioWeight, another.blkioWeight) && Objects.equals(this.blkioWeightDevice, another.blkioWeightDevice) && Objects.equals(this.blkioDeviceReadBps, another.blkioDeviceReadBps) && Objects.equals(this.blkioDeviceWriteBps, another.blkioDeviceWriteBps) && Objects.equals(this.blkioDeviceReadIOps, another.blkioDeviceReadIOps) && Objects.equals(this.blkioDeviceWriteIOps, another.blkioDeviceWriteIOps) && Objects.equals(this.containerIdFile, another.containerIdFile) && Objects.equals(this.lxcConf, another.lxcConf) && Objects.equals(this.privileged, another.privileged) && Objects.equals(this.portBindings, another.portBindings) && Objects.equals(this.links, another.links) && Objects.equals(this.publishAllPorts, another.publishAllPorts) && Objects.equals(this.dns, another.dns) && Objects.equals(this.dnsOptions, another.dnsOptions) && Objects.equals(this.dnsSearch, another.dnsSearch) && Objects.equals(this.extraHosts, another.extraHosts) && Objects.equals(this.groupAdd, another.groupAdd) && Objects.equals(this.volumesFrom, another.volumesFrom) && Objects.equals(this.capAdd, another.capAdd) && Objects.equals(this.capDrop, another.capDrop) && Objects.equals(this.networkMode, another.networkMode) && Objects.equals(this.securityOpt, another.securityOpt) && Objects.equals(this.devices, another.devices) && Objects.equals(this.memory, another.memory) && Objects.equals(this.memorySwap, another.memorySwap) && Objects.equals(this.kernelMemory, another.kernelMemory) && Objects.equals(this.memorySwappiness, another.memorySwappiness) && Objects.equals(this.memoryReservation, another.memoryReservation) && Objects.equals(this.nanoCpus, another.nanoCpus) && Objects.equals(this.cpuPeriod, another.cpuPeriod) && Objects.equals(this.cpuShares, another.cpuShares) && Objects.equals(this.cpusetCpus, another.cpusetCpus) && Objects.equals(this.cpusetMems, another.cpusetMems) && Objects.equals(this.cpuQuota, another.cpuQuota) && Objects.equals(this.cgroupParent, another.cgroupParent) && Objects.equals(this.restartPolicy, another.restartPolicy) && Objects.equals(this.logConfig, another.logConfig) && Objects.equals(this.ipcMode, another.ipcMode) && Objects.equals(this.ulimits, another.ulimits) && Objects.equals(this.pidMode, another.pidMode) && Objects.equals(this.shmSize, another.shmSize) && Objects.equals(this.oomKillDisable, another.oomKillDisable) && Objects.equals(this.oomScoreAdj, another.oomScoreAdj) && Objects.equals(this.autoRemove, another.autoRemove) && Objects.equals(this.pidsLimit, another.pidsLimit) && Objects.equals(this.tmpfs, another.tmpfs) && Objects.equals(this.readonlyRootfs, another.readonlyRootfs) && Objects.equals(this.storageOpt, another.storageOpt) && Objects.equals(this.runtime, another.runtime) && Objects.equals(this.mounts, another.mounts) && Objects.equals(this.init, another.init) && this.sysctls.equals(another.sysctls) && Objects.equals(this.capabilities, another.capabilities) && Objects.equals(this.deviceRequests, another.deviceRequests);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.binds);
        h += (h << 5) + Objects.hashCode(this.blkioWeight);
        h += (h << 5) + Objects.hashCode(this.blkioWeightDevice);
        h += (h << 5) + Objects.hashCode(this.blkioDeviceReadBps);
        h += (h << 5) + Objects.hashCode(this.blkioDeviceWriteBps);
        h += (h << 5) + Objects.hashCode(this.blkioDeviceReadIOps);
        h += (h << 5) + Objects.hashCode(this.blkioDeviceWriteIOps);
        h += (h << 5) + Objects.hashCode(this.containerIdFile);
        h += (h << 5) + Objects.hashCode(this.lxcConf);
        h += (h << 5) + Objects.hashCode(this.privileged);
        h += (h << 5) + Objects.hashCode(this.portBindings);
        h += (h << 5) + Objects.hashCode(this.links);
        h += (h << 5) + Objects.hashCode(this.publishAllPorts);
        h += (h << 5) + Objects.hashCode(this.dns);
        h += (h << 5) + Objects.hashCode(this.dnsOptions);
        h += (h << 5) + Objects.hashCode(this.dnsSearch);
        h += (h << 5) + Objects.hashCode(this.extraHosts);
        h += (h << 5) + Objects.hashCode(this.groupAdd);
        h += (h << 5) + Objects.hashCode(this.volumesFrom);
        h += (h << 5) + Objects.hashCode(this.capAdd);
        h += (h << 5) + Objects.hashCode(this.capDrop);
        h += (h << 5) + Objects.hashCode(this.networkMode);
        h += (h << 5) + Objects.hashCode(this.securityOpt);
        h += (h << 5) + Objects.hashCode(this.devices);
        h += (h << 5) + Objects.hashCode(this.memory);
        h += (h << 5) + Objects.hashCode(this.memorySwap);
        h += (h << 5) + Objects.hashCode(this.kernelMemory);
        h += (h << 5) + Objects.hashCode(this.memorySwappiness);
        h += (h << 5) + Objects.hashCode(this.memoryReservation);
        h += (h << 5) + Objects.hashCode(this.nanoCpus);
        h += (h << 5) + Objects.hashCode(this.cpuPeriod);
        h += (h << 5) + Objects.hashCode(this.cpuShares);
        h += (h << 5) + Objects.hashCode(this.cpusetCpus);
        h += (h << 5) + Objects.hashCode(this.cpusetMems);
        h += (h << 5) + Objects.hashCode(this.cpuQuota);
        h += (h << 5) + Objects.hashCode(this.cgroupParent);
        h += (h << 5) + Objects.hashCode(this.restartPolicy);
        h += (h << 5) + Objects.hashCode(this.logConfig);
        h += (h << 5) + Objects.hashCode(this.ipcMode);
        h += (h << 5) + Objects.hashCode(this.ulimits);
        h += (h << 5) + Objects.hashCode(this.pidMode);
        h += (h << 5) + Objects.hashCode(this.shmSize);
        h += (h << 5) + Objects.hashCode(this.oomKillDisable);
        h += (h << 5) + Objects.hashCode(this.oomScoreAdj);
        h += (h << 5) + Objects.hashCode(this.autoRemove);
        h += (h << 5) + Objects.hashCode(this.pidsLimit);
        h += (h << 5) + Objects.hashCode(this.tmpfs);
        h += (h << 5) + Objects.hashCode(this.readonlyRootfs);
        h += (h << 5) + Objects.hashCode(this.storageOpt);
        h += (h << 5) + Objects.hashCode(this.runtime);
        h += (h << 5) + Objects.hashCode(this.mounts);
        h += (h << 5) + Objects.hashCode(this.init);
        h += (h << 5) + this.sysctls.hashCode();
        h += (h << 5) + Objects.hashCode(this.capabilities);
        h += (h << 5) + Objects.hashCode(this.deviceRequests);
        return h;
    }

    public String toString() {
        return "HostConfig{binds=" + this.binds + ", blkioWeight=" + this.blkioWeight + ", blkioWeightDevice=" + this.blkioWeightDevice + ", blkioDeviceReadBps=" + this.blkioDeviceReadBps + ", blkioDeviceWriteBps=" + this.blkioDeviceWriteBps + ", blkioDeviceReadIOps=" + this.blkioDeviceReadIOps + ", blkioDeviceWriteIOps=" + this.blkioDeviceWriteIOps + ", containerIdFile=" + this.containerIdFile + ", lxcConf=" + this.lxcConf + ", privileged=" + this.privileged + ", portBindings=" + this.portBindings + ", links=" + this.links + ", publishAllPorts=" + this.publishAllPorts + ", dns=" + this.dns + ", dnsOptions=" + this.dnsOptions + ", dnsSearch=" + this.dnsSearch + ", extraHosts=" + this.extraHosts + ", groupAdd=" + this.groupAdd + ", volumesFrom=" + this.volumesFrom + ", capAdd=" + this.capAdd + ", capDrop=" + this.capDrop + ", networkMode=" + this.networkMode + ", securityOpt=" + this.securityOpt + ", devices=" + this.devices + ", memory=" + this.memory + ", memorySwap=" + this.memorySwap + ", kernelMemory=" + this.kernelMemory + ", memorySwappiness=" + this.memorySwappiness + ", memoryReservation=" + this.memoryReservation + ", nanoCpus=" + this.nanoCpus + ", cpuPeriod=" + this.cpuPeriod + ", cpuShares=" + this.cpuShares + ", cpusetCpus=" + this.cpusetCpus + ", cpusetMems=" + this.cpusetMems + ", cpuQuota=" + this.cpuQuota + ", cgroupParent=" + this.cgroupParent + ", restartPolicy=" + this.restartPolicy + ", logConfig=" + this.logConfig + ", ipcMode=" + this.ipcMode + ", ulimits=" + this.ulimits + ", pidMode=" + this.pidMode + ", shmSize=" + this.shmSize + ", oomKillDisable=" + this.oomKillDisable + ", oomScoreAdj=" + this.oomScoreAdj + ", autoRemove=" + this.autoRemove + ", pidsLimit=" + this.pidsLimit + ", tmpfs=" + this.tmpfs + ", readonlyRootfs=" + this.readonlyRootfs + ", storageOpt=" + this.storageOpt + ", runtime=" + this.runtime + ", mounts=" + this.mounts + ", init=" + this.init + ", sysctls=" + this.sysctls + ", capabilities=" + this.capabilities + ", deviceRequests=" + this.deviceRequests + "}";
    }

    private static ImmutableHostConfig validate(ImmutableHostConfig instance) {
        instance.check();
        return instance;
    }

    public static ImmutableHostConfig copyOf(HostConfig instance) {
        if (instance instanceof ImmutableHostConfig) {
            return (ImmutableHostConfig)instance;
        }
        return ImmutableHostConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    static final class Bind
    implements HostConfig.Bind {
        private final String to;
        private final String from;
        private final boolean readOnly;
        @Nullable
        private final Boolean noCopy;
        @Nullable
        private final Boolean selinuxLabeling;
        private final transient String representation;
        private static final byte STAGE_INITIALIZING = -1;
        private static final byte STAGE_UNINITIALIZED = 0;
        private static final byte STAGE_INITIALIZED = 1;
        private volatile transient InitShim initShim = new InitShim();

        private Bind(Builder builder) {
            this.to = builder.to;
            this.from = builder.from;
            this.noCopy = builder.noCopy;
            this.selinuxLabeling = builder.selinuxLabeling;
            if (builder.readOnlyIsSet()) {
                this.initShim.readOnly(builder.readOnly);
            }
            this.readOnly = this.initShim.readOnly();
            this.representation = this.initShim.representation();
            this.initShim = null;
        }

        private Bind(String to, String from, boolean readOnly, @Nullable Boolean noCopy, @Nullable Boolean selinuxLabeling) {
            this.to = to;
            this.from = from;
            this.initShim.readOnly(readOnly);
            this.noCopy = noCopy;
            this.selinuxLabeling = selinuxLabeling;
            this.readOnly = this.initShim.readOnly();
            this.representation = this.initShim.representation();
            this.initShim = null;
        }

        private boolean readOnlyInitialize() {
            return HostConfig.Bind.super.readOnly();
        }

        private String representationInitialize() {
            return HostConfig.Bind.super.representation();
        }

        @Override
        @JsonProperty(value="to")
        public String to() {
            return this.to;
        }

        @Override
        @JsonProperty(value="from")
        public String from() {
            return this.from;
        }

        @Override
        @JsonProperty(value="readOnly")
        public boolean readOnly() {
            InitShim shim = this.initShim;
            return shim != null ? shim.readOnly() : this.readOnly;
        }

        @Override
        @JsonProperty(value="noCopy")
        @Nullable
        public Boolean noCopy() {
            return this.noCopy;
        }

        @Override
        @JsonProperty(value="selinuxLabeling")
        @Nullable
        public Boolean selinuxLabeling() {
            return this.selinuxLabeling;
        }

        @Override
        @JsonProperty(value="representation")
        @JsonIgnore
        public String representation() {
            InitShim shim = this.initShim;
            return shim != null ? shim.representation() : this.representation;
        }

        public final Bind withTo(String value) {
            String newValue = Objects.requireNonNull(value, "to");
            if (this.to.equals(newValue)) {
                return this;
            }
            return new Bind(newValue, this.from, this.readOnly, this.noCopy, this.selinuxLabeling);
        }

        public final Bind withFrom(String value) {
            String newValue = Objects.requireNonNull(value, "from");
            if (this.from.equals(newValue)) {
                return this;
            }
            return new Bind(this.to, newValue, this.readOnly, this.noCopy, this.selinuxLabeling);
        }

        public final Bind withReadOnly(boolean value) {
            if (this.readOnly == value) {
                return this;
            }
            return new Bind(this.to, this.from, value, this.noCopy, this.selinuxLabeling);
        }

        public final Bind withNoCopy(@Nullable Boolean value) {
            if (Objects.equals(this.noCopy, value)) {
                return this;
            }
            return new Bind(this.to, this.from, this.readOnly, value, this.selinuxLabeling);
        }

        public final Bind withSelinuxLabeling(@Nullable Boolean value) {
            if (Objects.equals(this.selinuxLabeling, value)) {
                return this;
            }
            return new Bind(this.to, this.from, this.readOnly, this.noCopy, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Bind && this.equalTo((Bind)another);
        }

        private boolean equalTo(Bind another) {
            return this.to.equals(another.to) && this.from.equals(another.from) && this.readOnly == another.readOnly && Objects.equals(this.noCopy, another.noCopy) && Objects.equals(this.selinuxLabeling, another.selinuxLabeling) && this.representation.equals(another.representation);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.to.hashCode();
            h += (h << 5) + this.from.hashCode();
            h += (h << 5) + Boolean.hashCode(this.readOnly);
            h += (h << 5) + Objects.hashCode(this.noCopy);
            h += (h << 5) + Objects.hashCode(this.selinuxLabeling);
            h += (h << 5) + this.representation.hashCode();
            return h;
        }

        public String toString() {
            return "Bind{to=" + this.to + ", from=" + this.from + ", readOnly=" + this.readOnly + ", noCopy=" + this.noCopy + ", selinuxLabeling=" + this.selinuxLabeling + ", representation=" + this.representation + "}";
        }

        public static Bind copyOf(HostConfig.Bind instance) {
            if (instance instanceof Bind) {
                return (Bind)instance;
            }
            return Bind.builder().to(instance.to()).from(instance.from()).readOnly(instance.readOnly()).noCopy(instance.noCopy()).selinuxLabeling(instance.selinuxLabeling()).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements HostConfig.Bind.Builder {
            private static final long INIT_BIT_TO = 1L;
            private static final long INIT_BIT_FROM = 2L;
            private static final long OPT_BIT_READ_ONLY = 1L;
            private long initBits = 3L;
            private long optBits;
            private String to;
            private String from;
            private boolean readOnly;
            private Boolean noCopy;
            private Boolean selinuxLabeling;

            private Builder() {
            }

            @Override
            @JsonProperty(value="to")
            public final Builder to(String to) {
                this.to = Objects.requireNonNull(to, "to");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @Override
            @JsonProperty(value="from")
            public final Builder from(String from) {
                this.from = Objects.requireNonNull(from, "from");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @Override
            @JsonProperty(value="readOnly")
            public final Builder readOnly(boolean readOnly) {
                this.readOnly = readOnly;
                this.optBits |= 1L;
                return this;
            }

            @Override
            @JsonProperty(value="noCopy")
            public final Builder noCopy(@Nullable Boolean noCopy) {
                this.noCopy = noCopy;
                return this;
            }

            @Override
            @JsonProperty(value="selinuxLabeling")
            public final Builder selinuxLabeling(@Nullable Boolean selinuxLabeling) {
                this.selinuxLabeling = selinuxLabeling;
                return this;
            }

            @Override
            public Bind build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Bind(this);
            }

            private boolean readOnlyIsSet() {
                return (this.optBits & 1L) != 0L;
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("to");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("from");
                }
                return "Cannot build Bind, some of required attributes are not set " + attributes;
            }
        }

        private final class InitShim {
            private byte readOnlyBuildStage = 0;
            private boolean readOnly;
            private byte representationBuildStage = 0;
            private String representation;

            private InitShim() {
            }

            boolean readOnly() {
                if (this.readOnlyBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.readOnlyBuildStage == 0) {
                    this.readOnlyBuildStage = (byte)-1;
                    this.readOnly = Bind.this.readOnlyInitialize();
                    this.readOnlyBuildStage = 1;
                }
                return this.readOnly;
            }

            void readOnly(boolean readOnly) {
                this.readOnly = readOnly;
                this.readOnlyBuildStage = 1;
            }

            String representation() {
                if (this.representationBuildStage == -1) {
                    throw new IllegalStateException(this.formatInitCycleMessage());
                }
                if (this.representationBuildStage == 0) {
                    this.representationBuildStage = (byte)-1;
                    this.representation = Objects.requireNonNull(Bind.this.representationInitialize(), "representation");
                    this.representationBuildStage = 1;
                }
                return this.representation;
            }

            private String formatInitCycleMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if (this.readOnlyBuildStage == -1) {
                    attributes.add("readOnly");
                }
                if (this.representationBuildStage == -1) {
                    attributes.add("representation");
                }
                return "Cannot build Bind, attribute initializers form cycle " + attributes;
            }
        }
    }

    static final class BlkioDeviceRate
    implements HostConfig.BlkioDeviceRate {
        private final String path;
        private final Integer rate;

        private BlkioDeviceRate(String path, Integer rate) {
            this.path = path;
            this.rate = rate;
        }

        @Override
        @JsonProperty(value="Path")
        public String path() {
            return this.path;
        }

        @Override
        @JsonProperty(value="Rate")
        public Integer rate() {
            return this.rate;
        }

        public final BlkioDeviceRate withPath(String value) {
            String newValue = Objects.requireNonNull(value, "path");
            if (this.path.equals(newValue)) {
                return this;
            }
            return new BlkioDeviceRate(newValue, this.rate);
        }

        public final BlkioDeviceRate withRate(Integer value) {
            Integer newValue = Objects.requireNonNull(value, "rate");
            if (this.rate.equals(newValue)) {
                return this;
            }
            return new BlkioDeviceRate(this.path, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof BlkioDeviceRate && this.equalTo((BlkioDeviceRate)another);
        }

        private boolean equalTo(BlkioDeviceRate another) {
            return this.path.equals(another.path) && this.rate.equals(another.rate);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.path.hashCode();
            h += (h << 5) + this.rate.hashCode();
            return h;
        }

        public String toString() {
            return "BlkioDeviceRate{path=" + this.path + ", rate=" + this.rate + "}";
        }

        public static BlkioDeviceRate copyOf(HostConfig.BlkioDeviceRate instance) {
            if (instance instanceof BlkioDeviceRate) {
                return (BlkioDeviceRate)instance;
            }
            return BlkioDeviceRate.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements HostConfig.BlkioDeviceRate.Builder {
            private static final long INIT_BIT_PATH = 1L;
            private static final long INIT_BIT_RATE = 2L;
            private long initBits = 3L;
            private String path;
            private Integer rate;

            private Builder() {
            }

            public final Builder from(HostConfig.BlkioDeviceRate instance) {
                Objects.requireNonNull(instance, "instance");
                this.path(instance.path());
                this.rate(instance.rate());
                return this;
            }

            @Override
            @JsonProperty(value="Path")
            public final Builder path(String path) {
                this.path = Objects.requireNonNull(path, "path");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @Override
            @JsonProperty(value="Rate")
            public final Builder rate(Integer rate) {
                this.rate = Objects.requireNonNull(rate, "rate");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @Override
            public BlkioDeviceRate build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new BlkioDeviceRate(this.path, this.rate);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("path");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("rate");
                }
                return "Cannot build BlkioDeviceRate, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class BlkioWeightDevice
    implements HostConfig.BlkioWeightDevice {
        private final String path;
        private final Integer weight;

        private BlkioWeightDevice(String path, Integer weight) {
            this.path = path;
            this.weight = weight;
        }

        @Override
        @JsonProperty(value="Path")
        public String path() {
            return this.path;
        }

        @Override
        @JsonProperty(value="Weight")
        public Integer weight() {
            return this.weight;
        }

        public final BlkioWeightDevice withPath(String value) {
            String newValue = Objects.requireNonNull(value, "path");
            if (this.path.equals(newValue)) {
                return this;
            }
            return new BlkioWeightDevice(newValue, this.weight);
        }

        public final BlkioWeightDevice withWeight(Integer value) {
            Integer newValue = Objects.requireNonNull(value, "weight");
            if (this.weight.equals(newValue)) {
                return this;
            }
            return new BlkioWeightDevice(this.path, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof BlkioWeightDevice && this.equalTo((BlkioWeightDevice)another);
        }

        private boolean equalTo(BlkioWeightDevice another) {
            return this.path.equals(another.path) && this.weight.equals(another.weight);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.path.hashCode();
            h += (h << 5) + this.weight.hashCode();
            return h;
        }

        public String toString() {
            return "BlkioWeightDevice{path=" + this.path + ", weight=" + this.weight + "}";
        }

        public static BlkioWeightDevice copyOf(HostConfig.BlkioWeightDevice instance) {
            if (instance instanceof BlkioWeightDevice) {
                return (BlkioWeightDevice)instance;
            }
            return BlkioWeightDevice.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements HostConfig.BlkioWeightDevice.Builder {
            private static final long INIT_BIT_PATH = 1L;
            private static final long INIT_BIT_WEIGHT = 2L;
            private long initBits = 3L;
            private String path;
            private Integer weight;

            private Builder() {
            }

            public final Builder from(HostConfig.BlkioWeightDevice instance) {
                Objects.requireNonNull(instance, "instance");
                this.path(instance.path());
                this.weight(instance.weight());
                return this;
            }

            @Override
            @JsonProperty(value="Path")
            public final Builder path(String path) {
                this.path = Objects.requireNonNull(path, "path");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @Override
            @JsonProperty(value="Weight")
            public final Builder weight(Integer weight) {
                this.weight = Objects.requireNonNull(weight, "weight");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @Override
            public BlkioWeightDevice build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new BlkioWeightDevice(this.path, this.weight);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("path");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("weight");
                }
                return "Cannot build BlkioWeightDevice, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class Builder
    implements HostConfig.Builder {
        private List<String> binds = null;
        private Integer blkioWeight;
        private List<HostConfig.BlkioWeightDevice> blkioWeightDevice = null;
        private List<HostConfig.BlkioDeviceRate> blkioDeviceReadBps = null;
        private List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBps = null;
        private List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOps = null;
        private List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOps = null;
        private String containerIdFile;
        private List<HostConfig.LxcConfParameter> lxcConf = null;
        private Boolean privileged;
        private Map<String, List<PortBinding>> portBindings = null;
        private List<String> links = null;
        private Boolean publishAllPorts;
        private List<String> dns = null;
        private List<String> dnsOptions = null;
        private List<String> dnsSearch = null;
        private List<String> extraHosts = null;
        private List<String> groupAdd = null;
        private List<String> volumesFrom = null;
        private List<String> capAdd = null;
        private List<String> capDrop = null;
        private String networkMode;
        private List<String> securityOpt = null;
        private List<Device> devices = null;
        private Long memory;
        private Long memorySwap;
        private Long kernelMemory;
        private Integer memorySwappiness;
        private Long memoryReservation;
        private Long nanoCpus;
        private Long cpuPeriod;
        private Long cpuShares;
        private String cpusetCpus;
        private String cpusetMems;
        private Long cpuQuota;
        private String cgroupParent;
        private HostConfig.RestartPolicy restartPolicy;
        private LogConfig logConfig;
        private String ipcMode;
        private List<HostConfig.Ulimit> ulimits = null;
        private String pidMode;
        private Long shmSize;
        private Boolean oomKillDisable;
        private Integer oomScoreAdj;
        private Boolean autoRemove;
        private Integer pidsLimit;
        private Map<String, String> tmpfs = null;
        private Boolean readonlyRootfs;
        private Map<String, String> storageOpt = null;
        private String runtime;
        private List<Mount> mounts = null;
        private Boolean init;
        private Map<String, String> sysctls = new LinkedHashMap<String, String>();
        private List<String> capabilities = null;
        private List<HostConfig.DeviceRequest> deviceRequests = null;

        private Builder() {
        }

        public final Builder from(HostConfig instance) {
            List<HostConfig.DeviceRequest> deviceRequestsValue;
            Boolean initValue;
            List<Mount> mountsValue;
            String runtimeValue;
            Map<String, String> storageOptValue;
            Boolean readonlyRootfsValue;
            Map<String, String> tmpfsValue;
            Integer pidsLimitValue;
            Boolean autoRemoveValue;
            Integer oomScoreAdjValue;
            Boolean oomKillDisableValue;
            Long shmSizeValue;
            String pidModeValue;
            List<HostConfig.Ulimit> ulimitsValue;
            String ipcModeValue;
            LogConfig logConfigValue;
            HostConfig.RestartPolicy restartPolicyValue;
            String cgroupParentValue;
            Long cpuQuotaValue;
            String cpusetMemsValue;
            String cpusetCpusValue;
            Long cpuSharesValue;
            Long cpuPeriodValue;
            Long nanoCpusValue;
            Long memoryReservationValue;
            Integer memorySwappinessValue;
            Long kernelMemoryValue;
            Long memorySwapValue;
            Long memoryValue;
            List<Device> devicesValue;
            List<String> securityOptValue;
            String networkModeValue;
            List<String> capDropValue;
            List<String> capAddValue;
            List<String> volumesFromValue;
            List<String> groupAddValue;
            List<String> extraHostsValue;
            List<String> dnsSearchValue;
            List<String> dnsOptionsValue;
            List<String> dnsValue;
            Boolean publishAllPortsValue;
            List<String> linksValue;
            Map<String, List<PortBinding>> portBindingsValue;
            Boolean privilegedValue;
            List<HostConfig.LxcConfParameter> lxcConfValue;
            String containerIdFileValue;
            List<HostConfig.BlkioDeviceRate> blkioDeviceWriteIOpsValue;
            List<HostConfig.BlkioDeviceRate> blkioDeviceReadIOpsValue;
            List<HostConfig.BlkioDeviceRate> blkioDeviceWriteBpsValue;
            List<HostConfig.BlkioDeviceRate> blkioDeviceReadBpsValue;
            List<HostConfig.BlkioWeightDevice> blkioWeightDeviceValue;
            Integer blkioWeightValue;
            Objects.requireNonNull(instance, "instance");
            List<String> bindsValue = instance.binds();
            if (bindsValue != null) {
                this.addAllBinds(bindsValue);
            }
            if ((blkioWeightValue = instance.blkioWeight()) != null) {
                this.blkioWeight(blkioWeightValue);
            }
            if ((blkioWeightDeviceValue = instance.blkioWeightDevice()) != null) {
                this.addAllBlkioWeightDevice(blkioWeightDeviceValue);
            }
            if ((blkioDeviceReadBpsValue = instance.blkioDeviceReadBps()) != null) {
                this.addAllBlkioDeviceReadBps(blkioDeviceReadBpsValue);
            }
            if ((blkioDeviceWriteBpsValue = instance.blkioDeviceWriteBps()) != null) {
                this.addAllBlkioDeviceWriteBps(blkioDeviceWriteBpsValue);
            }
            if ((blkioDeviceReadIOpsValue = instance.blkioDeviceReadIOps()) != null) {
                this.addAllBlkioDeviceReadIOps(blkioDeviceReadIOpsValue);
            }
            if ((blkioDeviceWriteIOpsValue = instance.blkioDeviceWriteIOps()) != null) {
                this.addAllBlkioDeviceWriteIOps(blkioDeviceWriteIOpsValue);
            }
            if ((containerIdFileValue = instance.containerIdFile()) != null) {
                this.containerIdFile(containerIdFileValue);
            }
            if ((lxcConfValue = instance.lxcConf()) != null) {
                this.addAllLxcConf(lxcConfValue);
            }
            if ((privilegedValue = instance.privileged()) != null) {
                this.privileged(privilegedValue);
            }
            if ((portBindingsValue = instance.portBindings()) != null) {
                this.putAllPortBindings(portBindingsValue);
            }
            if ((linksValue = instance.links()) != null) {
                this.addAllLinks(linksValue);
            }
            if ((publishAllPortsValue = instance.publishAllPorts()) != null) {
                this.publishAllPorts(publishAllPortsValue);
            }
            if ((dnsValue = instance.dns()) != null) {
                this.addAllDns(dnsValue);
            }
            if ((dnsOptionsValue = instance.dnsOptions()) != null) {
                this.addAllDnsOptions(dnsOptionsValue);
            }
            if ((dnsSearchValue = instance.dnsSearch()) != null) {
                this.addAllDnsSearch(dnsSearchValue);
            }
            if ((extraHostsValue = instance.extraHosts()) != null) {
                this.addAllExtraHosts(extraHostsValue);
            }
            if ((groupAddValue = instance.groupAdd()) != null) {
                this.addAllGroupAdd(groupAddValue);
            }
            if ((volumesFromValue = instance.volumesFrom()) != null) {
                this.addAllVolumesFrom(volumesFromValue);
            }
            if ((capAddValue = instance.capAdd()) != null) {
                this.addAllCapAdd(capAddValue);
            }
            if ((capDropValue = instance.capDrop()) != null) {
                this.addAllCapDrop(capDropValue);
            }
            if ((networkModeValue = instance.networkMode()) != null) {
                this.networkMode(networkModeValue);
            }
            if ((securityOptValue = instance.securityOpt()) != null) {
                this.addAllSecurityOpt(securityOptValue);
            }
            if ((devicesValue = instance.devices()) != null) {
                this.addAllDevices(devicesValue);
            }
            if ((memoryValue = instance.memory()) != null) {
                this.memory(memoryValue);
            }
            if ((memorySwapValue = instance.memorySwap()) != null) {
                this.memorySwap(memorySwapValue);
            }
            if ((kernelMemoryValue = instance.kernelMemory()) != null) {
                this.kernelMemory(kernelMemoryValue);
            }
            if ((memorySwappinessValue = instance.memorySwappiness()) != null) {
                this.memorySwappiness(memorySwappinessValue);
            }
            if ((memoryReservationValue = instance.memoryReservation()) != null) {
                this.memoryReservation(memoryReservationValue);
            }
            if ((nanoCpusValue = instance.nanoCpus()) != null) {
                this.nanoCpus(nanoCpusValue);
            }
            if ((cpuPeriodValue = instance.cpuPeriod()) != null) {
                this.cpuPeriod(cpuPeriodValue);
            }
            if ((cpuSharesValue = instance.cpuShares()) != null) {
                this.cpuShares(cpuSharesValue);
            }
            if ((cpusetCpusValue = instance.cpusetCpus()) != null) {
                this.cpusetCpus(cpusetCpusValue);
            }
            if ((cpusetMemsValue = instance.cpusetMems()) != null) {
                this.cpusetMems(cpusetMemsValue);
            }
            if ((cpuQuotaValue = instance.cpuQuota()) != null) {
                this.cpuQuota(cpuQuotaValue);
            }
            if ((cgroupParentValue = instance.cgroupParent()) != null) {
                this.cgroupParent(cgroupParentValue);
            }
            if ((restartPolicyValue = instance.restartPolicy()) != null) {
                this.restartPolicy(restartPolicyValue);
            }
            if ((logConfigValue = instance.logConfig()) != null) {
                this.logConfig(logConfigValue);
            }
            if ((ipcModeValue = instance.ipcMode()) != null) {
                this.ipcMode(ipcModeValue);
            }
            if ((ulimitsValue = instance.ulimits()) != null) {
                this.addAllUlimits(ulimitsValue);
            }
            if ((pidModeValue = instance.pidMode()) != null) {
                this.pidMode(pidModeValue);
            }
            if ((shmSizeValue = instance.shmSize()) != null) {
                this.shmSize(shmSizeValue);
            }
            if ((oomKillDisableValue = instance.oomKillDisable()) != null) {
                this.oomKillDisable(oomKillDisableValue);
            }
            if ((oomScoreAdjValue = instance.oomScoreAdj()) != null) {
                this.oomScoreAdj(oomScoreAdjValue);
            }
            if ((autoRemoveValue = instance.autoRemove()) != null) {
                this.autoRemove(autoRemoveValue);
            }
            if ((pidsLimitValue = instance.pidsLimit()) != null) {
                this.pidsLimit(pidsLimitValue);
            }
            if ((tmpfsValue = instance.tmpfs()) != null) {
                this.putAllTmpfs(tmpfsValue);
            }
            if ((readonlyRootfsValue = instance.readonlyRootfs()) != null) {
                this.readonlyRootfs(readonlyRootfsValue);
            }
            if ((storageOptValue = instance.storageOpt()) != null) {
                this.putAllStorageOpt(storageOptValue);
            }
            if ((runtimeValue = instance.runtime()) != null) {
                this.runtime(runtimeValue);
            }
            if ((mountsValue = instance.mounts()) != null) {
                this.addAllMounts(mountsValue);
            }
            if ((initValue = instance.init()) != null) {
                this.init(initValue);
            }
            this.putAllSysctls(instance.sysctls());
            List<String> capabilitiesValue = instance.capabilities();
            if (capabilitiesValue != null) {
                this.addAllCapabilities(capabilitiesValue);
            }
            if ((deviceRequestsValue = instance.deviceRequests()) != null) {
                this.addAllDeviceRequests(deviceRequestsValue);
            }
            return this;
        }

        public final Builder bind(String element) {
            if (this.binds == null) {
                this.binds = new ArrayList<String>();
            }
            this.binds.add(Objects.requireNonNull(element, "binds element"));
            return this;
        }

        @Override
        public final Builder binds(String ... elements) {
            if (this.binds == null) {
                this.binds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.binds.add(Objects.requireNonNull(element, "binds element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Binds")
        public final Builder binds(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.binds = null;
                return this;
            }
            this.binds = new ArrayList<String>();
            return this.addAllBinds(elements);
        }

        public final Builder addAllBinds(Iterable<String> elements) {
            Objects.requireNonNull(elements, "binds element");
            if (this.binds == null) {
                this.binds = new ArrayList<String>();
            }
            for (String element : elements) {
                this.binds.add(Objects.requireNonNull(element, "binds element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="BlkioWeight")
        public final Builder blkioWeight(@Nullable Integer blkioWeight) {
            this.blkioWeight = blkioWeight;
            return this;
        }

        public final Builder blkioWeightDevice(HostConfig.BlkioWeightDevice element) {
            if (this.blkioWeightDevice == null) {
                this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
            }
            this.blkioWeightDevice.add(Objects.requireNonNull(element, "blkioWeightDevice element"));
            return this;
        }

        public final Builder blkioWeightDevice(HostConfig.BlkioWeightDevice ... elements) {
            if (this.blkioWeightDevice == null) {
                this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
            }
            for (HostConfig.BlkioWeightDevice element : elements) {
                this.blkioWeightDevice.add(Objects.requireNonNull(element, "blkioWeightDevice element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="BlkioWeightDevice")
        public final Builder blkioWeightDevice(@Nullable Iterable<? extends HostConfig.BlkioWeightDevice> elements) {
            if (elements == null) {
                this.blkioWeightDevice = null;
                return this;
            }
            this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
            return this.addAllBlkioWeightDevice(elements);
        }

        public final Builder addAllBlkioWeightDevice(Iterable<? extends HostConfig.BlkioWeightDevice> elements) {
            Objects.requireNonNull(elements, "blkioWeightDevice element");
            if (this.blkioWeightDevice == null) {
                this.blkioWeightDevice = new ArrayList<HostConfig.BlkioWeightDevice>();
            }
            for (HostConfig.BlkioWeightDevice blkioWeightDevice : elements) {
                this.blkioWeightDevice.add(Objects.requireNonNull(blkioWeightDevice, "blkioWeightDevice element"));
            }
            return this;
        }

        public final Builder blkioDeviceReadBp(HostConfig.BlkioDeviceRate element) {
            if (this.blkioDeviceReadBps == null) {
                this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            this.blkioDeviceReadBps.add(Objects.requireNonNull(element, "blkioDeviceReadBps element"));
            return this;
        }

        public final Builder blkioDeviceReadBps(HostConfig.BlkioDeviceRate ... elements) {
            if (this.blkioDeviceReadBps == null) {
                this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate element : elements) {
                this.blkioDeviceReadBps.add(Objects.requireNonNull(element, "blkioDeviceReadBps element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="BlkioDeviceReadBps")
        public final Builder blkioDeviceReadBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            if (elements == null) {
                this.blkioDeviceReadBps = null;
                return this;
            }
            this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            return this.addAllBlkioDeviceReadBps(elements);
        }

        public final Builder addAllBlkioDeviceReadBps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            Objects.requireNonNull(elements, "blkioDeviceReadBps element");
            if (this.blkioDeviceReadBps == null) {
                this.blkioDeviceReadBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : elements) {
                this.blkioDeviceReadBps.add(Objects.requireNonNull(blkioDeviceRate, "blkioDeviceReadBps element"));
            }
            return this;
        }

        public final Builder blkioDeviceWriteBp(HostConfig.BlkioDeviceRate element) {
            if (this.blkioDeviceWriteBps == null) {
                this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            this.blkioDeviceWriteBps.add(Objects.requireNonNull(element, "blkioDeviceWriteBps element"));
            return this;
        }

        public final Builder blkioDeviceWriteBps(HostConfig.BlkioDeviceRate ... elements) {
            if (this.blkioDeviceWriteBps == null) {
                this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate element : elements) {
                this.blkioDeviceWriteBps.add(Objects.requireNonNull(element, "blkioDeviceWriteBps element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="BlkioDeviceWriteBps")
        public final Builder blkioDeviceWriteBps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            if (elements == null) {
                this.blkioDeviceWriteBps = null;
                return this;
            }
            this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            return this.addAllBlkioDeviceWriteBps(elements);
        }

        public final Builder addAllBlkioDeviceWriteBps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            Objects.requireNonNull(elements, "blkioDeviceWriteBps element");
            if (this.blkioDeviceWriteBps == null) {
                this.blkioDeviceWriteBps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : elements) {
                this.blkioDeviceWriteBps.add(Objects.requireNonNull(blkioDeviceRate, "blkioDeviceWriteBps element"));
            }
            return this;
        }

        public final Builder blkioDeviceReadIOp(HostConfig.BlkioDeviceRate element) {
            if (this.blkioDeviceReadIOps == null) {
                this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            this.blkioDeviceReadIOps.add(Objects.requireNonNull(element, "blkioDeviceReadIOps element"));
            return this;
        }

        public final Builder blkioDeviceReadIOps(HostConfig.BlkioDeviceRate ... elements) {
            if (this.blkioDeviceReadIOps == null) {
                this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate element : elements) {
                this.blkioDeviceReadIOps.add(Objects.requireNonNull(element, "blkioDeviceReadIOps element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="BlkioDeviceReadIOps")
        public final Builder blkioDeviceReadIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            if (elements == null) {
                this.blkioDeviceReadIOps = null;
                return this;
            }
            this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            return this.addAllBlkioDeviceReadIOps(elements);
        }

        public final Builder addAllBlkioDeviceReadIOps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            Objects.requireNonNull(elements, "blkioDeviceReadIOps element");
            if (this.blkioDeviceReadIOps == null) {
                this.blkioDeviceReadIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : elements) {
                this.blkioDeviceReadIOps.add(Objects.requireNonNull(blkioDeviceRate, "blkioDeviceReadIOps element"));
            }
            return this;
        }

        public final Builder blkioDeviceWriteIOp(HostConfig.BlkioDeviceRate element) {
            if (this.blkioDeviceWriteIOps == null) {
                this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            this.blkioDeviceWriteIOps.add(Objects.requireNonNull(element, "blkioDeviceWriteIOps element"));
            return this;
        }

        public final Builder blkioDeviceWriteIOps(HostConfig.BlkioDeviceRate ... elements) {
            if (this.blkioDeviceWriteIOps == null) {
                this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate element : elements) {
                this.blkioDeviceWriteIOps.add(Objects.requireNonNull(element, "blkioDeviceWriteIOps element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="BlkioDeviceWriteIOps")
        public final Builder blkioDeviceWriteIOps(@Nullable Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            if (elements == null) {
                this.blkioDeviceWriteIOps = null;
                return this;
            }
            this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            return this.addAllBlkioDeviceWriteIOps(elements);
        }

        public final Builder addAllBlkioDeviceWriteIOps(Iterable<? extends HostConfig.BlkioDeviceRate> elements) {
            Objects.requireNonNull(elements, "blkioDeviceWriteIOps element");
            if (this.blkioDeviceWriteIOps == null) {
                this.blkioDeviceWriteIOps = new ArrayList<HostConfig.BlkioDeviceRate>();
            }
            for (HostConfig.BlkioDeviceRate blkioDeviceRate : elements) {
                this.blkioDeviceWriteIOps.add(Objects.requireNonNull(blkioDeviceRate, "blkioDeviceWriteIOps element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="ContainerIDFile")
        public final Builder containerIdFile(@Nullable String containerIdFile) {
            this.containerIdFile = containerIdFile;
            return this;
        }

        public final Builder lxcConf(HostConfig.LxcConfParameter element) {
            if (this.lxcConf == null) {
                this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
            }
            this.lxcConf.add(Objects.requireNonNull(element, "lxcConf element"));
            return this;
        }

        @Override
        public final Builder lxcConf(HostConfig.LxcConfParameter ... elements) {
            if (this.lxcConf == null) {
                this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
            }
            for (HostConfig.LxcConfParameter element : elements) {
                this.lxcConf.add(Objects.requireNonNull(element, "lxcConf element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="LxcConf")
        public final Builder lxcConf(@Nullable Iterable<? extends HostConfig.LxcConfParameter> elements) {
            if (elements == null) {
                this.lxcConf = null;
                return this;
            }
            this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
            return this.addAllLxcConf(elements);
        }

        public final Builder addAllLxcConf(Iterable<? extends HostConfig.LxcConfParameter> elements) {
            Objects.requireNonNull(elements, "lxcConf element");
            if (this.lxcConf == null) {
                this.lxcConf = new ArrayList<HostConfig.LxcConfParameter>();
            }
            for (HostConfig.LxcConfParameter lxcConfParameter : elements) {
                this.lxcConf.add(Objects.requireNonNull(lxcConfParameter, "lxcConf element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Privileged")
        public final Builder privileged(@Nullable Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Builder addPortBinding(String key, List<PortBinding> value) {
            if (this.portBindings == null) {
                this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
            }
            this.portBindings.put(Objects.requireNonNull(key, "portBindings key"), Objects.requireNonNull(value, "portBindings value"));
            return this;
        }

        public final Builder addPortBinding(Map.Entry<String, ? extends List<PortBinding>> entry) {
            if (this.portBindings == null) {
                this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
            }
            String k = entry.getKey();
            List<PortBinding> v = entry.getValue();
            this.portBindings.put(Objects.requireNonNull(k, "portBindings key"), Objects.requireNonNull(v, "portBindings value"));
            return this;
        }

        @Override
        @JsonProperty(value="PortBindings")
        public final Builder portBindings(@Nullable Map<String, ? extends List<PortBinding>> entries) {
            if (entries == null) {
                this.portBindings = null;
                return this;
            }
            this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
            return this.putAllPortBindings(entries);
        }

        public final Builder putAllPortBindings(Map<String, ? extends List<PortBinding>> entries) {
            if (this.portBindings == null) {
                this.portBindings = new LinkedHashMap<String, List<PortBinding>>();
            }
            for (Map.Entry<String, ? extends List<PortBinding>> e : entries.entrySet()) {
                String k = e.getKey();
                List<PortBinding> v = e.getValue();
                this.portBindings.put(Objects.requireNonNull(k, "portBindings key"), Objects.requireNonNull(v, "portBindings value"));
            }
            return this;
        }

        public final Builder link(String element) {
            if (this.links == null) {
                this.links = new ArrayList<String>();
            }
            this.links.add(Objects.requireNonNull(element, "links element"));
            return this;
        }

        @Override
        public final Builder links(String ... elements) {
            if (this.links == null) {
                this.links = new ArrayList<String>();
            }
            for (String element : elements) {
                this.links.add(Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Links")
        public final Builder links(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.links = null;
                return this;
            }
            this.links = new ArrayList<String>();
            return this.addAllLinks(elements);
        }

        public final Builder addAllLinks(Iterable<String> elements) {
            Objects.requireNonNull(elements, "links element");
            if (this.links == null) {
                this.links = new ArrayList<String>();
            }
            for (String element : elements) {
                this.links.add(Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="PublishAllPorts")
        public final Builder publishAllPorts(@Nullable Boolean publishAllPorts) {
            this.publishAllPorts = publishAllPorts;
            return this;
        }

        public final Builder dn(String element) {
            if (this.dns == null) {
                this.dns = new ArrayList<String>();
            }
            this.dns.add(Objects.requireNonNull(element, "dns element"));
            return this;
        }

        @Override
        public final Builder dns(String ... elements) {
            if (this.dns == null) {
                this.dns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dns.add(Objects.requireNonNull(element, "dns element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Dns")
        public final Builder dns(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.dns = null;
                return this;
            }
            this.dns = new ArrayList<String>();
            return this.addAllDns(elements);
        }

        public final Builder addAllDns(Iterable<String> elements) {
            Objects.requireNonNull(elements, "dns element");
            if (this.dns == null) {
                this.dns = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dns.add(Objects.requireNonNull(element, "dns element"));
            }
            return this;
        }

        public final Builder dnsOption(String element) {
            if (this.dnsOptions == null) {
                this.dnsOptions = new ArrayList<String>();
            }
            this.dnsOptions.add(Objects.requireNonNull(element, "dnsOptions element"));
            return this;
        }

        @Override
        public final Builder dnsOptions(String ... elements) {
            if (this.dnsOptions == null) {
                this.dnsOptions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dnsOptions.add(Objects.requireNonNull(element, "dnsOptions element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="DnsOptions")
        public final Builder dnsOptions(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.dnsOptions = null;
                return this;
            }
            this.dnsOptions = new ArrayList<String>();
            return this.addAllDnsOptions(elements);
        }

        public final Builder addAllDnsOptions(Iterable<String> elements) {
            Objects.requireNonNull(elements, "dnsOptions element");
            if (this.dnsOptions == null) {
                this.dnsOptions = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dnsOptions.add(Objects.requireNonNull(element, "dnsOptions element"));
            }
            return this;
        }

        public final Builder dnsSearch(String element) {
            if (this.dnsSearch == null) {
                this.dnsSearch = new ArrayList<String>();
            }
            this.dnsSearch.add(Objects.requireNonNull(element, "dnsSearch element"));
            return this;
        }

        @Override
        public final Builder dnsSearch(String ... elements) {
            if (this.dnsSearch == null) {
                this.dnsSearch = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dnsSearch.add(Objects.requireNonNull(element, "dnsSearch element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="DnsSearch")
        public final Builder dnsSearch(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.dnsSearch = null;
                return this;
            }
            this.dnsSearch = new ArrayList<String>();
            return this.addAllDnsSearch(elements);
        }

        public final Builder addAllDnsSearch(Iterable<String> elements) {
            Objects.requireNonNull(elements, "dnsSearch element");
            if (this.dnsSearch == null) {
                this.dnsSearch = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dnsSearch.add(Objects.requireNonNull(element, "dnsSearch element"));
            }
            return this;
        }

        public final Builder extraHost(String element) {
            if (this.extraHosts == null) {
                this.extraHosts = new ArrayList<String>();
            }
            this.extraHosts.add(Objects.requireNonNull(element, "extraHosts element"));
            return this;
        }

        @Override
        public final Builder extraHosts(String ... elements) {
            if (this.extraHosts == null) {
                this.extraHosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.extraHosts.add(Objects.requireNonNull(element, "extraHosts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="ExtraHosts")
        public final Builder extraHosts(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.extraHosts = null;
                return this;
            }
            this.extraHosts = new ArrayList<String>();
            return this.addAllExtraHosts(elements);
        }

        public final Builder addAllExtraHosts(Iterable<String> elements) {
            Objects.requireNonNull(elements, "extraHosts element");
            if (this.extraHosts == null) {
                this.extraHosts = new ArrayList<String>();
            }
            for (String element : elements) {
                this.extraHosts.add(Objects.requireNonNull(element, "extraHosts element"));
            }
            return this;
        }

        public final Builder groupAdd(String element) {
            if (this.groupAdd == null) {
                this.groupAdd = new ArrayList<String>();
            }
            this.groupAdd.add(Objects.requireNonNull(element, "groupAdd element"));
            return this;
        }

        @Override
        public final Builder groupAdd(String ... elements) {
            if (this.groupAdd == null) {
                this.groupAdd = new ArrayList<String>();
            }
            for (String element : elements) {
                this.groupAdd.add(Objects.requireNonNull(element, "groupAdd element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="GroupAdd")
        public final Builder groupAdd(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.groupAdd = null;
                return this;
            }
            this.groupAdd = new ArrayList<String>();
            return this.addAllGroupAdd(elements);
        }

        public final Builder addAllGroupAdd(Iterable<String> elements) {
            Objects.requireNonNull(elements, "groupAdd element");
            if (this.groupAdd == null) {
                this.groupAdd = new ArrayList<String>();
            }
            for (String element : elements) {
                this.groupAdd.add(Objects.requireNonNull(element, "groupAdd element"));
            }
            return this;
        }

        public final Builder volumesFrom(String element) {
            if (this.volumesFrom == null) {
                this.volumesFrom = new ArrayList<String>();
            }
            this.volumesFrom.add(Objects.requireNonNull(element, "volumesFrom element"));
            return this;
        }

        @Override
        public final Builder volumesFrom(String ... elements) {
            if (this.volumesFrom == null) {
                this.volumesFrom = new ArrayList<String>();
            }
            for (String element : elements) {
                this.volumesFrom.add(Objects.requireNonNull(element, "volumesFrom element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="VolumesFrom")
        public final Builder volumesFrom(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.volumesFrom = null;
                return this;
            }
            this.volumesFrom = new ArrayList<String>();
            return this.addAllVolumesFrom(elements);
        }

        public final Builder addAllVolumesFrom(Iterable<String> elements) {
            Objects.requireNonNull(elements, "volumesFrom element");
            if (this.volumesFrom == null) {
                this.volumesFrom = new ArrayList<String>();
            }
            for (String element : elements) {
                this.volumesFrom.add(Objects.requireNonNull(element, "volumesFrom element"));
            }
            return this;
        }

        public final Builder capAdd(String element) {
            if (this.capAdd == null) {
                this.capAdd = new ArrayList<String>();
            }
            this.capAdd.add(Objects.requireNonNull(element, "capAdd element"));
            return this;
        }

        @Override
        public final Builder capAdd(String ... elements) {
            if (this.capAdd == null) {
                this.capAdd = new ArrayList<String>();
            }
            for (String element : elements) {
                this.capAdd.add(Objects.requireNonNull(element, "capAdd element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="CapAdd")
        public final Builder capAdd(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.capAdd = null;
                return this;
            }
            this.capAdd = new ArrayList<String>();
            return this.addAllCapAdd(elements);
        }

        public final Builder addAllCapAdd(Iterable<String> elements) {
            Objects.requireNonNull(elements, "capAdd element");
            if (this.capAdd == null) {
                this.capAdd = new ArrayList<String>();
            }
            for (String element : elements) {
                this.capAdd.add(Objects.requireNonNull(element, "capAdd element"));
            }
            return this;
        }

        public final Builder capDrop(String element) {
            if (this.capDrop == null) {
                this.capDrop = new ArrayList<String>();
            }
            this.capDrop.add(Objects.requireNonNull(element, "capDrop element"));
            return this;
        }

        @Override
        public final Builder capDrop(String ... elements) {
            if (this.capDrop == null) {
                this.capDrop = new ArrayList<String>();
            }
            for (String element : elements) {
                this.capDrop.add(Objects.requireNonNull(element, "capDrop element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="CapDrop")
        public final Builder capDrop(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.capDrop = null;
                return this;
            }
            this.capDrop = new ArrayList<String>();
            return this.addAllCapDrop(elements);
        }

        public final Builder addAllCapDrop(Iterable<String> elements) {
            Objects.requireNonNull(elements, "capDrop element");
            if (this.capDrop == null) {
                this.capDrop = new ArrayList<String>();
            }
            for (String element : elements) {
                this.capDrop.add(Objects.requireNonNull(element, "capDrop element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="NetworkMode")
        public final Builder networkMode(@Nullable String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        public final Builder securityOpt(String element) {
            if (this.securityOpt == null) {
                this.securityOpt = new ArrayList<String>();
            }
            this.securityOpt.add(Objects.requireNonNull(element, "securityOpt element"));
            return this;
        }

        @Override
        public final Builder securityOpt(String ... elements) {
            if (this.securityOpt == null) {
                this.securityOpt = new ArrayList<String>();
            }
            for (String element : elements) {
                this.securityOpt.add(Objects.requireNonNull(element, "securityOpt element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="SecurityOpt")
        public final Builder securityOpt(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.securityOpt = null;
                return this;
            }
            this.securityOpt = new ArrayList<String>();
            return this.addAllSecurityOpt(elements);
        }

        public final Builder addAllSecurityOpt(Iterable<String> elements) {
            Objects.requireNonNull(elements, "securityOpt element");
            if (this.securityOpt == null) {
                this.securityOpt = new ArrayList<String>();
            }
            for (String element : elements) {
                this.securityOpt.add(Objects.requireNonNull(element, "securityOpt element"));
            }
            return this;
        }

        public final Builder device(Device element) {
            if (this.devices == null) {
                this.devices = new ArrayList<Device>();
            }
            this.devices.add(Objects.requireNonNull(element, "devices element"));
            return this;
        }

        @Override
        public final Builder devices(Device ... elements) {
            if (this.devices == null) {
                this.devices = new ArrayList<Device>();
            }
            for (Device element : elements) {
                this.devices.add(Objects.requireNonNull(element, "devices element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Devices")
        public final Builder devices(@Nullable Iterable<? extends Device> elements) {
            if (elements == null) {
                this.devices = null;
                return this;
            }
            this.devices = new ArrayList<Device>();
            return this.addAllDevices(elements);
        }

        public final Builder addAllDevices(Iterable<? extends Device> elements) {
            Objects.requireNonNull(elements, "devices element");
            if (this.devices == null) {
                this.devices = new ArrayList<Device>();
            }
            for (Device device : elements) {
                this.devices.add(Objects.requireNonNull(device, "devices element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Memory")
        public final Builder memory(@Nullable Long memory) {
            this.memory = memory;
            return this;
        }

        @Override
        @JsonProperty(value="MemorySwap")
        public final Builder memorySwap(@Nullable Long memorySwap) {
            this.memorySwap = memorySwap;
            return this;
        }

        @Override
        @JsonProperty(value="KernelMemory")
        public final Builder kernelMemory(@Nullable Long kernelMemory) {
            this.kernelMemory = kernelMemory;
            return this;
        }

        @Override
        @JsonProperty(value="MemorySwappiness")
        public final Builder memorySwappiness(@Nullable Integer memorySwappiness) {
            this.memorySwappiness = memorySwappiness;
            return this;
        }

        @Override
        @JsonProperty(value="MemoryReservation")
        public final Builder memoryReservation(@Nullable Long memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        @Override
        @JsonProperty(value="NanoCpus")
        public final Builder nanoCpus(@Nullable Long nanoCpus) {
            this.nanoCpus = nanoCpus;
            return this;
        }

        @Override
        @JsonProperty(value="CpuPeriod")
        public final Builder cpuPeriod(@Nullable Long cpuPeriod) {
            this.cpuPeriod = cpuPeriod;
            return this;
        }

        @Override
        @JsonProperty(value="CpuShares")
        public final Builder cpuShares(@Nullable Long cpuShares) {
            this.cpuShares = cpuShares;
            return this;
        }

        @Override
        @JsonProperty(value="CpusetCpus")
        public final Builder cpusetCpus(@Nullable String cpusetCpus) {
            this.cpusetCpus = cpusetCpus;
            return this;
        }

        @Override
        @JsonProperty(value="CpusetMems")
        public final Builder cpusetMems(@Nullable String cpusetMems) {
            this.cpusetMems = cpusetMems;
            return this;
        }

        @Override
        @JsonProperty(value="CpuQuota")
        public final Builder cpuQuota(@Nullable Long cpuQuota) {
            this.cpuQuota = cpuQuota;
            return this;
        }

        @Override
        @JsonProperty(value="CgroupParent")
        public final Builder cgroupParent(@Nullable String cgroupParent) {
            this.cgroupParent = cgroupParent;
            return this;
        }

        @Override
        @JsonProperty(value="RestartPolicy")
        public final Builder restartPolicy(@Nullable HostConfig.RestartPolicy restartPolicy) {
            this.restartPolicy = restartPolicy;
            return this;
        }

        @Override
        @JsonProperty(value="LogConfig")
        public final Builder logConfig(@Nullable LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        @Override
        @JsonProperty(value="IpcMode")
        public final Builder ipcMode(@Nullable String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        public final Builder ulimit(HostConfig.Ulimit element) {
            if (this.ulimits == null) {
                this.ulimits = new ArrayList<HostConfig.Ulimit>();
            }
            this.ulimits.add(Objects.requireNonNull(element, "ulimits element"));
            return this;
        }

        public final Builder ulimits(HostConfig.Ulimit ... elements) {
            if (this.ulimits == null) {
                this.ulimits = new ArrayList<HostConfig.Ulimit>();
            }
            for (HostConfig.Ulimit element : elements) {
                this.ulimits.add(Objects.requireNonNull(element, "ulimits element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Ulimits")
        public final Builder ulimits(@Nullable Iterable<? extends HostConfig.Ulimit> elements) {
            if (elements == null) {
                this.ulimits = null;
                return this;
            }
            this.ulimits = new ArrayList<HostConfig.Ulimit>();
            return this.addAllUlimits(elements);
        }

        public final Builder addAllUlimits(Iterable<? extends HostConfig.Ulimit> elements) {
            Objects.requireNonNull(elements, "ulimits element");
            if (this.ulimits == null) {
                this.ulimits = new ArrayList<HostConfig.Ulimit>();
            }
            for (HostConfig.Ulimit ulimit : elements) {
                this.ulimits.add(Objects.requireNonNull(ulimit, "ulimits element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="PidMode")
        public final Builder pidMode(@Nullable String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        @Override
        @JsonProperty(value="ShmSize")
        public final Builder shmSize(@Nullable Long shmSize) {
            this.shmSize = shmSize;
            return this;
        }

        @Override
        @JsonProperty(value="OomKillDisable")
        public final Builder oomKillDisable(@Nullable Boolean oomKillDisable) {
            this.oomKillDisable = oomKillDisable;
            return this;
        }

        @Override
        @JsonProperty(value="OomScoreAdj")
        public final Builder oomScoreAdj(@Nullable Integer oomScoreAdj) {
            this.oomScoreAdj = oomScoreAdj;
            return this;
        }

        @Override
        @JsonProperty(value="AutoRemove")
        public final Builder autoRemove(@Nullable Boolean autoRemove) {
            this.autoRemove = autoRemove;
            return this;
        }

        @Override
        @JsonProperty(value="PidsLimit")
        public final Builder pidsLimit(@Nullable Integer pidsLimit) {
            this.pidsLimit = pidsLimit;
            return this;
        }

        public final Builder addTmpf(String key, String value) {
            if (this.tmpfs == null) {
                this.tmpfs = new LinkedHashMap<String, String>();
            }
            this.tmpfs.put(Objects.requireNonNull(key, "tmpfs key"), Objects.requireNonNull(value, "tmpfs value"));
            return this;
        }

        public final Builder addTmpf(Map.Entry<String, ? extends String> entry) {
            if (this.tmpfs == null) {
                this.tmpfs = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.tmpfs.put(Objects.requireNonNull(k, "tmpfs key"), Objects.requireNonNull(v, "tmpfs value"));
            return this;
        }

        @Override
        @JsonProperty(value="Tmpfs")
        public final Builder tmpfs(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.tmpfs = null;
                return this;
            }
            this.tmpfs = new LinkedHashMap<String, String>();
            return this.putAllTmpfs(entries);
        }

        public final Builder putAllTmpfs(Map<String, ? extends String> entries) {
            if (this.tmpfs == null) {
                this.tmpfs = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.tmpfs.put(Objects.requireNonNull(k, "tmpfs key"), Objects.requireNonNull(v, "tmpfs value"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="ReadonlyRootfs")
        public final Builder readonlyRootfs(@Nullable Boolean readonlyRootfs) {
            this.readonlyRootfs = readonlyRootfs;
            return this;
        }

        public final Builder addStorageOpt(String key, String value) {
            if (this.storageOpt == null) {
                this.storageOpt = new LinkedHashMap<String, String>();
            }
            this.storageOpt.put(Objects.requireNonNull(key, "storageOpt key"), Objects.requireNonNull(value, "storageOpt value"));
            return this;
        }

        public final Builder addStorageOpt(Map.Entry<String, ? extends String> entry) {
            if (this.storageOpt == null) {
                this.storageOpt = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            String v = entry.getValue();
            this.storageOpt.put(Objects.requireNonNull(k, "storageOpt key"), Objects.requireNonNull(v, "storageOpt value"));
            return this;
        }

        @Override
        @JsonProperty(value="StorageOpt")
        public final Builder storageOpt(@Nullable Map<String, ? extends String> entries) {
            if (entries == null) {
                this.storageOpt = null;
                return this;
            }
            this.storageOpt = new LinkedHashMap<String, String>();
            return this.putAllStorageOpt(entries);
        }

        public final Builder putAllStorageOpt(Map<String, ? extends String> entries) {
            if (this.storageOpt == null) {
                this.storageOpt = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.storageOpt.put(Objects.requireNonNull(k, "storageOpt key"), Objects.requireNonNull(v, "storageOpt value"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Runtime")
        public final Builder runtime(@Nullable String runtime) {
            this.runtime = runtime;
            return this;
        }

        public final Builder mount(Mount element) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<Mount>();
            }
            this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            return this;
        }

        @Override
        public final Builder mounts(Mount ... elements) {
            if (this.mounts == null) {
                this.mounts = new ArrayList<Mount>();
            }
            for (Mount element : elements) {
                this.mounts.add(Objects.requireNonNull(element, "mounts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Mounts")
        public final Builder mounts(@Nullable Iterable<? extends Mount> elements) {
            if (elements == null) {
                this.mounts = null;
                return this;
            }
            this.mounts = new ArrayList<Mount>();
            return this.addAllMounts(elements);
        }

        public final Builder addAllMounts(Iterable<? extends Mount> elements) {
            Objects.requireNonNull(elements, "mounts element");
            if (this.mounts == null) {
                this.mounts = new ArrayList<Mount>();
            }
            for (Mount mount : elements) {
                this.mounts.add(Objects.requireNonNull(mount, "mounts element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Init")
        public final Builder init(@Nullable Boolean init) {
            this.init = init;
            return this;
        }

        @Override
        public final Builder addSysctl(String key, String value) {
            this.sysctls.put(Objects.requireNonNull(key, "sysctls key"), Objects.requireNonNull(value, "sysctls value"));
            return this;
        }

        public final Builder addSysctl(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.sysctls.put(Objects.requireNonNull(k, "sysctls key"), Objects.requireNonNull(v, "sysctls value"));
            return this;
        }

        @Override
        @JsonProperty(value="Sysctls")
        public final Builder sysctls(Map<String, ? extends String> entries) {
            this.sysctls.clear();
            return this.putAllSysctls(entries);
        }

        public final Builder putAllSysctls(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.sysctls.put(Objects.requireNonNull(k, "sysctls key"), Objects.requireNonNull(v, "sysctls value"));
            }
            return this;
        }

        public final Builder capability(String element) {
            if (this.capabilities == null) {
                this.capabilities = new ArrayList<String>();
            }
            this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
            return this;
        }

        public final Builder capabilities(String ... elements) {
            if (this.capabilities == null) {
                this.capabilities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Capabilities")
        public final Builder capabilities(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.capabilities = null;
                return this;
            }
            this.capabilities = new ArrayList<String>();
            return this.addAllCapabilities(elements);
        }

        public final Builder addAllCapabilities(Iterable<String> elements) {
            Objects.requireNonNull(elements, "capabilities element");
            if (this.capabilities == null) {
                this.capabilities = new ArrayList<String>();
            }
            for (String element : elements) {
                this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
            }
            return this;
        }

        public final Builder deviceRequest(HostConfig.DeviceRequest element) {
            if (this.deviceRequests == null) {
                this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
            }
            this.deviceRequests.add(Objects.requireNonNull(element, "deviceRequests element"));
            return this;
        }

        public final Builder deviceRequests(HostConfig.DeviceRequest ... elements) {
            if (this.deviceRequests == null) {
                this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
            }
            for (HostConfig.DeviceRequest element : elements) {
                this.deviceRequests.add(Objects.requireNonNull(element, "deviceRequests element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="DeviceRequests")
        public final Builder deviceRequests(@Nullable Iterable<? extends HostConfig.DeviceRequest> elements) {
            if (elements == null) {
                this.deviceRequests = null;
                return this;
            }
            this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
            return this.addAllDeviceRequests(elements);
        }

        public final Builder addAllDeviceRequests(Iterable<? extends HostConfig.DeviceRequest> elements) {
            Objects.requireNonNull(elements, "deviceRequests element");
            if (this.deviceRequests == null) {
                this.deviceRequests = new ArrayList<HostConfig.DeviceRequest>();
            }
            for (HostConfig.DeviceRequest deviceRequest : elements) {
                this.deviceRequests.add(Objects.requireNonNull(deviceRequest, "deviceRequests element"));
            }
            return this;
        }

        @Override
        public ImmutableHostConfig build() {
            return ImmutableHostConfig.validate(new ImmutableHostConfig(this.binds == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.binds), this.blkioWeight, this.blkioWeightDevice == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.blkioWeightDevice), this.blkioDeviceReadBps == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.blkioDeviceReadBps), this.blkioDeviceWriteBps == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.blkioDeviceWriteBps), this.blkioDeviceReadIOps == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.blkioDeviceReadIOps), this.blkioDeviceWriteIOps == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.blkioDeviceWriteIOps), this.containerIdFile, this.lxcConf == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.lxcConf), this.privileged, this.portBindings == null ? null : ImmutableHostConfig.createUnmodifiableMap(false, false, this.portBindings), this.links == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.links), this.publishAllPorts, this.dns == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.dns), this.dnsOptions == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.dnsOptions), this.dnsSearch == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.dnsSearch), this.extraHosts == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.extraHosts), this.groupAdd == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.groupAdd), this.volumesFrom == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.volumesFrom), this.capAdd == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.capAdd), this.capDrop == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.capDrop), this.networkMode, this.securityOpt == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.securityOpt), this.devices == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.devices), this.memory, this.memorySwap, this.kernelMemory, this.memorySwappiness, this.memoryReservation, this.nanoCpus, this.cpuPeriod, this.cpuShares, this.cpusetCpus, this.cpusetMems, this.cpuQuota, this.cgroupParent, this.restartPolicy, this.logConfig, this.ipcMode, this.ulimits == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.ulimits), this.pidMode, this.shmSize, this.oomKillDisable, this.oomScoreAdj, this.autoRemove, this.pidsLimit, this.tmpfs == null ? null : ImmutableHostConfig.createUnmodifiableMap(false, false, this.tmpfs), this.readonlyRootfs, this.storageOpt == null ? null : ImmutableHostConfig.createUnmodifiableMap(false, false, this.storageOpt), this.runtime, this.mounts == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.mounts), this.init, ImmutableHostConfig.createUnmodifiableMap(false, false, this.sysctls), this.capabilities == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.capabilities), this.deviceRequests == null ? null : ImmutableHostConfig.createUnmodifiableList(true, this.deviceRequests)));
        }
    }

    static final class DeviceRequest
    implements HostConfig.DeviceRequest {
        private final String driver;
        private final Integer count;
        private final List<String> deviceIds;
        private final List<String> capabilities;
        private final Map<String, String> options;

        private DeviceRequest(String driver, Integer count, List<String> deviceIds, List<String> capabilities, Map<String, String> options) {
            this.driver = driver;
            this.count = count;
            this.deviceIds = deviceIds;
            this.capabilities = capabilities;
            this.options = options;
        }

        @Override
        @JsonProperty(value="Driver")
        public String driver() {
            return this.driver;
        }

        @Override
        @JsonProperty(value="Count")
        public Integer count() {
            return this.count;
        }

        @Override
        @JsonProperty(value="DeviceIDs")
        public List<String> deviceIds() {
            return this.deviceIds;
        }

        @Override
        @JsonProperty(value="Capabilities")
        public List<String> capabilities() {
            return this.capabilities;
        }

        @Override
        @JsonProperty(value="Options")
        public Map<String, String> options() {
            return this.options;
        }

        public final DeviceRequest withDriver(String value) {
            String newValue = Objects.requireNonNull(value, "driver");
            if (this.driver.equals(newValue)) {
                return this;
            }
            return new DeviceRequest(newValue, this.count, this.deviceIds, this.capabilities, this.options);
        }

        public final DeviceRequest withCount(Integer value) {
            Integer newValue = Objects.requireNonNull(value, "count");
            if (this.count.equals(newValue)) {
                return this;
            }
            return new DeviceRequest(this.driver, newValue, this.deviceIds, this.capabilities, this.options);
        }

        public final DeviceRequest withDeviceIds(String ... elements) {
            List newValue = ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
            return new DeviceRequest(this.driver, this.count, newValue, this.capabilities, this.options);
        }

        public final DeviceRequest withDeviceIds(Iterable<String> elements) {
            if (this.deviceIds == elements) {
                return this;
            }
            List newValue = ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
            return new DeviceRequest(this.driver, this.count, newValue, this.capabilities, this.options);
        }

        public final DeviceRequest withCapabilities(String ... elements) {
            List newValue = ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(Arrays.asList(elements), true, false));
            return new DeviceRequest(this.driver, this.count, this.deviceIds, newValue, this.options);
        }

        public final DeviceRequest withCapabilities(Iterable<String> elements) {
            if (this.capabilities == elements) {
                return this;
            }
            List newValue = ImmutableHostConfig.createUnmodifiableList(false, ImmutableHostConfig.createSafeList(elements, true, false));
            return new DeviceRequest(this.driver, this.count, this.deviceIds, newValue, this.options);
        }

        public final DeviceRequest withOptions(Map<String, ? extends String> entries) {
            if (this.options == entries) {
                return this;
            }
            Map newValue = ImmutableHostConfig.createUnmodifiableMap(true, false, entries);
            return new DeviceRequest(this.driver, this.count, this.deviceIds, this.capabilities, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof DeviceRequest && this.equalTo((DeviceRequest)another);
        }

        private boolean equalTo(DeviceRequest another) {
            return this.driver.equals(another.driver) && this.count.equals(another.count) && this.deviceIds.equals(another.deviceIds) && this.capabilities.equals(another.capabilities) && this.options.equals(another.options);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.driver.hashCode();
            h += (h << 5) + this.count.hashCode();
            h += (h << 5) + this.deviceIds.hashCode();
            h += (h << 5) + this.capabilities.hashCode();
            h += (h << 5) + this.options.hashCode();
            return h;
        }

        public String toString() {
            return "DeviceRequest{driver=" + this.driver + ", count=" + this.count + ", deviceIds=" + this.deviceIds + ", capabilities=" + this.capabilities + ", options=" + this.options + "}";
        }

        public static DeviceRequest copyOf(HostConfig.DeviceRequest instance) {
            if (instance instanceof DeviceRequest) {
                return (DeviceRequest)instance;
            }
            return DeviceRequest.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements HostConfig.DeviceRequest.Builder {
            private static final long INIT_BIT_DRIVER = 1L;
            private static final long INIT_BIT_COUNT = 2L;
            private long initBits = 3L;
            private String driver;
            private Integer count;
            private List<String> deviceIds = new ArrayList<String>();
            private List<String> capabilities = new ArrayList<String>();
            private Map<String, String> options = new LinkedHashMap<String, String>();

            private Builder() {
            }

            public final Builder from(HostConfig.DeviceRequest instance) {
                Objects.requireNonNull(instance, "instance");
                this.driver(instance.driver());
                this.count(instance.count());
                this.addAllDeviceIds(instance.deviceIds());
                this.addAllCapabilities(instance.capabilities());
                this.putAllOptions(instance.options());
                return this;
            }

            @Override
            @JsonProperty(value="Driver")
            public final Builder driver(String driver) {
                this.driver = Objects.requireNonNull(driver, "driver");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @Override
            @JsonProperty(value="Count")
            public final Builder count(Integer count) {
                this.count = Objects.requireNonNull(count, "count");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public final Builder deviceId(String element) {
                this.deviceIds.add(Objects.requireNonNull(element, "deviceIds element"));
                return this;
            }

            public final Builder deviceIds(String ... elements) {
                for (String element : elements) {
                    this.deviceIds.add(Objects.requireNonNull(element, "deviceIds element"));
                }
                return this;
            }

            @Override
            @JsonProperty(value="DeviceIDs")
            public final Builder deviceIds(Iterable<String> elements) {
                this.deviceIds.clear();
                return this.addAllDeviceIds(elements);
            }

            public final Builder addAllDeviceIds(Iterable<String> elements) {
                for (String element : elements) {
                    this.deviceIds.add(Objects.requireNonNull(element, "deviceIds element"));
                }
                return this;
            }

            public final Builder capability(String element) {
                this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
                return this;
            }

            public final Builder capabilities(String ... elements) {
                for (String element : elements) {
                    this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
                }
                return this;
            }

            @Override
            @JsonProperty(value="Capabilities")
            public final Builder capabilities(Iterable<String> elements) {
                this.capabilities.clear();
                return this.addAllCapabilities(elements);
            }

            public final Builder addAllCapabilities(Iterable<String> elements) {
                for (String element : elements) {
                    this.capabilities.add(Objects.requireNonNull(element, "capabilities element"));
                }
                return this;
            }

            public final Builder addOption(String key, String value) {
                this.options.put(Objects.requireNonNull(key, "options key"), Objects.requireNonNull(value, "options value"));
                return this;
            }

            public final Builder addOption(Map.Entry<String, ? extends String> entry) {
                String k = entry.getKey();
                String v = entry.getValue();
                this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, "options value"));
                return this;
            }

            @Override
            @JsonProperty(value="Options")
            public final Builder options(Map<String, ? extends String> entries) {
                this.options.clear();
                return this.putAllOptions(entries);
            }

            public final Builder putAllOptions(Map<String, ? extends String> entries) {
                for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                    String k = e.getKey();
                    String v = e.getValue();
                    this.options.put(Objects.requireNonNull(k, "options key"), Objects.requireNonNull(v, "options value"));
                }
                return this;
            }

            @Override
            public DeviceRequest build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new DeviceRequest(this.driver, this.count, ImmutableHostConfig.createUnmodifiableList(true, this.deviceIds), ImmutableHostConfig.createUnmodifiableList(true, this.capabilities), ImmutableHostConfig.createUnmodifiableMap(false, false, this.options));
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("driver");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("count");
                }
                return "Cannot build DeviceRequest, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class LxcConfParameter
    implements HostConfig.LxcConfParameter {
        private final String key;
        private final String value;

        private LxcConfParameter(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        @JsonProperty(value="Key")
        public String key() {
            return this.key;
        }

        @Override
        @JsonProperty(value="Value")
        public String value() {
            return this.value;
        }

        public final LxcConfParameter withKey(String value) {
            String newValue = Objects.requireNonNull(value, "key");
            if (this.key.equals(newValue)) {
                return this;
            }
            return new LxcConfParameter(newValue, this.value);
        }

        public final LxcConfParameter withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new LxcConfParameter(this.key, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof LxcConfParameter && this.equalTo((LxcConfParameter)another);
        }

        private boolean equalTo(LxcConfParameter another) {
            return this.key.equals(another.key) && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.key.hashCode();
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "LxcConfParameter{key=" + this.key + ", value=" + this.value + "}";
        }

        public static LxcConfParameter copyOf(HostConfig.LxcConfParameter instance) {
            if (instance instanceof LxcConfParameter) {
                return (LxcConfParameter)instance;
            }
            return LxcConfParameter.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_KEY = 1L;
            private static final long INIT_BIT_VALUE = 2L;
            private long initBits = 3L;
            private String key;
            private String value;

            private Builder() {
            }

            public final Builder from(HostConfig.LxcConfParameter instance) {
                Objects.requireNonNull(instance, "instance");
                this.key(instance.key());
                this.value(instance.value());
                return this;
            }

            @JsonProperty(value="Key")
            public final Builder key(String key) {
                this.key = Objects.requireNonNull(key, "key");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="Value")
            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public LxcConfParameter build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new LxcConfParameter(this.key, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("key");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build LxcConfParameter, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class RestartPolicy
    implements HostConfig.RestartPolicy {
        private final String name;
        @Nullable
        private final Integer maxRetryCount;

        private RestartPolicy(String name, @Nullable Integer maxRetryCount) {
            this.name = name;
            this.maxRetryCount = maxRetryCount;
        }

        @Override
        @JsonProperty(value="Name")
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="MaximumRetryCount")
        @Nullable
        public Integer maxRetryCount() {
            return this.maxRetryCount;
        }

        public final RestartPolicy withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new RestartPolicy(newValue, this.maxRetryCount);
        }

        public final RestartPolicy withMaxRetryCount(@Nullable Integer value) {
            if (Objects.equals(this.maxRetryCount, value)) {
                return this;
            }
            return new RestartPolicy(this.name, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof RestartPolicy && this.equalTo((RestartPolicy)another);
        }

        private boolean equalTo(RestartPolicy another) {
            return this.name.equals(another.name) && Objects.equals(this.maxRetryCount, another.maxRetryCount);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + Objects.hashCode(this.maxRetryCount);
            return h;
        }

        public String toString() {
            return "RestartPolicy{name=" + this.name + ", maxRetryCount=" + this.maxRetryCount + "}";
        }

        public static RestartPolicy copyOf(HostConfig.RestartPolicy instance) {
            if (instance instanceof RestartPolicy) {
                return (RestartPolicy)instance;
            }
            return RestartPolicy.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private long initBits = 1L;
            private String name;
            private Integer maxRetryCount;

            private Builder() {
            }

            public final Builder from(HostConfig.RestartPolicy instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                Integer maxRetryCountValue = instance.maxRetryCount();
                if (maxRetryCountValue != null) {
                    this.maxRetryCount(maxRetryCountValue);
                }
                return this;
            }

            @JsonProperty(value="Name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="MaximumRetryCount")
            public final Builder maxRetryCount(@Nullable Integer maxRetryCount) {
                this.maxRetryCount = maxRetryCount;
                return this;
            }

            public RestartPolicy build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new RestartPolicy(this.name, this.maxRetryCount);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                return "Cannot build RestartPolicy, some of required attributes are not set " + attributes;
            }
        }
    }

    static final class Ulimit
    implements HostConfig.Ulimit {
        private final String name;
        private final Long soft;
        private final Long hard;

        private Ulimit(String name, Long soft, Long hard) {
            this.name = name;
            this.soft = soft;
            this.hard = hard;
        }

        @Override
        @JsonProperty(value="Name")
        public String name() {
            return this.name;
        }

        @Override
        @JsonProperty(value="Soft")
        public Long soft() {
            return this.soft;
        }

        @Override
        @JsonProperty(value="Hard")
        public Long hard() {
            return this.hard;
        }

        public final Ulimit withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new Ulimit(newValue, this.soft, this.hard);
        }

        public final Ulimit withSoft(Long value) {
            Long newValue = Objects.requireNonNull(value, "soft");
            if (this.soft.equals(newValue)) {
                return this;
            }
            return new Ulimit(this.name, newValue, this.hard);
        }

        public final Ulimit withHard(Long value) {
            Long newValue = Objects.requireNonNull(value, "hard");
            if (this.hard.equals(newValue)) {
                return this;
            }
            return new Ulimit(this.name, this.soft, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Ulimit && this.equalTo((Ulimit)another);
        }

        private boolean equalTo(Ulimit another) {
            return this.name.equals(another.name) && this.soft.equals(another.soft) && this.hard.equals(another.hard);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.soft.hashCode();
            h += (h << 5) + this.hard.hashCode();
            return h;
        }

        public String toString() {
            return "Ulimit{name=" + this.name + ", soft=" + this.soft + ", hard=" + this.hard + "}";
        }

        public static Ulimit copyOf(HostConfig.Ulimit instance) {
            if (instance instanceof Ulimit) {
                return (Ulimit)instance;
            }
            return Ulimit.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        static final class Builder
        implements HostConfig.Ulimit.Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_SOFT = 2L;
            private static final long INIT_BIT_HARD = 4L;
            private long initBits = 7L;
            private String name;
            private Long soft;
            private Long hard;

            private Builder() {
            }

            public final Builder from(HostConfig.Ulimit instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                this.soft(instance.soft());
                this.hard(instance.hard());
                return this;
            }

            @Override
            @JsonProperty(value="Name")
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @Override
            @JsonProperty(value="Soft")
            public final Builder soft(Long soft) {
                this.soft = Objects.requireNonNull(soft, "soft");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @Override
            @JsonProperty(value="Hard")
            public final Builder hard(Long hard) {
                this.hard = Objects.requireNonNull(hard, "hard");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @Override
            public Ulimit build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Ulimit(this.name, this.soft, this.hard);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("soft");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("hard");
                }
                return "Cannot build Ulimit, some of required attributes are not set " + attributes;
            }
        }
    }
}

