/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.workbench.condition;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.condition.AbstractWaitCondition;
import org.eclipse.reddeer.workbench.api.Editor;
import org.eclipse.reddeer.workbench.impl.editor.Marker;

public class EditorHasValidationMarkers
extends AbstractWaitCondition {
    private Editor editor;
    private String type;
    private int line;
    private List<Marker> resultMarkers;

    public EditorHasValidationMarkers(Editor editor) {
        this(editor, null, -1);
    }

    public EditorHasValidationMarkers(Editor editor, String type) {
        this(editor, type, -1);
    }

    public EditorHasValidationMarkers(Editor editor, int line) {
        this(editor, null, line);
    }

    public EditorHasValidationMarkers(Editor editor, String type, int line) {
        this.editor = editor;
        this.type = type;
        this.line = line;
        this.resultMarkers = new ArrayList<Marker>();
    }

    public boolean test() {
        this.editor.activate();
        List<Marker> markers = this.editor.getMarkers();
        boolean toReturn = false;
        if (this.type == null) {
            if (this.line == -1) {
                this.resultMarkers = markers;
                toReturn = this.editor.getMarkers().size() > 0;
            } else {
                for (Marker m : markers) {
                    if (m.getLineNumber() != this.line) continue;
                    this.resultMarkers.add(m);
                    toReturn = true;
                    break;
                }
            }
        } else if (this.line == -1) {
            for (Marker m : markers) {
                if (!m.getType().equals(this.type)) continue;
                this.resultMarkers.add(m);
                toReturn = true;
                break;
            }
        } else {
            for (Marker m : markers) {
                if (!m.getType().equals(this.type) || m.getLineNumber() != this.line) continue;
                this.resultMarkers.add(m);
                toReturn = true;
                break;
            }
        }
        return toReturn;
    }

    public String description() {
        String description = this.type == null ? (this.line == -1 ? "Editor " + this.editor.getTitle() + " has validation markers" : "Editor " + this.editor.getTitle() + " has validation markers at line " + this.line) : (this.line == -1 ? "Editor " + this.editor.getTitle() + " has validation markers with type " + this.type : "Editor " + this.editor.getTitle() + " has validation markers with type" + this.type + " at line " + this.line);
        return description;
    }

    public List<Marker> getResult() {
        return this.resultMarkers.size() == 0 ? null : this.resultMarkers;
    }
}

