/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.sequence.figures;

import org.eclipse.draw2d.ArrowLocator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.papyrus.uml.diagram.common.figure.node.IPapyrusUMLElementFigure;
import org.eclipse.papyrus.uml.diagram.sequence.figures.GeneralOrderingDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class CustomGeneralOrderingDescriptor
extends GeneralOrderingDescriptor
implements IPapyrusUMLElementFigure {
    private WrappingLabel fAppliedStereotypeLabel;
    private RotatableDecoration middleDecoration;
    private IMapMode mapMode;

    public CustomGeneralOrderingDescriptor(IMapMode mapMode) {
        this.mapMode = mapMode;
        this.setTargetDecoration(null, null);
        this.setAntialias(1);
        this.createContents();
        this.setLineStyle(2);
        this.setForegroundColor(ColorConstants.black);
        this.setMiddleDecoration(this.createTargetDecoration());
    }

    public IMapMode getMapMode() {
        return this.mapMode;
    }

    public void setMapMode(IMapMode mapMode) {
        this.mapMode = mapMode;
    }

    protected void createContents() {
        this.createStereotypeLabel();
    }

    protected void createStereotypeLabel() {
        this.fAppliedStereotypeLabel = new WrappingLabel();
        this.fAppliedStereotypeLabel.setTextWrap(true);
        this.fAppliedStereotypeLabel.setTextJustification(2);
        this.fAppliedStereotypeLabel.setText("");
        this.add((IFigure)this.fAppliedStereotypeLabel);
    }

    private RotatableDecoration createTargetDecoration() {
        PolygonDecoration df = new PolygonDecoration();
        df.setFill(true);
        df.setForegroundColor(this.getForegroundColor());
        df.setBackgroundColor(this.getForegroundColor());
        PointList pl = new PointList();
        pl.addPoint(this.getMapMode().DPtoLP(-2), this.getMapMode().DPtoLP(2));
        pl.addPoint(this.getMapMode().DPtoLP(0), this.getMapMode().DPtoLP(0));
        pl.addPoint(this.getMapMode().DPtoLP(-2), this.getMapMode().DPtoLP(-2));
        pl.addPoint(this.getMapMode().DPtoLP(-2), this.getMapMode().DPtoLP(2));
        df.setTemplate(pl);
        df.setScale((double)this.getMapMode().DPtoLP(7), (double)this.getMapMode().DPtoLP(3));
        return df;
    }

    @Override
    public WrappingLabel getAppliedStereotypeLabel() {
        return this.fAppliedStereotypeLabel;
    }

    protected RotatableDecoration getMiddleDecoration() {
        return this.middleDecoration;
    }

    public void setForegroundColor(Color fg) {
        super.setForegroundColor(fg);
        if (this.getMiddleDecoration() != null) {
            this.getMiddleDecoration().setForegroundColor(fg);
            this.getMiddleDecoration().setBackgroundColor(fg);
        }
    }

    public void setLineWidth(int w) {
        super.setLineWidth(w);
        if (this.getMiddleDecoration() instanceof Shape) {
            ((Shape)this.getMiddleDecoration()).setLineWidth(w);
        }
    }

    public void setMiddleDecoration(RotatableDecoration dec) {
        if (this.getMiddleDecoration() != null) {
            this.remove((IFigure)this.getMiddleDecoration());
        }
        this.middleDecoration = dec;
        if (dec != null) {
            this.add((IFigure)dec, this.getArrowLocator());
        }
    }

    private ArrowLocator getArrowLocator() {
        return new ArrowLocator((Connection)this, 4){

            public void relocate(IFigure target) {
                Point refPoint;
                PointList points = this.getConnection().getPoints();
                RotatableDecoration arrow = (RotatableDecoration)target;
                arrow.setLocation(this.getLocation(points));
                if (points.size() % 2 == 0) {
                    int i = points.size() / 2;
                    refPoint = points.getPoint(i - 1);
                } else {
                    int i = (points.size() - 1) / 2;
                    refPoint = points.getPoint(i - 1);
                }
                arrow.setReferencePoint(refPoint);
            }
        };
    }

    public void setStereotypeDisplay(String stereotypes, Image image) {
        if (!"".equals(stereotypes)) {
            this.fAppliedStereotypeLabel.setText(stereotypes);
        } else {
            this.fAppliedStereotypeLabel.setText("");
        }
        this.fAppliedStereotypeLabel.setIcon(image);
    }
}

