/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.stp;

public class STPDefaultCodeFormatterConstants {
    public static final String FALSE = "false";
    public static final String FORMATTER_ALIGNMENT_FOR_ARGUMENTS_IN_METHOD_INVOCATION = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.alignment_for_arguments_in_method_invocation";
    public static final String FORMATTER_ALIGNMENT_FOR_EXPRESSIONS_IN_INITIALIZER_LIST = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.alignment_for_expressions_in_array_initializer";
    public static final String FORMATTER_ALIGNMENT_FOR_PARAMETERS_IN_METHOD_DECLARATION = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.alignment_for_parameters_in_method_declaration";
    public static final String FORMATTER_BRACE_POSITION_FOR_INITIALIZER_LIST = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.brace_position_for_array_initializer";
    public static final String FORMATTER_BRACE_POSITION_FOR_BLOCK = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.brace_position_for_block";
    public static final String FORMATTER_BRACE_POSITION_FOR_METHOD_DECLARATION = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.brace_position_for_method_declaration";
    public static final String FORMATTER_BRACE_POSITION_FOR_TYPE_DECLARATION = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.brace_position_for_type_declaration";
    public static final String FORMATTER_CONTINUATION_INDENTATION = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.continuation_indentation";
    public static final String FORMATTER_INDENT_ACCESS_SPECIFIER_COMPARE_TO_TYPE_HEADER = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_access_specifier_compare_to_type_header";
    public static final String FORMATTER_INDENT_ACCESS_SPECIFIER_EXTRA_SPACES = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_access_specifier_extra_spaces";
    public static final String FORMATTER_INDENT_BODY_DECLARATIONS_COMPARE_TO_ACCESS_SPECIFIER = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_body_declarations_compare_to_access_specifier";
    public static final String FORMATTER_INDENT_BODY_DECLARATIONS_COMPARE_TO_NAMESPACE_HEADER = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_body_declarations_compare_to_namespace_header";
    public static final String FORMATTER_INDENT_STATEMENTS_COMPARE_TO_BLOCK = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_statements_compare_to_block";
    public static final String FORMATTER_INDENT_STATEMENTS_COMPARE_TO_BODY = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_statements_compare_to_body";
    public static final String FORMATTER_INDENT_SWITCHSTATEMENTS_COMPARE_TO_CASES = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_switchstatements_compare_to_cases";
    public static final String FORMATTER_INDENT_SWITCHSTATEMENTS_COMPARE_TO_SWITCH = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.indent_switchstatements_compare_to_switch";
    public static final String FORMATTER_TAB_CHAR = "org.eclipse.linuxtools.systemtap.ui.ide.formatter.tabulation.char";
    public static final int INDENT_BY_ONE = 2;
    public static final int INDENT_DEFAULT = 0;
    public static final int INDENT_ON_COLUMN = 1;
    public static final String MIXED = "mixed";
    public static final String NEXT_LINE_SHIFTED = "next_line_shifted";
    public static final String TRUE = "true";
    public static final int WRAP_COMPACT = 1;
    public static final int WRAP_COMPACT_FIRST_BREAK = 2;
    public static final int WRAP_NEXT_PER_LINE = 5;
    public static final int WRAP_NEXT_SHIFTED = 4;
    public static final int WRAP_NO_SPLIT = 0;
    public static final int WRAP_ONE_PER_LINE = 3;
    private static final IllegalArgumentException WRONG_ARGUMENT = new IllegalArgumentException();

    public static int getIndentStyle(String value) {
        int existingValue;
        block5: {
            if (value == null) {
                throw WRONG_ARGUMENT;
            }
            try {
                existingValue = Integer.parseInt(value);
                if ((existingValue & 4) == 0) break block5;
                return 2;
            }
            catch (NumberFormatException e) {
                throw WRONG_ARGUMENT;
            }
        }
        if ((existingValue & 2) != 0) {
            return 1;
        }
        return 0;
    }

    public static int getWrappingStyle(String value) {
        if (value == null) {
            throw WRONG_ARGUMENT;
        }
        try {
            int existingValue = Integer.parseInt(value) & 0x70;
            switch (existingValue) {
                case 16: {
                    return 1;
                }
                case 32: {
                    return 2;
                }
                case 80: {
                    return 5;
                }
                case 64: {
                    return 4;
                }
                case 48: {
                    return 3;
                }
            }
            return 0;
        }
        catch (NumberFormatException e) {
            throw WRONG_ARGUMENT;
        }
    }
}

