/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.integration.internal.admin.osgijmx;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.TabularData;
import org.osgi.jmx.framework.PackageStateMBean;

public class PackagesData {
    private Map<PackageKey, Long> map = new HashMap<PackageKey, Long>();

    public PackagesData(PackageStateMBean mbean) throws IOException {
        TabularData data = mbean.listPackages();
        Set<?> keys = data.keySet();
        for (List key : keys) {
            String name = (String)key.get(0);
            String version = (String)key.get(1);
            Long exportingBundleId = ((Long[])key.get(2))[0];
            this.map.put(new PackageKey(name, version), exportingBundleId);
        }
    }

    public Long getExportingBundleId(String packageName, String packageVersion) {
        return this.map.get(new PackageKey(packageName, packageVersion));
    }

    class PackageKey {
        private String name;
        private String version;

        PackageKey(String name, String version) {
            this.name = name;
            this.version = version;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageKey other = (PackageKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        private PackagesData getOuterType() {
            return PackagesData.this;
        }
    }
}

