"use strict";
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Red Hat. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
Object.defineProperty(exports, "__esModule", { value: true });
const vscode_languageserver_types_1 = require("vscode-languageserver-types");
const vscode_languageserver_1 = require("vscode-languageserver");
function createExpectedError(message, startLine, startCharacter, endLine, endCharacter, severity = 2, source = 'YAML') {
    return vscode_languageserver_1.Diagnostic.create(vscode_languageserver_types_1.Range.create(startLine, startCharacter, endLine, endCharacter), message, severity, undefined, source);
}
exports.createExpectedError = createExpectedError;
function createExpectedSymbolInformation(name, kind, containerName, uri, startLine, startCharacter, endLine, endCharacter) {
    return {
        name,
        kind,
        containerName,
        location: {
            uri,
            range: {
                start: {
                    line: startLine,
                    character: startCharacter,
                },
                end: {
                    line: endLine,
                    character: endCharacter,
                },
            },
        },
    };
}
exports.createExpectedSymbolInformation = createExpectedSymbolInformation;
function createExpectedDocumentSymbol(name, kind, startLine, startCharacter, endLine, endCharacter, startLineSelection, startCharacterSelection, endLineSelection, endCharacterSelection, children = []) {
    return {
        name,
        kind,
        range: {
            start: {
                character: startCharacter,
                line: startLine,
            },
            end: {
                character: endCharacter,
                line: endLine,
            },
        },
        selectionRange: {
            start: {
                character: startCharacterSelection,
                line: startLineSelection,
            },
            end: {
                character: endCharacterSelection,
                line: endLineSelection,
            },
        },
        children,
    };
}
exports.createExpectedDocumentSymbol = createExpectedDocumentSymbol;
function createExpectedCompletion(label, insertText, startLine, startCharacter, endLine, endCharacter, kind, insertTextFormat = 2, extra = {}) {
    return Object.assign({
        insertText,
        label,
        insertTextFormat,
        kind,
        textEdit: {
            newText: insertText,
            range: {
                start: {
                    line: startLine,
                    character: startCharacter,
                },
                end: {
                    line: endLine,
                    character: endCharacter,
                },
            },
        },
    }, extra);
}
exports.createExpectedCompletion = createExpectedCompletion;
//# sourceMappingURL=verifyError.js.map