"use strict";
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
Object.defineProperty(exports, "__esModule", { value: true });
const api_1 = require("../common/api");
__export(require("vscode-languageserver-protocol/browser"));
__export(require("../common/api"));
let _shutdownReceived = false;
const watchDog = {
    initialize: (_params) => {
    },
    get shutdownReceived() {
        return _shutdownReceived;
    },
    set shutdownReceived(value) {
        _shutdownReceived = value;
    },
    exit: (_code) => {
    }
};
function createConnection(arg1, arg2, arg3, arg4) {
    let factories;
    let reader;
    let writer;
    let options;
    if (arg1 !== void 0 && arg1.__brand === 'features') {
        factories = arg1;
        arg1 = arg2;
        arg2 = arg3;
        arg3 = arg4;
    }
    if (api_1.ConnectionStrategy.is(arg1) || api_1.ConnectionOptions.is(arg1)) {
        options = arg1;
    }
    else {
        reader = arg1;
        writer = arg2;
        options = arg3;
    }
    const connectionFactory = (logger) => {
        return api_1.createProtocolConnection(reader, writer, logger, options);
    };
    return api_1.createConnection(connectionFactory, watchDog, factories);
}
exports.createConnection = createConnection;
//# sourceMappingURL=main.js.map