/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.node;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.Messages;
import org.eclipse.wildwebdeveloper.debug.SelectionUtils;
import org.eclipse.wildwebdeveloper.debug.node.NodeRunDebugLaunchShortcut;

public class RunProgramTab
extends AbstractLaunchConfigurationTab {
    private Text programPathText;
    private Text argumentsText;
    private Text workingDirectoryText;
    private final NodeRunDebugLaunchShortcut shortcut = new NodeRunDebugLaunchShortcut();

    public void createControl(Composite parent) {
        Composite resComposite = new Composite(parent, 0);
        resComposite.setLayout((Layout)new GridLayout(2, false));
        new Label(resComposite, 0).setText(Messages.RunProgramTab_program);
        this.programPathText = new Text(resComposite, 2048);
        this.programPathText.setLayoutData((Object)new GridData(4, -1, true, false));
        ControlDecoration decoration = new ControlDecoration((Control)this.programPathText, 16512);
        FieldDecoration fieldDecoration = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR");
        decoration.setImage(fieldDecoration.getImage());
        this.programPathText.addModifyListener(event -> {
            String errorMessage;
            this.setDirty(true);
            File file = new File(this.programPathText.getText());
            if (!file.isFile()) {
                errorMessage = Messages.RunProgramTab_error_unknownFile;
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            } else if (!this.shortcut.canLaunch(file)) {
                errorMessage = Messages.RunProgramTab_error_notJSFile;
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            }
            if (!file.canRead()) {
                errorMessage = Messages.RunProgramTab_error_nonReadableFile;
                this.setErrorMessage(errorMessage);
                decoration.setDescriptionText(errorMessage);
                decoration.show();
            } else {
                this.setErrorMessage(null);
                decoration.hide();
            }
            this.updateLaunchConfigurationDialog();
        });
        new Label(resComposite, 0).setText(Messages.RunProgramTab_argument);
        this.argumentsText = new Text(resComposite, 2048);
        this.argumentsText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.argumentsText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        new Label(resComposite, 0).setText(Messages.RunProgramTab_workingDirectory);
        this.workingDirectoryText = new Text(resComposite, 2048);
        this.workingDirectoryText.setLayoutData((Object)new GridData(4, -1, true, false));
        this.workingDirectoryText.addModifyListener(e -> {
            this.setDirty(true);
            this.updateLaunchConfigurationDialog();
        });
        this.setControl((Control)resComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String defaultSelectedFile = SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedFile(this.shortcut::canLaunch));
            this.programPathText.setText(configuration.getAttribute("program", defaultSelectedFile));
            this.argumentsText.setText(configuration.getAttribute("args", ""));
            this.workingDirectoryText.setText(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", SelectionUtils.pathOrEmpty(SelectionUtils.getSelectedProject())));
        }
        catch (CoreException e) {
            Activator.getDefault().getLog().log(e.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String programPath = this.programPathText.getText();
        configuration.setAttribute("program", programPath);
        configuration.setAttribute("args", this.argumentsText.getText());
        configuration.setAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", this.workingDirectoryText.getText());
        configuration.setMappedResources((IResource[])ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(new File(programPath).toURI()));
    }

    public String getName() {
        return Messages.RunProgramTab_title;
    }
}

