/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.model.association;

import org.eclipse.wb.internal.core.utils.xml.DocumentElement;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.association.Association;
import org.eclipse.wb.internal.core.xml.model.utils.ElementTarget;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;

public class DirectAssociation
extends Association {
    public static final Association INSTANCE = new DirectAssociation();

    protected DirectAssociation() {
    }

    public String toString() {
        return "direct";
    }

    @Override
    public void add(XmlObjectInfo object, ElementTarget target) throws Exception {
        DocumentElement targetElement = target.getElement();
        int targetIndex = target.getIndex();
        object.getCreationSupport().addElement(targetElement, targetIndex);
    }

    @Override
    public void move(XmlObjectInfo object, ElementTarget target, XmlObjectInfo oldParent, XmlObjectInfo newParent) throws Exception {
        DocumentElement objectElement = object.getCreationSupport().getElementMove();
        DocumentElement elementInOldParent = XmlObjectUtils.getElementInParent(oldParent, objectElement);
        DocumentElement targetElement = target.getElement();
        int targetIndex = target.getIndex();
        targetElement.moveChild(objectElement, targetIndex);
        if (objectElement != elementInOldParent) {
            elementInOldParent.remove();
        }
    }
}

