/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInputChange;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.xbase.lib.Conversions;

public class QueryRegistryTreeContentProvider
implements ITreeContentProvider {
    protected TreeViewer viewer;
    protected QueryRegistryTreeInput input;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof TreeViewer));
        this.viewer = (TreeViewer)viewer;
        if (oldInput instanceof QueryRegistryTreeInput) {
            ((QueryRegistryTreeInput)oldInput).setListener(null);
        }
        if (newInput instanceof QueryRegistryTreeInput) {
            this.input = (QueryRegistryTreeInput)newInput;
            QueryRegistryTreeViewListener _queryRegistryTreeViewListener = new QueryRegistryTreeViewListener((QueryRegistryTreeInput)newInput, this.viewer);
            ((QueryRegistryTreeInput)newInput).setListener(_queryRegistryTreeViewListener);
        } else if (newInput != null) {
            String _format = String.format("Invalid input type %s for Query Registry.", newInput.getClass().getName());
            throw new IllegalArgumentException(_format);
        }
    }

    public void dispose() {
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        return this.getChildrenInternal(parentElement);
    }

    protected Object[] _getChildrenInternal(QueryRegistryTreeInput parentElement) {
        return (Object[])Conversions.unwrapArray(parentElement.getSources().values(), Object.class);
    }

    protected Object[] _getChildrenInternal(QueryRegistryTreeSource parentElement) {
        return (Object[])Conversions.unwrapArray(parentElement.getPackages().values(), Object.class);
    }

    protected Object[] _getChildrenInternal(QueryRegistryTreePackage parentElement) {
        return (Object[])Conversions.unwrapArray(parentElement.getEntries().values(), Object.class);
    }

    protected Object[] _getChildrenInternal(QueryRegistryTreeEntry parentElement) {
        return null;
    }

    public Object getParent(Object element) {
        return this.getParentInternal(element);
    }

    protected Object _getParentInternal(QueryRegistryTreeInput element) {
        return null;
    }

    protected Object _getParentInternal(QueryRegistryTreeSource element) {
        return element.getParent();
    }

    protected Object _getParentInternal(QueryRegistryTreePackage element) {
        return element.getParent();
    }

    protected Object _getParentInternal(QueryRegistryTreeEntry element) {
        return element.getParent();
    }

    public boolean hasChildren(Object element) {
        return this.hasChildrenInternal(element);
    }

    protected boolean _hasChildrenInternal(QueryRegistryTreeInput element) {
        boolean _isEmpty = element.getSources().isEmpty();
        return !_isEmpty;
    }

    protected boolean _hasChildrenInternal(QueryRegistryTreeSource element) {
        boolean _isEmpty = element.getPackages().isEmpty();
        return !_isEmpty;
    }

    protected boolean _hasChildrenInternal(QueryRegistryTreePackage element) {
        boolean _isEmpty = element.getEntries().isEmpty();
        return !_isEmpty;
    }

    protected boolean _hasChildrenInternal(QueryRegistryTreeEntry element) {
        return false;
    }

    public Object[] getChildrenInternal(Object parentElement) {
        if (parentElement instanceof QueryRegistryTreeEntry) {
            return this._getChildrenInternal((QueryRegistryTreeEntry)parentElement);
        }
        if (parentElement instanceof QueryRegistryTreeInput) {
            return this._getChildrenInternal((QueryRegistryTreeInput)parentElement);
        }
        if (parentElement instanceof QueryRegistryTreePackage) {
            return this._getChildrenInternal((QueryRegistryTreePackage)parentElement);
        }
        if (parentElement instanceof QueryRegistryTreeSource) {
            return this._getChildrenInternal((QueryRegistryTreeSource)parentElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(parentElement).toString());
    }

    public Object getParentInternal(Object element) {
        if (element instanceof QueryRegistryTreeEntry) {
            return this._getParentInternal((QueryRegistryTreeEntry)element);
        }
        if (element instanceof QueryRegistryTreeInput) {
            return this._getParentInternal((QueryRegistryTreeInput)element);
        }
        if (element instanceof QueryRegistryTreePackage) {
            return this._getParentInternal((QueryRegistryTreePackage)element);
        }
        if (element instanceof QueryRegistryTreeSource) {
            return this._getParentInternal((QueryRegistryTreeSource)element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public boolean hasChildrenInternal(Object element) {
        if (element instanceof QueryRegistryTreeEntry) {
            return this._hasChildrenInternal((QueryRegistryTreeEntry)element);
        }
        if (element instanceof QueryRegistryTreeInput) {
            return this._hasChildrenInternal((QueryRegistryTreeInput)element);
        }
        if (element instanceof QueryRegistryTreePackage) {
            return this._hasChildrenInternal((QueryRegistryTreePackage)element);
        }
        if (element instanceof QueryRegistryTreeSource) {
            return this._hasChildrenInternal((QueryRegistryTreeSource)element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    @FinalFieldsConstructor
    public static class QueryRegistryTreeViewListener
    implements IQuerySpecificationRegistryChangeListener {
        private final QueryRegistryTreeInput input;
        private final TreeViewer viewer;

        public void entryAdded(IQuerySpecificationRegistryEntry entry) {
            QueryRegistryTreeInputChange newEntry = this.input.addEntryToInput(entry);
            Runnable _function = () -> {
                boolean _isPckgAffected;
                boolean _isSourceAffected = newEntry.isSourceAffected();
                if (_isSourceAffected) {
                    this.viewer.add((Object)this.input, (Object)newEntry.getSource());
                }
                if (_isPckgAffected = newEntry.isPckgAffected()) {
                    this.viewer.add((Object)newEntry.getSource(), (Object)newEntry.getPckg());
                }
                this.viewer.add((Object)newEntry.getPckg(), (Object)newEntry.getEntry());
            };
            this.viewer.getTree().getDisplay().asyncExec(_function);
        }

        public void entryRemoved(IQuerySpecificationRegistryEntry entry) {
            QueryRegistryTreeInputChange oldEntry = this.input.removeEntry(entry);
            if (oldEntry != null) {
                Runnable _function = () -> {
                    boolean _isSourceAffected;
                    this.viewer.remove((Object)oldEntry.getEntry());
                    boolean _isPckgAffected = oldEntry.isPckgAffected();
                    if (_isPckgAffected) {
                        this.viewer.remove((Object)oldEntry.getPckg());
                    }
                    if (_isSourceAffected = oldEntry.isSourceAffected()) {
                        this.viewer.remove((Object)oldEntry.getSource());
                    }
                };
                this.viewer.getTree().getDisplay().asyncExec(_function);
            }
        }

        public QueryRegistryTreeViewListener(QueryRegistryTreeInput input, TreeViewer viewer) {
            this.input = input;
            this.viewer = viewer;
        }
    }
}

