/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.ui.tools.api.util.EclipseUIUtil;
import org.eclipse.sirius.diagram.ui.tools.api.editor.DDiagramEditor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.AbstractTabbarFiller;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.ExtensionPointTabbarContributorProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.ITabbarContributorProvider;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarFillerWithContributions;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarFillerWithContributor;
import org.eclipse.sirius.diagram.ui.tools.internal.editor.tabbar.TabbarToolBarManager;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class Tabbar
extends Composite
implements ISelectionListener,
IAuthorityListener {
    public static final String TABBAR_ID = "org.eclipse.sirius.diagram.ui.tabbar";
    private IDiagramWorkbenchPart part;
    private IWorkbenchPage page;
    private ToolBar toolBar;
    private ToolBarManager manager;
    private AbstractTabbarFiller diagramFiller;
    private IPermissionAuthority permissionAuthority;
    private ITabbarContributorProvider tabbarContributorProvider;
    private Collection<Object> currentSelection;
    private boolean closingInProgress;

    public Tabbar(Composite parent, IDiagramWorkbenchPart part) {
        super(parent, 0);
        this.setLayoutData(new GridData(768));
        this.part = part;
        this.page = part.getSite().getPage();
        GridLayout layout = new GridLayout(1, true);
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.tabbarContributorProvider = new ExtensionPointTabbarContributorProvider();
        this.createToolBar();
        this.fillForDiagram();
    }

    public IToolBarManager getToolBarManager() {
        return this.manager;
    }

    private void createToolBar() {
        this.toolBar = new ToolBar((Composite)this, 0x800000);
        this.toolBar.setBackgroundMode(1);
        this.toolBar.setLayoutData((Object)new GridData(768));
        this.manager = new TabbarToolBarManager(this.toolBar, (IWorkbenchPart)this.part);
        this.setPermissionAuthorityListener();
    }

    private void setPermissionAuthorityListener() {
        DDiagramEditor editor;
        Session session;
        if (this.part instanceof DDiagramEditor && (session = (editor = (DDiagramEditor)this.part).getSession()) != null) {
            this.permissionAuthority = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(session.getSessionResource().getResourceSet());
            if (this.permissionAuthority != null) {
                this.permissionAuthority.addAuthorityListener((IAuthorityListener)this);
            }
        }
    }

    private void fillForDiagram() {
        this.diagramFiller = this.tabbarContributorProvider.hasContributor() ? new TabbarFillerWithContributor(this.manager, this.page, this.tabbarContributorProvider) : new TabbarFillerWithContributions(this.manager, this.page);
        this.diagramFiller.setPart(this.part);
        this.diagramFiller.fill();
    }

    public void selectionChanged(IWorkbenchPart partSelected, ISelection selection) {
        if (!(partSelected != this.part || this.currentSelection != null && this.sameSelection(selection))) {
            if (selection instanceof StructuredSelection) {
                this.currentSelection = ((StructuredSelection)selection).toList();
            }
            this.reinitToolBar(selection);
        }
    }

    private boolean sameSelection(ISelection selection) {
        List newSelection;
        if (selection instanceof StructuredSelection && (newSelection = ((StructuredSelection)selection).toList()).size() == this.currentSelection.size()) {
            return this.currentSelection.containsAll(newSelection);
        }
        return false;
    }

    public void reinitToolBar(ISelection iSelection) {
        if (this.diagramFiller != null) {
            this.diagramFiller.update(iSelection);
            this.updateAllItems();
        }
    }

    public void dispose() {
        this.unSetPermissionAuthorityListener();
        if (this.diagramFiller != null) {
            this.diagramFiller.dispose();
            this.diagramFiller = null;
        }
        this.manager.dispose();
        this.manager.removeAll();
        this.part = null;
        this.page = null;
        this.toolBar.dispose();
        this.toolBar = null;
    }

    private void unSetPermissionAuthorityListener() {
        this.permissionAuthority.removeAuthorityListener((IAuthorityListener)this);
        this.permissionAuthority = null;
    }

    private void updateAllItems() {
        EclipseUIUtil.displayAsyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!Tabbar.this.isClosingInProgress()) {
                    try {
                        List<IContributionItem> items = Arrays.asList(Tabbar.this.manager.getItems());
                        for (IContributionItem item : items) {
                            item.update();
                        }
                    }
                    catch (IllegalStateException illegalStateException) {}
                }
            }
        });
    }

    public void notifyIsLocked(EObject instance) {
        this.updateAllItems();
    }

    public void notifyIsReleased(EObject instance) {
        this.updateAllItems();
    }

    public void notifyIsLocked(Collection<EObject> instances) {
        this.updateAllItems();
    }

    public void notifyIsReleased(Collection<EObject> instances) {
        this.updateAllItems();
    }

    public boolean setFocus() {
        return false;
    }

    public void closingInProgress() {
        this.closingInProgress = true;
    }

    protected boolean isClosingInProgress() {
        return this.closingInProgress;
    }
}

