/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.ActionUtils;
import org.eclipse.php.internal.ui.actions.SelectionConverter;
import org.eclipse.php.internal.ui.actions.SelectionDispatchAction;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenamePHPElementAction
extends SelectionDispatchAction {
    protected PHPStructuredEditor fEditor;

    public RenamePHPElementAction(IWorkbenchSite site) {
        super(site);
    }

    public RenamePHPElementAction(PHPStructuredEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    @Override
    public void selectionChanged(IStructuredSelection selection) {
        try {
            if (selection.size() == 1) {
                this.setEnabled(RenamePHPElementAction.canEnable(selection));
                return;
            }
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
        }
        this.setEnabled(false);
    }

    private static boolean canEnable(IStructuredSelection selection) throws CoreException {
        IModelElement element = RenamePHPElementAction.getPHPElement(selection);
        if (element == null) {
            return false;
        }
        return RenamePHPElementAction.isRenameAvailable(element);
    }

    private static IModelElement getPHPElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IModelElement)) {
            return null;
        }
        return (IModelElement)first;
    }

    @Override
    public void run(IStructuredSelection selection) {
        IModelElement element = RenamePHPElementAction.getPHPElement(selection);
        if (element == null) {
            super.run(selection);
            return;
        }
        try {
            this.run(element);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, PHPUIMessages.RenamePHPElementAction_name, PHPUIMessages.RenamePHPElementAction_exception);
        }
    }

    @Override
    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    @Override
    public void run(ITextSelection selection) {
        try {
            IModelElement element = this.getPHPElement();
            if (element != null && RenamePHPElementAction.isRenameAvailable(element)) {
                this.run(element);
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, PHPUIMessages.RenamePHPElementAction_name, PHPUIMessages.RenamePHPElementAction_exception);
        }
        MessageDialog.openInformation((Shell)this.getShell(), (String)PHPUIMessages.RenamePHPElementAction_name, (String)PHPUIMessages.RenamePHPElementAction_not_available);
    }

    public boolean canRun() throws ModelException {
        IModelElement element = this.getPHPElement();
        if (element == null) {
            return false;
        }
        try {
            return RenamePHPElementAction.isRenameAvailable(element);
        }
        catch (CoreException e) {
            PHPUiPlugin.log(e);
            return false;
        }
    }

    private IModelElement getPHPElement() throws ModelException {
        IModelElement[] elements = SelectionConverter.codeResolve(this.fEditor);
        if (elements == null || elements.length != 1) {
            return null;
        }
        return elements[0];
    }

    private void run(IModelElement element) throws CoreException {
        if (!ActionUtils.isProcessable(this.getShell(), element)) {
            return;
        }
        throw new RuntimeException(PHPUIMessages.RenamePHPElementAction_0);
    }

    private static boolean isRenameAvailable(IModelElement element) throws CoreException {
        return false;
    }
}

