/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.extension;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardCollectionElement;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionRegistryReader;
import org.eclipse.pde.internal.ui.wizards.extension.PointSelectionPage;

public class NewExtensionWizard
extends NewWizard {
    public static final String PLUGIN_POINT = "newExtension";
    private PointSelectionPage fPointPage;
    private IPluginModelBase fModel;
    private IProject fProject;
    private ManifestEditor fEditor;
    private WizardCollectionElement fWizardCollection;

    public NewExtensionWizard(IProject project, IPluginModelBase model, ManifestEditor editor) {
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWEX_WIZ);
        this.fModel = model;
        this.fProject = project;
        this.fEditor = editor;
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(PDEUIMessages.NewExtensionWizard_wtitle);
        this.loadWizardCollection();
    }

    public void addPages() {
        this.fPointPage = new PointSelectionPage(this.fProject, this.fModel, this.fWizardCollection, this.getTemplates(), this);
        this.addPage((IWizardPage)this.fPointPage);
    }

    private void loadWizardCollection() {
        NewExtensionRegistryReader reader = new NewExtensionRegistryReader();
        this.fWizardCollection = (WizardCollectionElement)reader.readRegistry(PDEPlugin.getPluginId(), PLUGIN_POINT, false);
    }

    public WizardCollectionElement getTemplates() {
        WizardCollectionElement templateCollection = new WizardCollectionElement("", "", null);
        this.collectTemplates(this.fWizardCollection.getChildren(), templateCollection);
        return templateCollection;
    }

    private void collectTemplates(Object[] children, WizardCollectionElement list) {
        Object[] objectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            WizardElement wizard;
            Object child = objectArray[n2];
            if (child instanceof WizardCollectionElement) {
                WizardCollectionElement element = (WizardCollectionElement)child;
                this.collectTemplates(element.getChildren(), list);
                this.collectTemplates(element.getWizards().getChildren(), list);
            } else if (child instanceof WizardElement && (wizard = (WizardElement)child).isTemplate()) {
                list.getWizards().add(wizard);
            }
            ++n2;
        }
    }

    @Override
    public boolean performFinish() {
        this.fPointPage.checkModel();
        if (this.fPointPage.canFinish()) {
            return this.fPointPage.finish();
        }
        return true;
    }

    public ManifestEditor getEditor() {
        return this.fEditor;
    }
}

