/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.sort;

import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.gui.TableFormat;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyResolver;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.nattable.glazedlists.PapyrusSortingState;
import org.eclipse.papyrus.infra.nattable.glazedlists.copy.SortingState;
import org.eclipse.papyrus.infra.nattable.manager.refresh.CustomStructuralRefreshEvent;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.sort.AbstractGlazedListSortModel;
import org.eclipse.papyrus.infra.nattable.sort.ColumnSortUtils;
import org.eclipse.papyrus.infra.nattable.sort.PapyrusNatColumnTableFormat;
import org.eclipse.papyrus.infra.nattable.sort.PapyrusNatTableComparatorChooser;
import org.eclipse.papyrus.infra.nattable.sort.SaveSortedColumnCommand;
import org.eclipse.papyrus.infra.nattable.sort.copy.NatTableComparatorChooser;
import org.eclipse.papyrus.infra.nattable.utils.TableEditingDomainUtils;

public class PapyrusGlazedListsSortModel
extends AbstractGlazedListSortModel {
    protected IColumnAccessor<Object> columnAccessor;
    protected SortedList<Object> sortedList;
    private NatTableComparatorChooser<Object> comparatorChooser;
    protected IColumnPropertyResolver columnPropertyResolver;
    protected ILayer columnHeaderDataLayer;
    protected PapyrusNatColumnTableFormat<Object> f;

    public PapyrusGlazedListsSortModel(INattableModelManager manager, SortedList<Object> sortedList, IColumnAccessor<Object> columnAccessor) {
        super(manager);
        this.columnAccessor = columnAccessor;
        this.sortedList = sortedList;
    }

    protected NatTableComparatorChooser<Object> getComparatorChooser() {
        if (this.comparatorChooser == null) {
            this.f = new PapyrusNatColumnTableFormat<Object>(this.columnAccessor, this.getTableManager(), this.columnHeaderDataLayer);
            this.comparatorChooser = new PapyrusNatTableComparatorChooser((SortedList)this.sortedList, (TableFormat)this.f){

                @Override
                protected SortingState createSortingState() {
                    return new PapyrusSortingState(this, PapyrusGlazedListsSortModel.this.getTableManager());
                }
            };
        }
        return this.comparatorChooser;
    }

    protected IConfigRegistry getConfigRegistry() {
        NatTable nat = (NatTable)this.getTableManager().getAdapter(NatTable.class);
        return nat.getConfigRegistry();
    }

    public List<Integer> getSortedColumnIndexes() {
        return this.getComparatorChooser().getSortingColumns();
    }

    public int getSortOrder(int columnIndex) {
        return this.getComparatorChooser().getClickSequence(columnIndex);
    }

    public SortDirectionEnum getSortDirection(int columnIndex) {
        return this.getComparatorChooser().getSortDirectionForColumnIndex(columnIndex);
    }

    public boolean isColumnIndexSorted(int columnIndex) {
        return this.getComparatorChooser().isColumnIndexSorted(columnIndex);
    }

    public List<Comparator> getComparatorsForColumnIndex(int columnIndex) {
        return this.getComparatorChooser().getComparatorsForColumn(columnIndex);
    }

    public void sort(int columnIndex, SortDirectionEnum sortDirection, boolean accumulate) {
        TransactionalEditingDomain d = TableEditingDomainUtils.getTableEditingDomain(this.getTableManager().getTable());
        if (d == null) {
            d = TableEditingDomainUtils.getTableContextEditingDomain(this.getTableManager().getTable());
        }
        SaveSortedColumnCommand cmd = new SaveSortedColumnCommand(d, this.getTableManager(), this.comparatorChooser, this.getSortedColumnIndexes());
        this.getComparatorChooser().sort(columnIndex, sortDirection, accumulate);
        d.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)cmd));
    }

    public void clear() {
        this.getComparatorChooser().clearComparator();
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof CustomStructuralRefreshEvent && ((CustomStructuralRefreshEvent)event).isSortModelAlreadyNotified()) {
            return;
        }
        if (event instanceof StructuralRefreshEvent && ((StructuralRefreshEvent)event).isHorizontalStructureChanged()) {
            String test = this.getComparatorChooser().toString();
            if (test.contains("-")) {
                return;
            }
            this.comparatorChooser = null;
            test = ColumnSortUtils.buildComparatorValues(this.getTableManager());
            this.getComparatorChooser().fromString(test);
        }
        if (event instanceof CustomStructuralRefreshEvent) {
            ((CustomStructuralRefreshEvent)event).setSortModelAlreadyNotified();
        }
    }

    public void setColumnHeaderLayer(ILayer compositeLayer) {
        if (this.columnHeaderDataLayer != null) {
            this.columnHeaderDataLayer.removeLayerListener((ILayerListener)this);
        }
        this.columnHeaderDataLayer = compositeLayer;
        this.columnHeaderDataLayer.addLayerListener((ILayerListener)this);
        String encodedSort = ColumnSortUtils.buildComparatorValues(this.getTableManager());
        this.getComparatorChooser().fromString(encodedSort);
        if (this.comparatorChooser instanceof PapyrusNatTableComparatorChooser) {
            ((PapyrusNatTableComparatorChooser)this.comparatorChooser).rebuildComparator();
        }
    }

    public void updateSort() {
    }

    public Comparator<?> getColumnComparator(int columnIndex) {
        return null;
    }
}

