/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.nattable.Activator;
import org.eclipse.papyrus.infra.nattable.manager.axis.IAxisManagerForEventList;
import org.eclipse.papyrus.infra.nattable.manager.table.NattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.NattableaxisPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.NattableaxisconfigurationPackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;

public class UpdateTableContentListener
implements ResourceSetListener {
    protected NattableModelManager tableManager;
    protected IAxisManagerForEventList axisManager;

    public UpdateTableContentListener(NattableModelManager tableManager, IAxisManagerForEventList axisManager) {
        this.tableManager = tableManager;
        this.axisManager = axisManager;
    }

    public NotificationFilter getFilter() {
        return new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                Object feature;
                if (notification.isTouch() || notification.getNotifier() == null || notification.getFeature() == null) {
                    return false;
                }
                Object notifier = notification.getNotifier();
                if (notifier instanceof EObject) {
                    if (DiPackage.eINSTANCE.getEClassifiers().contains((Object)((EObject)notifier).eClass())) {
                        return false;
                    }
                    if (EcoreUtil.getRootContainer((EObject)((EObject)notifier).eClass()) == NattablePackage.eINSTANCE) {
                        try {
                            if (TableHelper.findTable((EObject)notifier) != UpdateTableContentListener.this.tableManager.getTable()) {
                                return false;
                            }
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
                return (feature = notification.getFeature()) != NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_DisplayFilter();
            }
        };
    }

    public final Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        return null;
    }

    protected boolean containsTreeFillingConfigurationChange(ResourceSetChangeEvent event) {
        List notifications = event.getNotifications();
        for (Notification current : notifications) {
            Object feature = current.getFeature();
            if (feature != NattableaxisconfigurationPackage.eINSTANCE.getAbstractHeaderAxisConfiguration_OwnedAxisConfigurations()) continue;
            return true;
        }
        return false;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        if (this.containsTreeFillingConfigurationChange(event)) {
            this.axisManager.fillingConfigurationsHaveChanged();
            return;
        }
        List initialNotifications = event.getNotifications();
        ArrayList<Notification> managedNotifications = new ArrayList<Notification>(initialNotifications);
        Iterator notificationsIterator = initialNotifications.iterator();
        int index = 0;
        while (notificationsIterator.hasNext()) {
            Notification current = (Notification)notificationsIterator.next();
            if (managedNotifications.contains(current)) {
                int currentEvent = current.getEventType();
                if (3 == currentEvent) {
                    current = this.getAddNotification(current, managedNotifications, index);
                } else if (6 == currentEvent || 4 == currentEvent && notificationsIterator.hasNext()) {
                    current = this.getMoveNotification(current, managedNotifications, index);
                }
                if (this.axisManager != null && current != null) {
                    this.axisManager.manageEvent(current);
                }
            }
            ++index;
        }
        this.tableManager.refreshNatTable();
    }

    protected Notification getAddNotification(Notification initialNotification, List<Notification> managedNotifications, int index) {
        Notification currentNotification = initialNotification;
        if (NattableaxisPackage.eINSTANCE.getITreeItemAxis_Children() == currentNotification.getFeature() && currentNotification.getNotifier() instanceof ITreeItemAxis && (((EObject)currentNotification.getNotifier()).eContainer() == null || ((EObject)currentNotification.getNotifier()).eContainer() instanceof AbstractAxisProvider)) {
            currentNotification = null;
        }
        return currentNotification;
    }

    protected Notification getMoveNotification(Notification initialNotification, List<Notification> managedNotifications, int index) {
        Notification currentNotification = initialNotification;
        List<Notification> remainingNotifications = managedNotifications.subList(index + 1, managedNotifications.size());
        Iterator<Notification> remainingIterator = remainingNotifications.iterator();
        boolean isAMove = false;
        while (!isAMove && remainingIterator.hasNext()) {
            Notification nextNotification = remainingIterator.next();
            int nextEventType = nextNotification.getEventType();
            if (5 != nextEventType || !currentNotification.getNotifier().equals(nextNotification.getNotifier()) || !currentNotification.getFeature().equals(nextNotification.getFeature())) continue;
            ArrayList<Object> oldValue = null;
            if (4 == currentNotification.getEventType()) {
                oldValue = new ArrayList<Object>(1);
                oldValue.add(currentNotification.getOldValue());
            } else {
                oldValue = (ArrayList<Object>)currentNotification.getOldValue();
            }
            Collection newValue = (Collection)nextNotification.getNewValue();
            isAMove = newValue.containsAll(oldValue);
            if (!isAMove) continue;
            if (oldValue.size() == newValue.size()) {
                currentNotification = null;
            } else {
                int position = 0;
                Iterator newValueIterator = newValue.iterator();
                while (newValueIterator.hasNext() && oldValue.contains(newValueIterator.next())) {
                    ++position;
                }
                ArrayList addedObject = new ArrayList(newValue);
                addedObject.removeAll(oldValue);
                currentNotification = new ENotificationImpl((InternalEObject)currentNotification.getNotifier(), 5, (EStructuralFeature)currentNotification.getFeature(), null, addedObject, position);
            }
            managedNotifications.remove(nextNotification);
        }
        return currentNotification;
    }

    public final boolean isAggregatePrecommitListener() {
        return false;
    }

    public final boolean isPrecommitOnly() {
        return false;
    }

    public final boolean isPostcommitOnly() {
        return false;
    }
}

