/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.copy.command;

import org.eclipse.nebula.widgets.nattable.command.AbstractLayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.copy.command.PasteDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class InternalPasteDataCommandHandler
extends AbstractLayerCommandHandler<PasteDataCommand> {
    protected SelectionLayer selectionLayer;
    protected InternalCellClipboard clipboard;

    public InternalPasteDataCommandHandler(SelectionLayer selectionLayer, InternalCellClipboard clipboard) {
        this.selectionLayer = selectionLayer;
        this.clipboard = clipboard;
    }

    @Override
    protected boolean doCommand(PasteDataCommand command) {
        if (this.clipboard.getCopiedCells() != null) {
            this.preInternalPaste();
            PositionCoordinate coord = this.selectionLayer.getSelectionAnchor();
            int pasteColumn = coord.getColumnPosition();
            int pasteRow = coord.getRowPosition();
            ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
            int n = iLayerCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILayerCell[] cells;
                ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
                int n3 = cells.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILayerCell cell = iLayerCellArray2[n4];
                    if (EditUtils.isCellEditable(this.selectionLayer, command.configRegistry, new PositionCoordinate(this.selectionLayer, pasteColumn, pasteRow))) {
                        this.selectionLayer.doCommand(new UpdateDataCommand(this.selectionLayer, pasteColumn, pasteRow, this.getPasteValue(cell, pasteColumn, pasteRow)));
                    }
                    if (++pasteColumn >= this.selectionLayer.getColumnCount()) break;
                    ++n4;
                }
                ++pasteRow;
                pasteColumn = coord.getColumnPosition();
                ++n2;
            }
            this.postInternalPaste();
        }
        return true;
    }

    protected Object getPasteValue(ILayerCell cell, int pasteColumn, int pasteRow) {
        return cell.getDataValue();
    }

    protected void preInternalPaste() {
    }

    protected void postInternalPaste() {
    }

    @Override
    public Class<PasteDataCommand> getCommandClass() {
        return PasteDataCommand.class;
    }
}

