/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.linuxtools.internal.rpm.ui.editor.preferences.PreferenceConstants;
import org.eclipse.linuxtools.rpm.core.utils.Utils;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileDefine;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.osgi.framework.FrameworkUtil;

public class UiUtils {
    public static void pluginSanityCheck() throws IOException {
        boolean exists = new File(PreferenceConstants.RPMMACRO_FILE).exists();
        if (!exists && Files.exists(Paths.get("/usr/bin/rpmdev-setuptree", new String[0]), new LinkOption[0])) {
            Utils.runCommandToInputStream((String[])new String[]{"rpmdev-setuptree"});
        }
        ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, FrameworkUtil.getBundle(UiUtils.class).getSymbolicName());
        String currentRpmTool = store.getString("currentRpmtools");
        if (!Files.exists(Paths.get("/usr/bin/yum", new String[0]), new LinkOption[0])) {
            if (currentRpmTool.equals("yum -C list all | grep - | cut -d \".\" -f 1")) {
                store.setValue("currentRpmtools", "rpm -qa --qf '%{NAME}\\n'");
            }
        } else if (!Files.exists(Paths.get("/usr/bin/urpmq", new String[0]), new LinkOption[0]) && currentRpmTool.equals("urpmq --list")) {
            store.setValue("currentRpmtools", "rpm -qa --qf '%{NAME}\\n'");
        }
    }

    public static String resolveDefines(Specfile specfile, String stringToResolve) {
        String workingString = stringToResolve;
        try {
            Pattern variablePattern = Pattern.compile("%\\{(\\S+?)\\}");
            Matcher variableMatcher = variablePattern.matcher(stringToResolve);
            HashSet variablesFound = new HashSet();
            while (variableMatcher.find()) {
                SpecfileDefine define;
                String variable = variableMatcher.group(1);
                if (variablesFound.contains(variable) || (define = specfile.getDefine(variable)) == null || stringToResolve.equals(define.getUnresolvedStringValue())) continue;
                workingString = workingString.replaceAll("\\%\\{" + variable + "\\}", define.getStringValue());
            }
            return workingString;
        }
        catch (Exception e) {
            return stringToResolve;
        }
    }

    public static String getPackageDefineId(SpecfileDefine define, SpecfilePackage rpmPackage) {
        return UiUtils.getPackageDefineId(define.getName(), rpmPackage);
    }

    public static String getPackageDefineId(String defineName, SpecfilePackage rpmPackage) {
        return String.valueOf(defineName.toLowerCase()) + ':' + rpmPackage.getPackageName();
    }
}

