/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.view;

import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.dataviewers.abstractview.AbstractSTDataView;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTViewer;
import org.eclipse.linuxtools.dataviewers.abstractviewers.TreeColumnViewerFilter;
import org.eclipse.linuxtools.dataviewers.actions.STExportToCSVAction;
import org.eclipse.linuxtools.dataviewers.charts.actions.ChartAction;
import org.eclipse.linuxtools.internal.gcov.action.SwitchContentProviderAction;
import org.eclipse.linuxtools.internal.gcov.parser.CovManager;
import org.eclipse.linuxtools.internal.gcov.parser.SourceFile;
import org.eclipse.linuxtools.internal.gcov.view.CovFileContentProvider;
import org.eclipse.linuxtools.internal.gcov.view.CovFolderContentProvider;
import org.eclipse.linuxtools.internal.gcov.view.CovFunctionContentProvider;
import org.eclipse.linuxtools.internal.gcov.view.CovViewer;
import org.eclipse.linuxtools.internal.gcov.view.Messages;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.OpenSourceFileAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class CovView
extends AbstractSTDataView {
    private String defaultCSVPath = "gcov.csv";
    private Label label;
    private Text fFilterText;
    private TreeColumnViewerFilter fViewerFilter;
    private Action folderAction;
    private Action fileAction;
    private Action functionAction;

    protected AbstractSTViewer createAbstractSTViewer(Composite parent) {
        return new CovViewer(parent);
    }

    protected void contributeToToolbar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.folderAction);
        manager.add((IAction)this.fileAction);
        manager.add((IAction)this.functionAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ChartAction(this.getViewSite().getShell(), this.getSTViewer()));
    }

    protected void createActions() {
        super.createActions();
        this.folderAction = new SwitchContentProviderAction(Messages.CovView_sort_coverage_per_folder, "icons/directory_obj.gif", this.getSTViewer().getViewer(), (IContentProvider)CovFolderContentProvider.sharedInstance);
        this.fileAction = new SwitchContentProviderAction(Messages.CovView_sort_coverage_per_file, "icons/c_file_obj.gif", this.getSTViewer().getViewer(), (IContentProvider)CovFileContentProvider.sharedInstance);
        this.fileAction.setChecked(true);
        this.functionAction = new SwitchContentProviderAction(Messages.CovView_sort_coverage_per_function, "icons/function_obj.gif", this.getSTViewer().getViewer(), (IContentProvider)CovFunctionContentProvider.sharedInstance);
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        GridLayout l = (GridLayout)parent.getLayout();
        l.horizontalSpacing = 0;
        l.verticalSpacing = 0;
        l.marginHeight = 0;
        l.marginWidth = 0;
        this.fViewerFilter = new TreeColumnViewerFilter((TreeViewer)this.getSTViewer().getViewer(), this.getSTViewer().getAllFields()[0], true);
        this.getSTViewer().getViewer().addFilter((ViewerFilter)this.fViewerFilter);
    }

    protected void createTitle(Composite parent) {
        this.label = new Label(parent, 64);
        GridData data = new GridData(4, 1, true, false, 1, 1);
        this.label.setLayoutData((Object)data);
        this.fFilterText = new Text(parent, 2948);
        this.fFilterText.setMessage(Messages.CovView_type_filter_text);
        this.fFilterText.setToolTipText(Messages.CovView_filter_by_name);
        this.fFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fFilterText.addModifyListener(e -> {
            String text = this.fFilterText.getText();
            this.fViewerFilter.setMatchingText(text);
        });
    }

    private static void setCovViewTitle(CovView view, String title, String binaryPath, String timestamp) {
        String viewText = NLS.bind((String)Messages.CovView_view_title, (Object[])new Object[]{title, binaryPath, timestamp});
        view.label.setText(viewText);
        view.label.getParent().layout(true);
    }

    public static void displayCovDetailedResult(String binaryPath, String gcda) {
        try {
            IFile binary = STSymbolManager.sharedInstance.findFileFromPath((IPath)new Path(binaryPath));
            IProject project = null;
            if (binary != null) {
                project = binary.getProject();
            }
            CovManager cvrgeMnger = new CovManager(binaryPath, project);
            LinkedList<String> gcdaPaths = new LinkedList<String>();
            gcdaPaths.add(gcda);
            cvrgeMnger.processCovFiles(gcdaPaths, gcda);
            cvrgeMnger.fillGcovView();
            for (SourceFile sf : cvrgeMnger.getSourceMap().values()) {
                OpenSourceFileAction.openAnnotatedSourceFile(project, binary, sf, 0);
            }
        }
        catch (IOException | CoreException e) {
            CovView.reportError((Exception)e);
        }
    }

    public static void displayCovResults(String binaryPath, String gcda) {
        try {
            IFile binary = STSymbolManager.sharedInstance.findFileFromPath((IPath)new Path(binaryPath));
            IProject project = null;
            if (binary != null) {
                project = binary.getProject();
            }
            CovManager cvrgeMnger = new CovManager(binaryPath, project);
            List<String> gcdaPaths = cvrgeMnger.getGCDALocations();
            cvrgeMnger.processCovFiles(gcdaPaths, gcda);
            cvrgeMnger.fillGcovView();
            Date date = new Date(0L);
            for (String file : gcdaPaths) {
                Date dateCandidate = new Date(new File(file).lastModified());
                if (!dateCandidate.after(date)) continue;
                date = dateCandidate;
            }
            String timestamp = DateFormat.getInstance().format(date);
            PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                try {
                    CovView.displayCovResults(cvrgeMnger, timestamp);
                }
                catch (PartInitException e) {
                    CovView.reportError((Exception)((Object)e));
                }
            });
        }
        catch (IOException | InterruptedException | CoreException e) {
            CovView.reportError((Exception)e);
        }
    }

    public static void reportError(Exception ex) {
        String message = NLS.bind((String)Messages.CovView_error_message, (Object)ex.getMessage());
        Status status = new Status(4, "org.eclipse.linuxtools.gcov.core", 4, message, (Throwable)ex);
        Platform.getLog((Bundle)FrameworkUtil.getBundle(CovView.class)).log((IStatus)status);
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            Shell s = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialog.openError((Shell)s, (String)Messages.CovView_parsing_error, (String)message);
        });
    }

    public static CovView displayCovResults(CovManager cvrgeMnger, String timestamp) throws PartInitException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        CovView cvrgeView = (CovView)page.showView("org.eclipse.linuxtools.gcov.view");
        CovView.setCovViewTitle(cvrgeView, Integer.toString((int)cvrgeMnger.getNbrPgmRuns()), cvrgeMnger.getBinaryPath(), timestamp);
        cvrgeView.setInput(cvrgeMnger);
        CovViewer stviewer = (CovViewer)cvrgeView.getSTViewer();
        stviewer.getViewer().expandToLevel(2);
        return cvrgeView;
    }

    protected IAction createExportToCSVAction() {
        STExportToCSVAction action = new STExportToCSVAction(this.getSTViewer()){

            public void run() {
                Object o = CovView.this.getSTViewer().getInput();
                if (o instanceof CovManager) {
                    this.getExporter().setFilePath(CovView.this.defaultCSVPath);
                }
                super.run();
            }
        };
        return action;
    }
}

