/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.tester;

import java.io.IOException;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.exec.ExecuteException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.tester.interfaces.ITester;
import org.eclipse.jubula.tools.exec.CommandExecutor;
import org.eclipse.jubula.tools.internal.objects.event.EventFactory;
import org.eclipse.jubula.tools.internal.objects.event.TestErrorEvent;

public class OperatingSystemTester
implements ITester {
    public void setComponent(Object graphicsComponent) {
    }

    public String[] getTextArrayFromComponent() {
        return null;
    }

    public String rcExec(int timeout, String workingDir, String executable, @Nullable String args, @Nullable String argSplitChar, int expectedExitCode, String execEnvironment, String outputEncoding, boolean newEnvironment) {
        if ("AUT".equals(execEnvironment)) {
            return this.rcExec(timeout, workingDir, executable, args, argSplitChar, expectedExitCode, outputEncoding, newEnvironment);
        }
        return null;
    }

    public String rcExec(int timeout, String workingDir, String executable, @Nullable String args, @Nullable String argSplitChar, int expectedExitCode, String outputEncoding, boolean newEnvironment) {
        try {
            char splitChar = (argSplitChar != null ? Character.valueOf(argSplitChar.charAt(0)) : null).charValue();
            CommandExecutor.Result result = CommandExecutor.exec((String)workingDir, (String)executable, (String)args, (Character)Character.valueOf(splitChar), (long)timeout, (String)outputEncoding, (Boolean)newEnvironment);
            int exitCode = result.getReturnValue();
            if (exitCode != expectedExitCode) {
                TestErrorEvent event = EventFactory.createVerifyFailed((String)String.valueOf(expectedExitCode), (String)String.valueOf(exitCode));
                event.addProp("jubulaCommandLog", (Object)result.getCombinedOutput());
                throw new StepExecutionException("Verification of exit code failed.", event);
            }
            return result.getCombinedOutput();
        }
        catch (IllegalCharsetNameException e) {
            throw new StepExecutionException(e);
        }
        catch (UnsupportedCharsetException e) {
            throw new StepExecutionException(e);
        }
        catch (ExecuteException e) {
            throw new StepExecutionException(e);
        }
        catch (IOException iOException) {
            throw new StepExecutionException("Command not found.", EventFactory.createActionError((String)"TestErrorEvent.NoSuchCommand"));
        }
        catch (InterruptedException e) {
            throw new StepExecutionException(e);
        }
        catch (TimeoutException e) {
            TestErrorEvent event = EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout");
            event.addProp("jubulaCommandLog", (Object)e.getMessage());
            throw new StepExecutionException("Timeout received before completing execution of script.", event);
        }
    }
}

