/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.dom.fragments;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.SourceRange;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.JdtASTMatcher;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTFragmentFactory;
import org.eclipse.jdt.internal.corext.dom.fragments.ASTMatchingFragmentFinder;
import org.eclipse.jdt.internal.corext.dom.fragments.IASTFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.IExpressionFragment;
import org.eclipse.jdt.internal.corext.dom.fragments.Util;
import org.eclipse.text.edits.TextEditGroup;

class AssociativeInfixExpressionFragment
extends ASTFragment
implements IExpressionFragment {
    private final List<Expression> fOperands;
    private final InfixExpression fGroupRoot;

    public static IExpressionFragment createSubPartFragmentBySourceRange(InfixExpression node, ISourceRange range, ICompilationUnit cu) throws JavaModelException {
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)range);
        Assert.isTrue((!Util.covers(range, (ASTNode)node) ? 1 : 0) != 0);
        Assert.isTrue((boolean)Util.covers(SourceRangeFactory.create((ASTNode)node), range));
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node)) {
            return null;
        }
        InfixExpression groupRoot = AssociativeInfixExpressionFragment.findGroupRoot(node);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        ArrayList<Expression> groupMembers = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(groupRoot);
        List<Expression> subGroup = AssociativeInfixExpressionFragment.findSubGroupForSourceRange(groupMembers, range);
        if (subGroup.isEmpty() || AssociativeInfixExpressionFragment.rangeIncludesExtraNonWhitespace(range, subGroup, cu)) {
            return null;
        }
        return new AssociativeInfixExpressionFragment(groupRoot, subGroup);
    }

    public static IExpressionFragment createFragmentForFullSubtree(InfixExpression node) {
        Assert.isNotNull((Object)node);
        if (!AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node)) {
            return null;
        }
        InfixExpression groupRoot = AssociativeInfixExpressionFragment.findGroupRoot(node);
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        ArrayList<Expression> groupMembers = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(node);
        return new AssociativeInfixExpressionFragment(groupRoot, groupMembers);
    }

    private static InfixExpression findGroupRoot(InfixExpression node) {
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)node));
        while (!AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)node)) {
            ASTNode parent = node.getParent();
            Assert.isNotNull((Object)parent);
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix(parent));
            Assert.isTrue((((InfixExpression)parent).getOperator() == node.getOperator() ? 1 : 0) != 0);
            node = (InfixExpression)parent;
        }
        return node;
    }

    private static List<Expression> findSubGroupForSourceRange(List<Expression> group, ISourceRange range) {
        Assert.isTrue((!group.isEmpty() ? 1 : 0) != 0);
        ArrayList<Expression> subGroup = new ArrayList<Expression>();
        boolean entered = false;
        boolean exited = false;
        if (range.getOffset() == group.get(0).getStartPosition()) {
            entered = true;
        }
        int i = 0;
        while (i < group.size() - 1) {
            Expression member = group.get(i);
            Expression nextMember = group.get(i + 1);
            if (entered) {
                subGroup.add(member);
                if (AssociativeInfixExpressionFragment.rangeEndsBetween(range, (ASTNode)member, (ASTNode)nextMember)) {
                    exited = true;
                    break;
                }
            } else if (AssociativeInfixExpressionFragment.rangeStartsBetween(range, (ASTNode)member, (ASTNode)nextMember)) {
                entered = true;
            }
            ++i;
        }
        Expression lastGroupMember = group.get(group.size() - 1);
        if (Util.getEndExclusive(range) == Util.getEndExclusive(SourceRangeFactory.create((ASTNode)lastGroupMember))) {
            subGroup.add(lastGroupMember);
            exited = true;
        }
        if (!exited) {
            return new ArrayList<Expression>(0);
        }
        return subGroup;
    }

    private static boolean rangeStartsBetween(ISourceRange range, ASTNode first, ASTNode next) {
        int pos = range.getOffset();
        return first.getStartPosition() + first.getLength() <= pos && pos <= next.getStartPosition();
    }

    private static boolean rangeEndsBetween(ISourceRange range, ASTNode first, ASTNode next) {
        int pos = Util.getEndExclusive(range);
        return first.getStartPosition() + first.getLength() <= pos && pos <= next.getStartPosition();
    }

    private static boolean rangeIncludesExtraNonWhitespace(ISourceRange range, List<Expression> operands, ICompilationUnit cu) throws JavaModelException {
        return Util.rangeIncludesNonWhitespaceOutsideRange(range, AssociativeInfixExpressionFragment.getRangeOfOperands(operands), cu.getBuffer());
    }

    private static ISourceRange getRangeOfOperands(List<Expression> operands) {
        Expression first = operands.get(0);
        Expression last = operands.get(operands.size() - 1);
        return new SourceRange(first.getStartPosition(), last.getStartPosition() + last.getLength() - first.getStartPosition());
    }

    @Override
    public IASTFragment[] getMatchingFragmentsWithNode(ASTNode node) {
        IASTFragment fragmentForNode = ASTFragmentFactory.createFragmentForFullSubtree(node);
        if (fragmentForNode instanceof AssociativeInfixExpressionFragment) {
            AssociativeInfixExpressionFragment kin = (AssociativeInfixExpressionFragment)fragmentForNode;
            return kin.getSubFragmentsWithMyNodeMatching(this);
        }
        return new IASTFragment[0];
    }

    private static List<List<Expression>> getMatchingContiguousNodeSubsequences(List<Expression> source, List<Expression> toMatch) {
        ArrayList<List<Expression>> subsequences = new ArrayList<List<Expression>>();
        int i = 0;
        while (i < source.size()) {
            if (AssociativeInfixExpressionFragment.matchesAt(i, source, toMatch)) {
                subsequences.add(source.subList(i, i + toMatch.size()));
                i += toMatch.size();
                continue;
            }
            ++i;
        }
        return subsequences;
    }

    private static boolean matchesAt(int index, List<Expression> subject, List<Expression> toMatch) {
        if (index + toMatch.size() > subject.size()) {
            return false;
        }
        int i = 0;
        while (i < toMatch.size()) {
            if (!JdtASTMatcher.doNodesMatch((ASTNode)subject.get(index), (ASTNode)toMatch.get(i))) {
                return false;
            }
            ++i;
            ++index;
        }
        return true;
    }

    private static boolean isAGroupRoot(ASTNode node) {
        Assert.isNotNull((Object)node);
        return AssociativeInfixExpressionFragment.isAssociativeInfix(node) && !AssociativeInfixExpressionFragment.isParentInfixWithSameOperator((InfixExpression)node);
    }

    private static boolean isAssociativeInfix(ASTNode node) {
        return node instanceof InfixExpression && AssociativeInfixExpressionFragment.isOperatorAssociative(((InfixExpression)node).getOperator());
    }

    private static boolean isParentInfixWithSameOperator(InfixExpression node) {
        return node.getParent() instanceof InfixExpression && ((InfixExpression)node.getParent()).getOperator() == node.getOperator();
    }

    private static boolean isOperatorAssociative(InfixExpression.Operator operator) {
        return operator == InfixExpression.Operator.PLUS || operator == InfixExpression.Operator.TIMES || operator == InfixExpression.Operator.XOR || operator == InfixExpression.Operator.OR || operator == InfixExpression.Operator.AND || operator == InfixExpression.Operator.CONDITIONAL_OR || operator == InfixExpression.Operator.CONDITIONAL_AND;
    }

    private AssociativeInfixExpressionFragment(InfixExpression groupRoot, List<Expression> operands) {
        Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAGroupRoot((ASTNode)groupRoot));
        Assert.isTrue((operands.size() >= 2 ? 1 : 0) != 0);
        this.fGroupRoot = groupRoot;
        this.fOperands = Collections.unmodifiableList(operands);
    }

    @Override
    public boolean matches(IASTFragment other) {
        if (!other.getClass().equals(this.getClass())) {
            return false;
        }
        AssociativeInfixExpressionFragment otherOfKind = (AssociativeInfixExpressionFragment)other;
        return this.getOperator() == otherOfKind.getOperator() && this.doOperandsMatch(otherOfKind);
    }

    private boolean doOperandsMatch(AssociativeInfixExpressionFragment other) {
        if (this.getOperands().size() != other.getOperands().size()) {
            return false;
        }
        Iterator<Expression> myOperands = this.getOperands().iterator();
        Iterator<Expression> othersOperands = other.getOperands().iterator();
        while (myOperands.hasNext() && othersOperands.hasNext()) {
            Expression othersOperand;
            Expression myOperand = myOperands.next();
            if (JdtASTMatcher.doNodesMatch((ASTNode)myOperand, (ASTNode)(othersOperand = othersOperands.next()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IASTFragment[] getSubFragmentsMatching(IASTFragment toMatch) {
        return AssociativeInfixExpressionFragment.union(this.getSubFragmentsWithMyNodeMatching(toMatch), this.getSubFragmentsWithAnotherNodeMatching(toMatch));
    }

    private IASTFragment[] getSubFragmentsWithMyNodeMatching(IASTFragment toMatch) {
        if (toMatch.getClass() != this.getClass()) {
            return new IASTFragment[0];
        }
        AssociativeInfixExpressionFragment kinToMatch = (AssociativeInfixExpressionFragment)toMatch;
        if (kinToMatch.getOperator() != this.getOperator()) {
            return new IASTFragment[0];
        }
        List<List<Expression>> matchingSubsequences = AssociativeInfixExpressionFragment.getMatchingContiguousNodeSubsequences(this.getOperands(), kinToMatch.getOperands());
        IASTFragment[] matches = new IASTFragment[matchingSubsequences.size()];
        int i = 0;
        while (i < matchingSubsequences.size()) {
            AssociativeInfixExpressionFragment match = new AssociativeInfixExpressionFragment(this.fGroupRoot, matchingSubsequences.get(i));
            Assert.isTrue((match.matches(toMatch) || toMatch.matches(match) ? 1 : 0) != 0);
            matches[i] = match;
            ++i;
        }
        return matches;
    }

    private IASTFragment[] getSubFragmentsWithAnotherNodeMatching(IASTFragment toMatch) {
        IASTFragment[] result = new IASTFragment[]{};
        Iterator<Expression> iterator = this.getOperands().iterator();
        while (iterator.hasNext()) {
            Expression expression;
            Expression operand = expression = iterator.next();
            result = AssociativeInfixExpressionFragment.union(result, ASTMatchingFragmentFinder.findMatchingFragments((ASTNode)operand, (ASTFragment)toMatch));
        }
        return result;
    }

    private static IASTFragment[] union(IASTFragment[] a1, IASTFragment[] a2) {
        IASTFragment[] union = new IASTFragment[a1.length + a2.length];
        System.arraycopy(a1, 0, union, 0, a1.length);
        System.arraycopy(a2, 0, union, a1.length, a2.length);
        return union;
    }

    @Override
    public Expression getAssociatedExpression() {
        return this.fGroupRoot;
    }

    @Override
    public ASTNode getAssociatedNode() {
        return this.fGroupRoot;
    }

    public InfixExpression getGroupRoot() {
        return this.fGroupRoot;
    }

    @Override
    public int getLength() {
        return this.getEndPositionExclusive() - this.getStartPosition();
    }

    private int getEndPositionExclusive() {
        List<Expression> operands = this.getOperands();
        ASTNode lastNode = (ASTNode)operands.get(operands.size() - 1);
        return lastNode.getStartPosition() + lastNode.getLength();
    }

    @Override
    public int getStartPosition() {
        return this.getOperands().get(0).getStartPosition();
    }

    public List<Expression> getOperands() {
        return this.fOperands;
    }

    public InfixExpression.Operator getOperator() {
        return this.fGroupRoot.getOperator();
    }

    @Override
    public Expression createCopyTarget(ASTRewrite rewrite, boolean removeSurroundingParenthesis) throws JavaModelException {
        ArrayList<Expression> allOperands = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.fGroupRoot);
        if (allOperands.size() == this.fOperands.size()) {
            return (Expression)rewrite.createCopyTarget((ASTNode)this.fGroupRoot);
        }
        CompilationUnit root = (CompilationUnit)this.fGroupRoot.getRoot();
        ICompilationUnit cu = (ICompilationUnit)root.getJavaElement();
        String source = cu.getBuffer().getText(this.getStartPosition(), this.getLength());
        return (Expression)rewrite.createStringPlaceholder(source, 27);
    }

    @Override
    public void replace(ASTRewrite rewrite, ASTNode replacement, TextEditGroup textEditGroup) {
        InfixExpression groupNode = this.getGroupRoot();
        ArrayList<Expression> allOperands = AssociativeInfixExpressionFragment.findGroupMembersInOrderFor(this.getGroupRoot());
        if (allOperands.size() == this.fOperands.size()) {
            if (replacement instanceof Name && groupNode.getParent() instanceof ParenthesizedExpression) {
                rewrite.replace(groupNode.getParent(), replacement, textEditGroup);
            } else {
                rewrite.replace((ASTNode)groupNode, replacement, textEditGroup);
            }
            return;
        }
        rewrite.replace((ASTNode)this.fOperands.get(0), replacement, textEditGroup);
        int first = allOperands.indexOf(this.fOperands.get(0));
        int after = first + this.fOperands.size();
        int i = first + 1;
        while (i < after) {
            rewrite.remove((ASTNode)allOperands.get(i), textEditGroup);
            ++i;
        }
    }

    private static ArrayList<Expression> findGroupMembersInOrderFor(InfixExpression groupRoot) {
        return new GroupMemberFinder(groupRoot).fMembersInOrder;
    }

    public int hashCode() {
        return this.fGroupRoot.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AssociativeInfixExpressionFragment other = (AssociativeInfixExpressionFragment)obj;
        return this.fGroupRoot.equals((Object)other.fGroupRoot) && this.fOperands.equals(other.fOperands);
    }

    private static class GroupMemberFinder
    extends GenericVisitor {
        private ArrayList<Expression> fMembersInOrder = new ArrayList();
        private InfixExpression fGroupRoot;

        public GroupMemberFinder(InfixExpression groupRoot) {
            super(true);
            Assert.isTrue((boolean)AssociativeInfixExpressionFragment.isAssociativeInfix((ASTNode)groupRoot));
            this.fGroupRoot = groupRoot;
            this.fGroupRoot.accept((ASTVisitor)this);
        }

        @Override
        protected boolean visitNode(ASTNode node) {
            if (node instanceof InfixExpression && ((InfixExpression)node).getOperator() == this.fGroupRoot.getOperator()) {
                return true;
            }
            this.fMembersInOrder.add((Expression)node);
            return false;
        }
    }
}

