/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core.refactoring.descriptors;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.JavaRefactoringDescriptorUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class ExtractClassDescriptor
extends JavaRefactoringDescriptor {
    private static final String CREATE_GETTER_SETTER = "createGetterSetter";
    private static final String PACKAGE_NAME = "packageName";
    private static final String CLASS_NAME = "className";
    private static final String FIELD_NAME = "fieldName";
    private static final String CREATE_TOP_LEVEL = "createTopLevel";
    private static final String NEW_FIELD_COUNT = "newFieldCount";
    private static final String CREATE_FIELD_COUNT = "createFieldCount";
    private static final String CREATE_FIELD = "createField";
    private static final String NEW_FIELD_NAME = "newFieldName";
    private static final String OLD_FIELD_NAME = "oldFieldName";
    private static final String OLD_FIELD_COUNT = "oldFieldCount";
    private Field[] fFields;

    public ExtractClassDescriptor() {
        super("org.eclipse.jdt.ui.extract.class");
    }

    public ExtractClassDescriptor(String project, String description, String comment, Map<String, String> arguments, int flags) throws IllegalArgumentException {
        super("org.eclipse.jdt.ui.extract.class", project, description, comment, arguments, flags);
        if (JavaRefactoringDescriptorUtil.getString(arguments, OLD_FIELD_COUNT, true) != null) {
            String[] oldFieldNames = JavaRefactoringDescriptorUtil.getStringArray(arguments, OLD_FIELD_COUNT, OLD_FIELD_NAME, 0);
            boolean[] createField = JavaRefactoringDescriptorUtil.getBooleanArray(arguments, CREATE_FIELD_COUNT, CREATE_FIELD, 0);
            this.fFields = new Field[oldFieldNames.length];
            int i = 0;
            while (i < oldFieldNames.length) {
                this.fFields[i] = new Field(oldFieldNames[i]);
                this.fFields[i].setCreateField(createField[i]);
                if (createField[i]) {
                    this.fFields[i].setNewFieldName(JavaRefactoringDescriptorUtil.getString(arguments, JavaRefactoringDescriptorUtil.getAttributeName(NEW_FIELD_NAME, i)));
                }
                ++i;
            }
        }
    }

    public static Field[] getFields(IType type) throws JavaModelException {
        ArrayList<Field> result = new ArrayList<Field>();
        IField[] iFieldArray = type.getFields();
        int n = iFieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            IField field = iFieldArray[n2];
            if (!Flags.isStatic((int)field.getFlags()) && !field.isEnumConstant()) {
                result.add(new Field(field.getElementName()));
            }
            ++n2;
        }
        return result.toArray(new Field[result.size()]);
    }

    public void setFields(Field[] fields) throws IllegalArgumentException {
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field == null) {
                throw new IllegalArgumentException("Field can not be null");
            }
            ++n2;
        }
        this.fFields = fields;
    }

    public Field[] getFields() {
        return this.fFields;
    }

    public IType getType() {
        return (IType)JavaRefactoringDescriptorUtil.getJavaElement(this.fArguments, "input", this.getProject());
    }

    public void setType(IType type) {
        Assert.isNotNull((Object)type);
        String project = type.getJavaProject().getElementName();
        this.setProject(project);
        JavaRefactoringDescriptorUtil.setJavaElement(this.fArguments, "input", project, (IJavaElement)type);
    }

    public String getPackage() {
        return JavaRefactoringDescriptorUtil.getString(this.fArguments, PACKAGE_NAME, true);
    }

    public void setPackage(String packageName) {
        JavaRefactoringDescriptorUtil.setString(this.fArguments, PACKAGE_NAME, packageName);
    }

    public String getClassName() {
        return JavaRefactoringDescriptorUtil.getString(this.fArguments, CLASS_NAME, true);
    }

    public void setClassName(String className) {
        JavaRefactoringDescriptorUtil.setString(this.fArguments, CLASS_NAME, className);
    }

    public String getFieldName() {
        return JavaRefactoringDescriptorUtil.getString(this.fArguments, FIELD_NAME, true);
    }

    public void setFieldName(String fieldName) {
        JavaRefactoringDescriptorUtil.setString(this.fArguments, FIELD_NAME, fieldName);
    }

    public boolean isCreateTopLevel() {
        return JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, CREATE_TOP_LEVEL, true);
    }

    public void setCreateTopLevel(boolean createTopLevel) {
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, CREATE_TOP_LEVEL, createTopLevel);
    }

    public void setCreateGetterSetter(boolean createGetterSetter) {
        JavaRefactoringDescriptorUtil.setBoolean(this.fArguments, CREATE_GETTER_SETTER, createGetterSetter);
    }

    public boolean isCreateGetterSetter() {
        return JavaRefactoringDescriptorUtil.getBoolean(this.fArguments, CREATE_GETTER_SETTER, false);
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        if (this.fFields != null) {
            String[] oldFieldNames = new String[this.fFields.length];
            String[] newFieldNames = new String[this.fFields.length];
            boolean[] createField = new boolean[this.fFields.length];
            int i = 0;
            while (i < this.fFields.length) {
                Field field = this.fFields[i];
                Assert.isNotNull((Object)field);
                oldFieldNames[i] = field.getFieldName();
                createField[i] = field.isCreateField();
                if (field.isCreateField()) {
                    newFieldNames[i] = field.getNewFieldName();
                }
                ++i;
            }
            JavaRefactoringDescriptorUtil.setStringArray(this.fArguments, OLD_FIELD_COUNT, OLD_FIELD_NAME, oldFieldNames, 0);
            JavaRefactoringDescriptorUtil.setStringArray(this.fArguments, NEW_FIELD_COUNT, NEW_FIELD_NAME, newFieldNames, 0);
            JavaRefactoringDescriptorUtil.setBooleanArray(this.fArguments, CREATE_FIELD_COUNT, CREATE_FIELD, createField, 0);
        }
    }

    @Override
    public RefactoringStatus validateDescriptor() {
        RefactoringStatus status = super.validateDescriptor();
        if (this.getType() == null) {
            status.addFatalError("The type may not be null");
        }
        return status;
    }

    public static class Field {
        private final String fFieldName;
        private String fNewFieldName;
        private boolean fCreateField = true;

        private Field(String fieldName) {
            Assert.isNotNull((Object)fieldName);
            this.fFieldName = fieldName;
            this.fNewFieldName = fieldName;
        }

        public String getFieldName() {
            return this.fFieldName;
        }

        public String getNewFieldName() {
            return this.fNewFieldName;
        }

        public void setNewFieldName(String newFieldName) {
            Assert.isNotNull((Object)newFieldName);
            this.fNewFieldName = newFieldName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.fFieldName == null ? 0 : this.fFieldName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            return Objects.equals(this.fFieldName, other.fFieldName);
        }

        public String toString() {
            return "Field:" + this.fFieldName + " new name:" + this.fNewFieldName + " create field:" + this.fCreateField;
        }

        public boolean isCreateField() {
            return this.fCreateField;
        }

        public void setCreateField(boolean createField) {
            this.fCreateField = createField;
        }
    }
}

