/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.io.File;
import java.io.IOException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IResourceProvider;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.internal.synchronize.compare.ComparisonDataSource;
import org.eclipse.egit.ui.internal.synchronize.compare.GitCompareInput;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.ui.mapping.ISynchronizationCompareInput;
import org.eclipse.team.ui.mapping.SaveableComparison;

public class GitModelBlob
extends GitModelObject
implements ISynchronizationCompareInput,
IResourceProvider {
    private static final GitModelObject[] empty = new GitModelObject[0];
    private final GitCommitsModelCache.Change change;
    private ITypedElement ancestorElement;
    private ITypedElement leftElement;
    private ITypedElement rightElement;
    protected final IPath path;
    protected final Repository repo;

    public GitModelBlob(GitModelObjectContainer parent, Repository repo, GitCommitsModelCache.Change change, IPath path) {
        super(parent);
        this.repo = repo;
        this.path = path;
        this.change = change;
    }

    @Override
    public GitModelObject[] getChildren() {
        return empty;
    }

    @Override
    public String getName() {
        return this.path.lastSegment();
    }

    @Override
    public IPath getLocation() {
        return this.path;
    }

    @Override
    public boolean isContainer() {
        return false;
    }

    @Override
    public int getKind() {
        return this.change.getKind();
    }

    public AbbreviatedObjectId getBaseCommitId() {
        return this.change.getCommitId();
    }

    public AbbreviatedObjectId getRemoteCommitId() {
        return this.change.getRemoteCommitId();
    }

    @Override
    public int repositoryHashCode() {
        return this.repo.getWorkTree().hashCode();
    }

    @Override
    public void dispose() {
    }

    public String toString() {
        return "ModelBlob[objectId=" + this.change.getObjectId() + ", location=" + this.getLocation() + "]";
    }

    public Image getImage() {
        return null;
    }

    public ITypedElement getAncestor() {
        this.prepareTypedElements();
        return this.ancestorElement;
    }

    public ITypedElement getLeft() {
        this.prepareTypedElements();
        return this.leftElement;
    }

    public ITypedElement getRight() {
        this.prepareTypedElements();
        return this.rightElement;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
    }

    public void copy(boolean leftToRight) {
    }

    public SaveableComparison getSaveable() {
        return null;
    }

    public void prepareInput(CompareConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        configuration.setLeftLabel(GitCompareInput.getFileRevisionLabel(this.getLeft()));
        configuration.setRightLabel(GitCompareInput.getFileRevisionLabel(this.getRight()));
    }

    public String getFullPath() {
        return this.path.toOSString();
    }

    public boolean isCompareInputFor(Object object) {
        return false;
    }

    public int hashCode() {
        int baseHash = 1;
        if (this.change != null) {
            baseHash = this.change.getObjectId() != null ? this.change.getObjectId().hashCode() : 31;
        }
        int remoteHash = 11;
        if (this.change != null) {
            remoteHash = this.change.getRemoteObjectId() != null ? this.change.getRemoteObjectId().hashCode() : 41;
        }
        return baseHash ^ remoteHash ^ this.path.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        GitModelBlob other = (GitModelBlob)((Object)obj);
        if (this.change == null ? other.change != null : !this.change.equals((Object)other.change)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals((Object)other.path));
    }

    private void prepareTypedElements() {
        ComparisonDataSource remoteData;
        ComparisonDataSource baseData;
        if (this.ancestorElement != null) {
            return;
        }
        RevCommit baseCommit = null;
        RevCommit remoteCommit = null;
        try {
            Throwable throwable = null;
            Object var6_6 = null;
            try (RevWalk rw = new RevWalk(this.repo);){
                rw.setRetainBody(true);
                if (this.change.getCommitId() != null) {
                    baseCommit = rw.parseCommit((AnyObjectId)this.change.getCommitId().toObjectId());
                }
                if (this.change.getRemoteCommitId() != null) {
                    remoteCommit = rw.parseCommit((AnyObjectId)this.change.getRemoteCommitId().toObjectId());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError((String)e.getMessage(), (Throwable)e);
        }
        if (baseCommit == null && remoteCommit != null) {
            baseCommit = remoteCommit;
        }
        ObjectId localId = this.extractObjectId(this.change.getObjectId());
        ObjectId remoteId = this.extractObjectId(this.change.getRemoteObjectId());
        if ((this.getKind() & 8) == 8) {
            baseData = new ComparisonDataSource(baseCommit, localId);
            remoteData = new ComparisonDataSource(remoteCommit, remoteId);
        } else {
            baseData = new ComparisonDataSource(remoteCommit, remoteId);
            remoteData = new ComparisonDataSource(baseCommit, localId);
        }
        GitCompareInput compareInput = this.getCompareInput(baseData, remoteData, remoteData);
        this.ancestorElement = compareInput.getAncestor();
        this.leftElement = compareInput.getLeft();
        this.rightElement = compareInput.getRight();
    }

    public IResource getResource() {
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(this.path);
        return file;
    }

    protected GitCompareInput getCompareInput(ComparisonDataSource baseData, ComparisonDataSource remoteData, ComparisonDataSource ancestorData) {
        String gitPath = Repository.stripWorkDir((File)this.repo.getWorkTree(), (File)this.path.toFile());
        return new GitCompareInput(this.repo, ancestorData, baseData, remoteData, gitPath);
    }

    private ObjectId extractObjectId(AbbreviatedObjectId objectId) {
        if (objectId != null) {
            return objectId.toObjectId();
        }
        return ObjectId.zeroId();
    }
}

