/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.events;

import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.mi.service.command.events.MIStoppedEvent;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIFunctionFinishedEvent
extends MIStoppedEvent {
    private final String gdbResult;
    private final String returnValue;
    private final String returnType;

    protected MIFunctionFinishedEvent(IRunControl.IExecutionDMContext ctx, int token, MIResult[] results, MIFrame frame, String gdbResult, String returnValue, String returnType) {
        super(ctx, token, results, frame);
        this.gdbResult = gdbResult;
        this.returnValue = returnValue;
        this.returnType = returnType;
    }

    public String getGDBResultVar() {
        return this.gdbResult;
    }

    public String getReturnValue() {
        return this.returnValue;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public static MIFunctionFinishedEvent parse(IRunControl.IExecutionDMContext dmc, int token, MIResult[] results) {
        String gdbResult = "";
        String returnValue = "";
        String returnType = "";
        int i = 0;
        while (i < results.length) {
            String var = results[i].getVariable();
            MIValue value = results[i].getMIValue();
            String str = "";
            if (value instanceof MIConst) {
                str = ((MIConst)value).getString();
            }
            if (var.equals("gdb-result-var")) {
                gdbResult = str;
            } else if (var.equals("return-value")) {
                returnValue = str;
            } else if (var.equals("return-type")) {
                returnType = str;
            }
            ++i;
        }
        MIStoppedEvent stoppedEvent = MIStoppedEvent.parse(dmc, token, results);
        return new MIFunctionFinishedEvent((IRunControl.IExecutionDMContext)stoppedEvent.getDMContext(), token, results, stoppedEvent.getFrame(), gdbResult, returnValue, returnType);
    }
}

