/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.console;

import org.eclipse.cdt.debug.ui.debuggerconsole.IDebuggerConsole;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.GdbBasicCliConsole;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleShowPreferencesAction;
import org.eclipse.cdt.dsf.gdb.internal.ui.console.actions.GdbConsoleTerminateLaunchAction;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.internal.console.IOConsolePage;

public class GdbBasicCliConsolePage
extends IOConsolePage
implements IDebugContextListener {
    private final ILaunch fLaunch;
    private final IConsoleView fView;
    private final IDebuggerConsole fConsole;
    private GdbConsoleTerminateLaunchAction fTerminateLaunchAction;
    private GdbConsoleShowPreferencesAction fShowPreferencePageAction;

    public GdbBasicCliConsolePage(GdbBasicCliConsole gdbConsole, IConsoleView view) {
        super((TextConsole)gdbConsole, view);
        this.fConsole = gdbConsole;
        this.fView = view;
        this.fLaunch = gdbConsole.getLaunch();
    }

    public void dispose() {
        super.dispose();
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).removeDebugContextListener((IDebugContextListener)this);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        DebugUITools.getDebugContextManager().getContextService(this.getSite().getWorkbenchWindow()).addDebugContextListener((IDebugContextListener)this);
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.insertBefore("org.eclipse.cdt.debug.ui.debuggerConsoleView.DebuggerConsoleDropDownAction", (IAction)this.fTerminateLaunchAction);
    }

    protected void createActions() {
        this.fTerminateLaunchAction = new GdbConsoleTerminateLaunchAction(this.fLaunch);
        this.fShowPreferencePageAction = new GdbConsoleShowPreferencesAction(this.getSite().getShell());
    }

    protected void contextMenuAboutToShow(IMenuManager menuManager) {
        menuManager.add((IAction)this.fTerminateLaunchAction);
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IAction)this.fShowPreferencePageAction);
    }

    protected ILaunch getCurrentLaunch() {
        IAdaptable context = DebugUITools.getDebugContext();
        if (context != null) {
            return (ILaunch)context.getAdapter(ILaunch.class);
        }
        return null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0 && this.fLaunch.equals(this.getCurrentLaunch())) {
            this.fView.display((IConsole)this.fConsole);
        }
    }
}

