/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.bpel.model.Import;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.model.proxy.MessageProxy;
import org.eclipse.bpel.model.proxy.OperationProxy;
import org.eclipse.bpel.model.proxy.PartProxy;
import org.eclipse.bpel.model.proxy.PartnerLinkTypeProxy;
import org.eclipse.bpel.model.proxy.PortTypeProxy;
import org.eclipse.bpel.model.proxy.PropertyProxy;
import org.eclipse.bpel.model.proxy.RoleProxy;
import org.eclipse.bpel.model.proxy.XSDElementDeclarationProxy;
import org.eclipse.bpel.model.proxy.XSDTypeDefinitionProxy;
import org.eclipse.bpel.model.util.ImportResolver;
import org.eclipse.bpel.model.util.ImportResolverRegistry;
import org.eclipse.bpel.model.util.WSDLUtil;
import org.eclipse.bpel.model.util.XSDComparer;
import org.eclipse.bpel.model.util.XSDUtil;
import org.eclipse.bpel.validator.XSDUtils;
import org.eclipse.bpel.validator.factory.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Fault;
import org.eclipse.wst.wsdl.Input;
import org.eclipse.wst.wsdl.Message;
import org.eclipse.wst.wsdl.Operation;
import org.eclipse.wst.wsdl.Output;
import org.eclipse.wst.wsdl.Part;
import org.eclipse.wst.wsdl.PortType;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;

public class EmfModelQuery {
    static final String CONTEXT_MSG = "The EMF context object object cannot be null";
    XSDComparer xsdComparer = new XSDComparer();

    public EmfModelQuery() {
        this.xsdComparer.setDebug(AdapterFactory.DEBUG);
    }

    public XSDComparer getXSDComparer() {
        return this.xsdComparer;
    }

    public static EObject lookupPartnerLinkType(EObject eObj, QName qname) {
        EObject top = EmfModelQuery.getRoot(eObj);
        if (top instanceof Definition) {
            return WSDLUtil.resolveBPELPartnerLinkType((Definition)((Definition)top), (QName)qname);
        }
        if (top instanceof Process) {
            return EmfModelQuery.scanImports((Process)top, qname, WSDLUtil.BPEL_PARTNER_LINK_TYPE);
        }
        return null;
    }

    public static EObject lookupPortType(EObject eObj, QName qname) {
        EObject top = EmfModelQuery.getRoot(eObj);
        if (top instanceof Definition) {
            return WSDLUtil.resolvePortType((Definition)((Definition)top), (QName)qname);
        }
        if (top instanceof Process) {
            return EmfModelQuery.scanImports((Process)top, qname, WSDLUtil.WSDL_PORT_TYPE);
        }
        return null;
    }

    public static EObject lookupXSDType(EObject eObj, QName qname) {
        EObject top = EmfModelQuery.getRoot(eObj);
        if (top instanceof Definition) {
            return WSDLUtil.resolveXSDTypeDefinition((Definition)((Definition)top), (QName)qname);
        }
        if (top instanceof XSDSchema) {
            return XSDUtil.resolveTypeDefinition((XSDSchema)((XSDSchema)top), (QName)qname);
        }
        if (top instanceof Process) {
            return EmfModelQuery.scanImports((Process)top, qname, XSDUtil.XSD_TYPE_DEFINITION);
        }
        return null;
    }

    public static EObject lookupMessage(EObject eObj, QName qname) {
        EObject top = EmfModelQuery.getRoot(eObj);
        if (top instanceof Definition) {
            return WSDLUtil.resolveMessage((Definition)((Definition)top), (QName)qname);
        }
        if (top instanceof Process) {
            return EmfModelQuery.scanImports((Process)top, qname, WSDLUtil.WSDL_MESSAGE);
        }
        return null;
    }

    public static EObject lookupXSDElement(EObject eObj, QName qname) {
        EObject top = EmfModelQuery.getRoot(eObj);
        if (top instanceof Definition) {
            return WSDLUtil.resolveXSDElementDeclaration((Definition)((Definition)top), (QName)qname);
        }
        if (top instanceof XSDSchema) {
            return XSDUtil.resolveElementDeclaration((XSDSchema)((XSDSchema)top), (QName)qname);
        }
        if (top instanceof Process) {
            return EmfModelQuery.scanImports((Process)top, qname, XSDUtil.XSD_ELEMENT_DECLARATION);
        }
        return null;
    }

    public static EObject lookupRole(EObject eObj, String name) {
        EmfModelQuery.assertTrue(eObj != null, "Context object cannot be null");
        if (eObj instanceof PartnerLink) {
            eObj = ((PartnerLink)eObj).getPartnerLinkType();
        }
        if (eObj instanceof PartnerLinkType) {
            return WSDLUtil.findRole((PartnerLinkType)((PartnerLinkType)eObj), (String)name);
        }
        return null;
    }

    public static EObject lookupOperation(EObject eObj, String name) {
        EmfModelQuery.assertTrue(eObj != null, CONTEXT_MSG);
        if (eObj instanceof PartnerLink) {
            eObj = ((PartnerLink)eObj).getPartnerLinkType();
        }
        if (eObj instanceof PartnerLinkType) {
            PartnerLinkType plt = (PartnerLinkType)eObj;
            for (Object n : plt.getRole()) {
                Role r = (Role)n;
                eObj = EmfModelQuery.lookupOperation(r, name);
                if (eObj == null) continue;
                return eObj;
            }
        }
        if (eObj instanceof Role) {
            return EmfModelQuery.lookupOperation((Role)eObj, name);
        }
        return null;
    }

    static EObject lookupOperation(Role role, String name) {
        PortType portType = (PortType)role.getPortType();
        return WSDLUtil.findOperation((PortType)portType, (String)name);
    }

    public static EObject lookupNameStep(EObject eObj, QName qname, int axis) {
        XSDSimpleTypeDefinition type;
        EmfModelQuery.assertTrue(eObj != null, CONTEXT_MSG);
        eObj = EmfModelQuery.resolveNameStepContext(eObj);
        if (eObj instanceof XSDElementDeclaration) {
            XSDElementDeclaration elm = (XSDElementDeclaration)eObj;
            eObj = elm.getType();
        }
        eObj = XSDUtils.getEnclosingTypeDefinition(eObj);
        String localName = qname.getLocalPart();
        String nsURI = qname.getNamespaceURI();
        if (eObj instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition type2 = (XSDComplexTypeDefinition)eObj;
            if (axis == 0) {
                for (XSDParticleContent item : XSDUtils.getChildElements(type2)) {
                    XSDElementDeclaration next = (XSDElementDeclaration)item;
                    if (!localName.equals(next.getName()) || !EmfModelQuery.sameNamespace(nsURI, next.getTargetNamespace())) continue;
                    return next.getType();
                }
            } else if (axis == 1) {
                for (XSDAttributeDeclaration next : XSDUtils.getChildAttributes(type2)) {
                    if (!localName.equals(next.getName()) || !EmfModelQuery.sameNamespace(nsURI, next.getTargetNamespace())) continue;
                    return next.getType();
                }
            }
        } else if (eObj instanceof XSDSimpleTypeDefinition && localName.equals((type = (XSDSimpleTypeDefinition)eObj).getName()) && EmfModelQuery.sameNamespace(nsURI, type.getTargetNamespace())) {
            return type;
        }
        return null;
    }

    static EObject resolveNameStepContext(EObject eObj) {
        Part part;
        Message msg;
        EList parts;
        if (eObj instanceof Variable) {
            Variable v = (Variable)eObj;
            if ((eObj = v.getXSDElement()) == null) {
                eObj = v.getType();
            }
            if (eObj == null) {
                eObj = v.getMessageType();
            }
        }
        if (eObj instanceof Message && (parts = (msg = (Message)eObj).getEParts()).size() == 1) {
            eObj = (Part)parts.get(0);
        }
        if (eObj instanceof Part && (eObj = (part = (Part)eObj).getElementDeclaration()) == null) {
            eObj = part.getTypeDefinition();
        }
        return eObj;
    }

    public static EObject lookupMessagePart(EObject eObj, String name) {
        EmfModelQuery.assertTrue(eObj != null, CONTEXT_MSG);
        if (eObj instanceof Variable) {
            eObj = ((Variable)eObj).getMessageType();
        }
        if (eObj instanceof Message) {
            return WSDLUtil.findPart((Message)((Message)eObj), (String)name);
        }
        if (eObj instanceof Part) {
            return eObj;
        }
        return null;
    }

    public static EObject lookupImport(EObject eObj, String name) {
        EmfModelQuery.assertTrue(eObj != null, CONTEXT_MSG);
        if (eObj instanceof Import) {
            Import imp = (Import)eObj;
            ImportResolver[] importResolverArray = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int n = importResolverArray.length;
            int n2 = 0;
            while (n2 < n) {
                ImportResolver r = importResolverArray[n2];
                EObject result = r.resolve(imp, null, null, "top.element");
                if (result != null) {
                    return result;
                }
                ++n2;
            }
        }
        return null;
    }

    public static EObject getRoot(EObject eObj) {
        EmfModelQuery.assertTrue(eObj != null, CONTEXT_MSG);
        EObject top = eObj;
        while (top != null && top.eContainer() != null) {
            top = top.eContainer();
        }
        EmfModelQuery.assertTrue(top != null, "The top object cannot be null");
        return top;
    }

    static EObject scanImports(Process process, QName qname, String refType) {
        EObject result = null;
        for (Object n : process.getImports()) {
            ImportResolver[] resolvers;
            Import imp = (Import)n;
            if (imp.getLocation() == null) continue;
            ImportResolver[] importResolverArray = resolvers = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int n2 = resolvers.length;
            int n3 = 0;
            while (n3 < n2) {
                ImportResolver r = importResolverArray[n3];
                result = r.resolve(imp, qname, null, refType);
                if (result != null) {
                    return result;
                }
                ++n3;
            }
        }
        return null;
    }

    public static List<Import> scanAllImports(Process process, QName qname, String refType) {
        ArrayList<Import> imports = new ArrayList<Import>();
        EObject result = null;
        for (Object n : process.getImports()) {
            ImportResolver[] resolvers;
            Import imp = (Import)n;
            if (imp.getLocation() == null) continue;
            ImportResolver[] importResolverArray = resolvers = ImportResolverRegistry.INSTANCE.getResolvers(imp.getImportType());
            int n2 = resolvers.length;
            int n3 = 0;
            while (n3 < n2) {
                ImportResolver r = importResolverArray[n3];
                result = r.resolve(imp, qname, null, refType);
                if (result != null) {
                    imports.add(imp);
                }
                ++n3;
            }
        }
        return imports;
    }

    public static EObject resolveProxy(Process process, EObject obj) {
        if (obj instanceof MessageProxy) {
            return EmfModelQuery.scanImports(process, ((MessageProxy)obj).getQName(), WSDLUtil.WSDL_MESSAGE);
        }
        if (obj instanceof PortTypeProxy) {
            return EmfModelQuery.scanImports(process, ((PortTypeProxy)obj).getQName(), WSDLUtil.WSDL_PORT_TYPE);
        }
        if (obj instanceof PartnerLinkTypeProxy) {
            return EmfModelQuery.scanImports(process, ((PartnerLinkTypeProxy)obj).getQName(), WSDLUtil.BPEL_PARTNER_LINK_TYPE);
        }
        if (obj instanceof RoleProxy) {
            return EmfModelQuery.scanImports(process, ((RoleProxy)obj).getQName(), WSDLUtil.BPEL_ROLE);
        }
        if (obj instanceof PropertyProxy) {
            return EmfModelQuery.scanImports(process, ((PropertyProxy)obj).getQName(), WSDLUtil.BPEL_PROPERTY);
        }
        if (obj instanceof OperationProxy) {
            QName qname = new QName(((OperationProxy)obj).getName());
            return EmfModelQuery.scanImports(process, qname, WSDLUtil.WSDL_OPERATION);
        }
        if (obj instanceof PartProxy) {
            QName qname = new QName(((PartProxy)obj).getName());
            return EmfModelQuery.scanImports(process, qname, WSDLUtil.WSDL_PART);
        }
        if (obj instanceof XSDTypeDefinitionProxy) {
            QName qname = new QName(((XSDTypeDefinitionProxy)obj).getName());
            return EmfModelQuery.scanImports(process, qname, WSDLUtil.XSD_TYPE_DEFINITION);
        }
        if (obj instanceof XSDElementDeclarationProxy) {
            QName qname = new QName(((XSDElementDeclarationProxy)obj).getName());
            return EmfModelQuery.scanImports(process, qname, WSDLUtil.XSD_ELEMENT_DECLARATION);
        }
        return obj;
    }

    static void assertTrue(boolean mustBeTrue, String msg) {
        if (!mustBeTrue) {
            throw new RuntimeException(msg);
        }
    }

    static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public boolean compatiblePartnerActivityMessages(EObject src, EObject dst) {
        EmfModelQuery.assertTrue(src != null, CONTEXT_MSG);
        EmfModelQuery.assertTrue(dst != null, CONTEXT_MSG);
        if (!AdapterFactory.DEBUG && src == dst) {
            return true;
        }
        Message srcMsg = null;
        Message dstMsg = null;
        if (src instanceof Message) {
            srcMsg = (Message)src;
        }
        if (dst instanceof Message) {
            dstMsg = (Message)dst;
        }
        if (srcMsg != null && dstMsg != null) {
            return this.compatibleType(srcMsg, dstMsg);
        }
        XSDElementDeclaration srcXSD = null;
        XSDElementDeclaration dstXSD = null;
        if (src instanceof XSDElementDeclaration) {
            srcXSD = (XSDElementDeclaration)src;
        }
        if (dst instanceof XSDElementDeclaration) {
            dstXSD = (XSDElementDeclaration)dst;
        }
        if (srcXSD != null && dstMsg != null) {
            EList parts = dstMsg.getEParts();
            if (parts.size() != 1) {
                return false;
            }
            Part part = (Part)parts.get(0);
            return this.compatibleType(srcXSD, part.getElementDeclaration());
        }
        if (dstXSD != null && srcMsg != null) {
            EList parts = srcMsg.getEParts();
            if (parts.size() != 1) {
                return false;
            }
            Part part = (Part)parts.get(0);
            return this.compatibleType(dstXSD, part.getElementDeclaration());
        }
        return false;
    }

    public static EObject lookupProperty(EObject eObj, QName qname) {
        EObject top = EmfModelQuery.getRoot(eObj);
        if (top instanceof Definition) {
            return WSDLUtil.resolveBPELProperty((Definition)((Definition)top), (QName)qname);
        }
        if (top instanceof Process) {
            return EmfModelQuery.scanImports((Process)top, qname, WSDLUtil.BPEL_PROPERTY);
        }
        return null;
    }

    public boolean compatibleType(EObject src, EObject dst) {
        EmfModelQuery.assertTrue(src != null, CONTEXT_MSG);
        EmfModelQuery.assertTrue(dst != null, CONTEXT_MSG);
        if (!AdapterFactory.DEBUG && src == dst) {
            return true;
        }
        Message srcMsg = null;
        Message dstMsg = null;
        if (src instanceof Message) {
            srcMsg = (Message)src;
        }
        if (dst instanceof Message) {
            dstMsg = (Message)dst;
        }
        if (srcMsg != null && dstMsg != null) {
            return this.compatibleType(srcMsg, dstMsg);
        }
        XSDElementDeclaration srcXSD = null;
        XSDElementDeclaration dstXSD = null;
        if (src instanceof XSDElementDeclaration) {
            srcXSD = (XSDElementDeclaration)src;
        }
        if (dst instanceof XSDElementDeclaration) {
            dstXSD = (XSDElementDeclaration)dst;
        }
        if (srcXSD != null && dstXSD != null) {
            return this.compatibleType(srcXSD, dstXSD);
        }
        XSDTypeDefinition srcType = null;
        XSDTypeDefinition dstType = null;
        if (src instanceof XSDTypeDefinition) {
            srcType = (XSDTypeDefinition)src;
        }
        if (dst instanceof XSDTypeDefinition) {
            dstType = (XSDTypeDefinition)dst;
        }
        if (srcType != null && dstType != null) {
            if (this.xsdComparer.compare(srcType, dstType)) {
                return true;
            }
            XSDComparer comp = new XSDComparer();
            XSDTypeDefinition baseType = srcType.getBaseType();
            do {
                if (!comp.compare(baseType, dstType)) continue;
                return true;
            } while ((baseType = baseType.getBaseType()) != baseType.getBaseType());
            return false;
        }
        PortType srcPort = null;
        PortType dstPort = null;
        if (src instanceof PortType) {
            srcPort = (PortType)src;
        }
        if (dst instanceof PortType) {
            dstPort = (PortType)dst;
        }
        if (srcPort != null && dstPort != null) {
            return this.compatibleType(srcPort, dstPort);
        }
        return false;
    }

    public boolean compatibleType(Message src, Message dst) {
        EmfModelQuery.assertTrue(src != null, CONTEXT_MSG);
        EmfModelQuery.assertTrue(dst != null, CONTEXT_MSG);
        if (!AdapterFactory.DEBUG && src == dst) {
            return true;
        }
        if (!src.getQName().equals(dst.getQName())) {
            return false;
        }
        if (src.eResource().getURI().equals(dst.eResource().getURI())) {
            return true;
        }
        EList parts1 = src.getEParts();
        EList parts2 = dst.getEParts();
        if (parts1.size() != parts2.size()) {
            return false;
        }
        int i = 0;
        while (i < parts1.size()) {
            Part part1 = (Part)parts1.get(i);
            Part part2 = (Part)parts2.get(i);
            if (!part1.getName().equals(part2.getName())) {
                return false;
            }
            if (!this.compatibleType(part1.getTypeDefinition(), part2.getTypeDefinition())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean compatibleType(XSDElementDeclaration src, XSDElementDeclaration dst) {
        EmfModelQuery.assertTrue(src != null, CONTEXT_MSG);
        EmfModelQuery.assertTrue(dst != null, CONTEXT_MSG);
        if (!AdapterFactory.DEBUG && src == dst) {
            return true;
        }
        return this.compatibleType(src.getTypeDefinition(), dst.getTypeDefinition());
    }

    public boolean compatibleType(XSDTypeDefinition src, XSDTypeDefinition dst) {
        EmfModelQuery.assertTrue(src != null, CONTEXT_MSG);
        EmfModelQuery.assertTrue(dst != null, CONTEXT_MSG);
        if (!AdapterFactory.DEBUG && src == dst) {
            return true;
        }
        return this.xsdComparer.compare(src, dst);
    }

    public boolean compatibleType(PortType src, PortType dst) {
        EmfModelQuery.assertTrue(src != null, CONTEXT_MSG);
        EmfModelQuery.assertTrue(dst != null, CONTEXT_MSG);
        if (!AdapterFactory.DEBUG && src == dst) {
            return true;
        }
        if (src.getQName() == null || !src.getQName().equals(dst.getQName())) {
            return false;
        }
        EList ops1 = src.getEOperations();
        EList ops2 = dst.getEOperations();
        if (ops1.size() != ops2.size()) {
            return false;
        }
        int i = 0;
        while (i < ops1.size()) {
            Operation op2;
            Operation op1 = (Operation)ops1.get(i);
            if (!this.compatibleType(op1, op2 = (Operation)ops2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean compatibleType(Operation src, Operation dst) {
        EmfModelQuery.assertTrue(src != null, CONTEXT_MSG);
        EmfModelQuery.assertTrue(dst != null, CONTEXT_MSG);
        if (!AdapterFactory.DEBUG && src == dst) {
            return true;
        }
        if (src.getName() == null || !src.getName().equals(dst.getName())) {
            return false;
        }
        if (!src.getStyle().equals(dst.getStyle())) {
            return false;
        }
        Input in1 = src.getEInput();
        Input in2 = dst.getEInput();
        if (in1 != null && in2 != null ? !this.compatibleType(in1.getEMessage(), in2.getEMessage()) : in1 == null != (in2 == null)) {
            return false;
        }
        Output out1 = src.getEOutput();
        Output out2 = dst.getEOutput();
        if (out1 != null && out2 != null ? !this.compatibleType(out1.getEMessage(), out2.getEMessage()) : out1 == null != (out2 == null)) {
            return false;
        }
        EList faults1 = src.getEFaults();
        EList faults2 = dst.getEFaults();
        if (faults1.size() != faults2.size()) {
            return false;
        }
        int i = 0;
        while (i < faults1.size()) {
            if (!this.compatibleType(((Fault)faults1.get(i)).getEMessage(), ((Fault)faults2.get(i)).getEMessage())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isSimpleType(EObject eObj) {
        EmfModelQuery.assertTrue(eObj != null, CONTEXT_MSG);
        return eObj instanceof XSDSimpleTypeDefinition;
    }

    public static EObject lookupTypeOfPart(EObject eObj, QName qname) {
        EObject obj = EmfModelQuery.lookupMessagePart(eObj, qname.getLocalPart());
        if (obj == null || !(obj instanceof Part)) {
            return null;
        }
        Part part = (Part)obj;
        if (part.getElementDeclaration() != null) {
            return part.getElementDeclaration().getTypeDefinition();
        }
        return part.getTypeDefinition();
    }

    static boolean sameNamespace(String nsURI, String nsURI2) {
        if (nsURI == null) {
            nsURI = "";
        }
        if (nsURI2 == null) {
            nsURI2 = "";
        }
        return nsURI.equals(nsURI2);
    }
}

