/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.utils;

import java.lang.reflect.Method;
import java.net.URL;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.reflect.IClassLoaderInitializer;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceManagerClassLoaderInitializer
implements IClassLoaderInitializer {
    public static final IClassLoaderInitializer INSTANCE = new ResourceManagerClassLoaderInitializer();

    private ResourceManagerClassLoaderInitializer() {
    }

    public void initialize(final ClassLoader classLoader) {
        ExecutionUtils.runIgnore((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                Class<?> managerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager");
                Class<?> providerClass = classLoader.loadClass("org.eclipse.wb.swt.ResourceManager$PluginResourceProvider");
                ResourceManagerClassLoaderInitializer.this.initialize_ResourceManager(classLoader, managerClass, providerClass);
            }
        });
    }

    public void deinitialize(ClassLoader classLoader) {
    }

    private void initialize_ResourceManager(ClassLoader classLoader, Class<?> managerClass, Class<?> providerClass) throws Exception {
        Object provider = this.createProvider(classLoader, providerClass);
        ReflectionUtils.setField(managerClass, (String)"m_designTimePluginResourceProvider", (Object)provider);
    }

    private Object createProvider(ClassLoader classLoader, Class<?> providerClass) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setSuperclass(providerClass);
        enhancer.setCallback((Callback)new MethodInterceptor(){

            public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
                if (method.getName().equals("getEntry")) {
                    String symbolicName = (String)args[0];
                    String fullPath = (String)args[1];
                    return ResourceManagerClassLoaderInitializer.this.getEntry(symbolicName, fullPath);
                }
                return proxy.invokeSuper(obj, args);
            }
        });
        return enhancer.create();
    }

    private URL getEntry(String symbolicName, String fullPath) throws Exception {
        IResource underlyingResource;
        IPluginModelBase modelBase = PluginRegistry.findModel((String)symbolicName);
        String installLocation = modelBase.getInstallLocation();
        if (!StringUtils.isEmpty((String)installLocation) && installLocation.toLowerCase().endsWith(".jar")) {
            String urlPath = "jar:file:/" + installLocation + "!/" + fullPath;
            urlPath = FilenameUtils.normalize((String)urlPath, (boolean)true);
            return new URL(urlPath);
        }
        IPluginModelBase pluginModel = PluginRegistry.findModel((String)symbolicName);
        if (pluginModel != null && (underlyingResource = pluginModel.getUnderlyingResource()) != null) {
            IProject project = underlyingResource.getProject();
            return project.getFile((IPath)new Path(fullPath)).getLocationURI().toURL();
        }
        Bundle bundle = Platform.getBundle((String)symbolicName);
        if (bundle != null) {
            return bundle.getEntry(fullPath);
        }
        return null;
    }
}

