/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMessages;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.EclipseResource;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

class EclipseFolder
extends EclipseResource
implements ICVSFolder {
    protected EclipseFolder(IContainer container) {
        super((IResource)container);
    }

    @Override
    public ICVSResource[] members(int flags) throws CVSException {
        ArrayList<ICVSResource> result = new ArrayList<ICVSResource>();
        IResource[] resources = EclipseSynchronizer.getInstance().members((IContainer)this.resource);
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        boolean includeUnmanaged = (flags & 8) != 0 || (flags & 0x1C) == 0;
        boolean includeIgnored = (flags & 4) != 0;
        boolean includeExisting = (flags & 0x20) != 0 || (flags & 0x60) == 0;
        boolean includePhantoms = (flags & 0x40) != 0 || (flags & 0x60) == 0;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            int type = resource.getType();
            if (includeFiles && type == 1 || includeFolders && type == 2) {
                boolean exists = resource.exists();
                if (includeExisting && exists || includePhantoms && !exists) {
                    ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
                    boolean includeResource = false;
                    if (includeManaged && includeUnmanaged && includeIgnored) {
                        includeResource = true;
                    } else {
                        boolean isManaged = cvsResource.isManaged();
                        if (isManaged && includeManaged) {
                            includeResource = true;
                        } else if (exists) {
                            boolean isIgnored = cvsResource.isIgnored();
                            if (isIgnored && includeIgnored) {
                                includeResource = true;
                            } else if (!isManaged && !isIgnored && includeUnmanaged) {
                                includeResource = true;
                            }
                        }
                    }
                    if (includeResource) {
                        result.add(cvsResource);
                    }
                }
            }
            ++n2;
        }
        return result.toArray(new ICVSResource[result.size()]);
    }

    @Override
    public ICVSFolder getFolder(String name) throws CVSException {
        if (".".equals(name) || "./".equals(name)) {
            return this;
        }
        Path path = new Path(null, name);
        if (this.resource.getType() == 8 && path.segmentCount() == 1) {
            return new EclipseFolder((IContainer)((IWorkspaceRoot)this.resource).getProject(name));
        }
        return new EclipseFolder((IContainer)((IContainer)this.resource).getFolder((IPath)path));
    }

    @Override
    public ICVSFile getFile(String name) throws CVSException {
        return new EclipseFile(((IContainer)this.resource).getFile((IPath)new Path(null, name)));
    }

    @Override
    public void mkdir() throws CVSException {
        ISchedulingRule rule = null;
        try {
            try {
                rule = EclipseSynchronizer.getInstance().beginBatching((ISchedulingRule)this.resource, null);
                if (this.resource.getType() == 4) {
                    IProject project = (IProject)this.resource;
                    project.create(null);
                    project.open(null);
                } else {
                    ((IFolder)this.resource).create(false, true, null);
                    EclipseSynchronizer.getInstance().created(this.getIResource());
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException(this.resource, NLS.bind((String)CVSMessages.EclipseFolder_problem_creating, (Object[])new String[]{this.resource.getFullPath().toString(), e.getStatus().getMessage()}), e);
            }
        }
        finally {
            if (rule != null) {
                EclipseSynchronizer.getInstance().endBatching(rule, null);
            }
        }
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public void acceptChildren(ICVSResourceVisitor visitor) throws CVSException {
        ICVSResource[] subFolders;
        ICVSResource[] subFiles;
        ICVSResource[] iCVSResourceArray = subFiles = this.members(1);
        int n = subFiles.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSResource subFile = iCVSResourceArray[n2];
            subFile.accept(visitor);
            ++n2;
        }
        ICVSResource[] iCVSResourceArray2 = subFolders = this.members(2);
        int n3 = subFolders.length;
        n = 0;
        while (n < n3) {
            ICVSResource subFolder = iCVSResourceArray2[n];
            subFolder.accept(visitor);
            ++n;
        }
    }

    @Override
    public void accept(ICVSResourceVisitor visitor) throws CVSException {
        visitor.visitFolder(this);
    }

    @Override
    public void accept(ICVSResourceVisitor visitor, boolean recurse) throws CVSException {
        visitor.visitFolder(this);
        ICVSResource[] resources = recurse ? this.members(127) : this.members(1);
        ICVSResource[] iCVSResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSResource r = iCVSResourceArray[n2];
            r.accept(visitor, recurse);
            ++n2;
        }
    }

    @Override
    public String getRemoteLocation(ICVSFolder stopSearching) throws CVSException {
        String parentLocation;
        if (this.getFolderSyncInfo() != null) {
            return this.getFolderSyncInfo().getRemoteLocation();
        }
        ICVSFolder parent = this.getParent();
        if (parent != null && !this.equals(stopSearching) && (parentLocation = parent.getRemoteLocation(stopSearching)) != null) {
            return String.valueOf(parentLocation) + "/" + this.getName();
        }
        return null;
    }

    @Override
    public FolderSyncInfo getFolderSyncInfo() throws CVSException {
        if (this.resource.getType() != 8 && !this.resource.getProject().isAccessible()) {
            return null;
        }
        return EclipseSynchronizer.getInstance().getFolderSync((IContainer)this.resource);
    }

    @Override
    public void setFolderSyncInfo(FolderSyncInfo folderInfo) throws CVSException {
        if (this.resource.getType() == 8) {
            return;
        }
        this.run(monitor -> {
            EclipseSynchronizer synchronizer = EclipseSynchronizer.getInstance();
            synchronizer.setFolderSync((IContainer)this.resource, folderInfo);
            byte[] newSyncBytes = new ResourceSyncInfo(this.getName()).getBytes();
            byte[] oldSyncBytes = this.getSyncBytes();
            if (oldSyncBytes == null || !Util.equals(newSyncBytes, oldSyncBytes)) {
                this.setSyncBytes(newSyncBytes);
            }
        }, null);
    }

    @Override
    public boolean isCVSFolder() throws CVSException {
        return EclipseSynchronizer.getInstance().getFolderSync((IContainer)this.resource) != null;
    }

    @Override
    public void unmanage(IProgressMonitor monitor) throws CVSException {
        this.run(monitor1 -> {
            monitor1 = Policy.monitorFor(monitor1);
            monitor1.beginTask(null, 100);
            EclipseFolder.recursiveUnmanage((IContainer)this.resource, Policy.subMonitorFor(monitor1, 99));
            EclipseFolder.super.unmanage(Policy.subMonitorFor(monitor1, 1));
            monitor1.done();
        }, Policy.subMonitorFor(monitor, 99));
    }

    static void recursiveUnmanage(IContainer container, IProgressMonitor monitor) {
        try {
            try {
                IResource[] members;
                monitor.beginTask(null, 10);
                monitor.subTask(NLS.bind((String)CVSMessages.EclipseFolder_0, (Object[])new String[]{container.getFullPath().toString()}));
                EclipseSynchronizer.getInstance().deleteFolderSync(container);
                IResource[] iResourceArray = members = container.members(true);
                int n = members.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    monitor.worked(1);
                    if (resource.getType() == 1) {
                        ResourceAttributes attrs = resource.getResourceAttributes();
                        if (attrs != null && attrs.isReadOnly()) {
                            attrs.setReadOnly(false);
                            resource.setResourceAttributes(attrs);
                        }
                    } else {
                        EclipseFolder.recursiveUnmanage((IContainer)resource, monitor);
                    }
                    ++n2;
                }
            }
            catch (CoreException coreException) {
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public boolean isIgnored() throws CVSException {
        if (this.isCVSFolder()) {
            return false;
        }
        return super.isIgnored();
    }

    @Override
    public ICVSResource getChild(String namedPath) throws CVSException {
        if (namedPath.equals(".")) {
            return this;
        }
        Path path = new Path(null, namedPath);
        if (path.segmentCount() == 0) {
            return this;
        }
        IResource child = ((IContainer)this.resource).findMember((IPath)path, true);
        if (child != null) {
            if (child.getType() == 1) {
                return new EclipseFile((IFile)child);
            }
            return new EclipseFolder((IContainer)child);
        }
        return null;
    }

    @Override
    public ICVSResource[] fetchChildren(IProgressMonitor monitor) throws CVSException {
        return this.members(3);
    }

    @Override
    public void delete() throws CVSException {
        if (!this.exists()) {
            return;
        }
        try {
            this.resource.delete(false, null);
        }
        catch (CoreException e) {
            throw new CVSException(e.getStatus());
        }
    }

    @Override
    public boolean isModified(IProgressMonitor monitor) throws CVSException {
        try {
            boolean modified;
            monitor = Policy.monitorFor(monitor);
            monitor.beginTask(NLS.bind((String)CVSMessages.EclipseFolder_isModifiedProgress, (Object[])new String[]{this.resource.getFullPath().toString()}), 1000);
            IContainer container = (IContainer)this.getIResource();
            if (RepositoryProvider.getProvider((IProject)container.getProject(), (String)CVSProviderPlugin.getTypeId()) == null) {
                return false;
            }
            int state = EclipseSynchronizer.getInstance().getModificationState(this.getIResource());
            if (state == 0) {
                if (!this.isCVSFolder() && container.getType() == 2) {
                    boolean bl = container.exists();
                    return bl;
                }
                modified = this.calculateAndSaveChildModificationStates(monitor);
                EclipseSynchronizer.getInstance().setModified(this, modified);
            } else {
                modified = state == 2;
            }
            boolean bl = modified;
            return bl;
        }
        finally {
            monitor.done();
        }
    }

    @Override
    public void handleModification(boolean forAddition) throws CVSException {
        if (this.isIgnored() || !forAddition) {
            return;
        }
        FolderSyncInfo info = this.getFolderSyncInfo();
        if (info == null) {
            EclipseSynchronizer.getInstance().setDirtyIndicator(this.getIResource(), true);
        }
    }

    private boolean calculateAndSaveChildModificationStates(IProgressMonitor monitor) throws CVSException {
        ICVSResource[] children;
        ICVSResource[] iCVSResourceArray = children = this.members(123);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ICVSResource resource = iCVSResourceArray[n2];
            if (resource.isModified(null)) {
                return true;
            }
            monitor.worked(1);
            ++n2;
        }
        return false;
    }

    @Override
    public String getRepositoryRelativePath() throws CVSException {
        FolderSyncInfo info = this.getFolderSyncInfo();
        if (info == null) {
            return null;
        }
        return info.getRepository();
    }
}

