/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.BorderedNodeFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Location;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Size;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.diagram.ContainerStyle;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.ResizeKind;
import org.eclipse.sirius.diagram.ShapeContainerStyle;
import org.eclipse.sirius.diagram.WorkspaceImage;
import org.eclipse.sirius.diagram.business.api.query.DDiagramElementQuery;
import org.eclipse.sirius.diagram.business.internal.query.DDiagramElementContainerExperimentalQuery;
import org.eclipse.sirius.diagram.ui.business.internal.query.DNodeContainerQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractBorderedDiagramElementEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.AbstractDiagramContainerEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramContainerEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.validators.ResizeValidator;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.AbstractDiagramElementContainerNameEditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.parts.DNode4EditPart;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.NonResizableAndNonDuplicableEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.edit.policies.RegionGraphicalNodeEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleAwareClippingStrategy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.GradientRoundedRectangle;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerParallelogram;
import org.eclipse.sirius.diagram.ui.tools.api.figure.ViewNodeContainerRectangleFigureDesc;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.ContainerWithTitleBlockFigure;
import org.eclipse.sirius.diagram.ui.tools.internal.figure.RegionRoundedGradientRectangle;
import org.eclipse.sirius.diagram.ui.tools.internal.util.EditPartQuery;
import org.eclipse.sirius.diagram.ui.tools.internal.util.NotificationQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.AlphaDropShadowBorder;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusDefaultSizeNodeFigure;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.SiriusWrapLabel;
import org.eclipse.sirius.ext.gmf.runtime.gef.ui.figures.ViewNodeContainerFigureDesc;
import org.eclipse.sirius.viewpoint.DStylizable;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.style.LabelBorderStyleDescription;

public abstract class AbstractDiagramElementContainerEditPart
extends AbstractBorderedDiagramElementEditPart
implements IAbstractDiagramNodeEditPart {
    public static final int DEFAULT_SPACING = 5;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    private IFigure backgroundFigure;
    private Dimension intialDefaultSize;
    private boolean useOverlayLabel;

    public AbstractDiagramElementContainerEditPart(View view) {
        super(view);
    }

    protected void handleNotificationEvent(Notification notification) {
        EditPart regionContainer;
        Set<EditPart> partToRefresh1 = DiagramElementEditPartOperation.handleNotificationEvent(this, notification, false);
        for (EditPart editPart : partToRefresh1) {
            this.refreshEditPart(notification, editPart);
        }
        super.handleNotificationEvent(notification);
        Set<EditPart> partToRefresh2 = AbstractDiagramNodeEditPartOperation.handleNotificationEvent(this, notification, false);
        if (this.isRegion() && this.isChangeDiagramElementLabelNotification(notification)) {
            partToRefresh2.addAll(this.getBrotherRegionParts());
        }
        partToRefresh2.removeAll(partToRefresh1);
        for (EditPart editPart : partToRefresh2) {
            this.refreshEditPart(notification, editPart);
        }
        this.handleDefaultSizeNotification(notification);
        if (NotationPackage.eINSTANCE.getDrawerStyle_Collapsed() == notification.getFeature()) {
            this.refreshBounds();
        }
        if (this.isRegion() && this.getParent() != null && new NotificationQuery(notification).isNotationLayoutChange() && (regionContainer = this.getParent().getParent()) instanceof AbstractDiagramContainerEditPart && this.shouldRefreshRegionContainerBounds(regionContainer)) {
            ((AbstractDiagramContainerEditPart)regionContainer).refreshBounds();
        }
    }

    private boolean isChangeDiagramElementLabelNotification(Notification notification) {
        return notification.getNotifier() instanceof DDiagramElement && notification.getFeature().equals(ViewpointPackage.eINSTANCE.getDRepresentationElement_Name());
    }

    private List<AbstractDiagramElementContainerEditPart> getBrotherRegionParts() {
        AbstractDiagramElementContainerEditPart editPart = this;
        List<AbstractDiagramElementContainerEditPart> regionParts = this.getParent().getChildren().stream().filter(arg_0 -> AbstractDiagramElementContainerEditPart.lambda$0((EditPart)editPart, arg_0)).map(AbstractDiagramElementContainerEditPart.class::cast).collect(Collectors.toList());
        return regionParts;
    }

    private void refreshEditPart(Notification notification, EditPart editPart) {
        if (editPart instanceof AbstractDiagramElementContainerEditPart && notification.getEventType() == 3) {
            AbstractDiagramElementContainerEditPart containerEditPart = (AbstractDiagramElementContainerEditPart)editPart;
            if (!containerEditPart.getModelChildren().contains(notification.getNewValue())) {
                editPart.refresh();
            }
        } else {
            editPart.refresh();
        }
    }

    private boolean shouldRefreshRegionContainerBounds(EditPart regionContainer) {
        Object view = regionContainer.getModel();
        if (view instanceof Node) {
            LayoutConstraint lc = ((Node)view).getLayoutConstraint();
            return lc instanceof Size && (((Size)lc).getHeight() == -1 || ((Size)lc).getWidth() == -1);
        }
        return false;
    }

    private void handleDefaultSizeNotification(Notification notification) {
        if (!notification.isTouch()) {
            IFigure figure;
            Object feature = notification.getFeature();
            if ((DiagramPackage.eINSTANCE.getDDiagramElementContainer_Width().equals(feature) || DiagramPackage.eINSTANCE.getDDiagramElementContainer_Height().equals(feature)) && (figure = this.getMainFigure()) instanceof DefaultSizeNodeFigure && !this.isRegion()) {
                this.setFigureDefaultSize((DefaultSizeNodeFigure)figure);
            }
        }
    }

    @Override
    public SiriusWrapLabel getNodeLabel() {
        SiriusWrapLabel nodeLabel = null;
        if (this.primaryShape instanceof ViewNodeContainerFigureDesc) {
            nodeLabel = ((ViewNodeContainerFigureDesc)this.primaryShape).getLabelFigure();
        }
        return nodeLabel;
    }

    @Override
    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        AbstractDiagramNodeEditPartOperation.createDefaultEditPolicies(this);
        if (this.isRegion()) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new RegionGraphicalNodeEditPolicy());
        }
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getBackgroundFigure() {
        return this.backgroundFigure;
    }

    public void createBackgroundFigure() {
        this.backgroundFigure = DiagramContainerEditPartOperation.createBackgroundFigure(this);
    }

    public void refresh() {
        super.refresh();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            editPart.refresh();
            ++i;
        }
    }

    protected NodeFigure createMainFigure() {
        NodeFigure figure = this.createNodePlate();
        if (figure instanceof DefaultSizeNodeFigure) {
            this.setFigureDefaultSize((DefaultSizeNodeFigure)figure);
        }
        figure.setLayoutManager((LayoutManager)new StackLayout());
        this.createBackgroundFigure();
        if (this.getBackgroundFigure() != null) {
            figure.add(this.getBackgroundFigure());
        }
        this.primaryShape = this.createNodeShape();
        this.addDropShadow(figure, this.primaryShape);
        this.configureBorder(this.primaryShape);
        figure.add(this.primaryShape);
        this.contentPane = this.setupContentPane(this.primaryShape);
        return figure;
    }

    private void setFigureDefaultSize(DefaultSizeNodeFigure figure) {
        EObject element;
        Object model;
        if (this.intialDefaultSize == null) {
            this.intialDefaultSize = figure.getDefaultSize().getCopy();
        }
        if ((model = this.getModel()) instanceof Node && (element = ((Node)model).getElement()) instanceof DDiagramElementContainer) {
            Integer dDiagramElementContainerWidth = ((DDiagramElementContainer)element).getWidth();
            Integer dDiagramElementContainerHeight = ((DDiagramElementContainer)element).getHeight();
            int widthToApplied = this.intialDefaultSize.width;
            int heightToApplied = this.intialDefaultSize.height;
            if (dDiagramElementContainerWidth != null && dDiagramElementContainerWidth > 0) {
                int tempWidthToApplied;
                widthToApplied = tempWidthToApplied = dDiagramElementContainerWidth * 10;
            }
            if (dDiagramElementContainerHeight != null && dDiagramElementContainerHeight > 0) {
                int tempHeightToApplied;
                heightToApplied = tempHeightToApplied = dDiagramElementContainerHeight * 10;
            }
            DefaultSizeNodeFigure dsnf = figure;
            Dimension d = new Dimension(widthToApplied, heightToApplied);
            dsnf.setDefaultSize(d);
        }
    }

    protected void configureBorder(IFigure shapeFigure) {
        DiagramContainerEditPartOperation.configureBorder(this, shapeFigure);
    }

    public int getParentStackDirection() {
        int direction = 0;
        DDiagramElement dde = this.resolveDiagramElement();
        if (dde instanceof DDiagramElementContainer) {
            DDiagramElementContainerExperimentalQuery query = new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)dde);
            if (query.isRegionInVerticalStack()) {
                direction = 5;
            } else if (query.isRegionInHorizontalStack()) {
                direction = 24;
            }
        }
        return direction;
    }

    public boolean isRegion() {
        DDiagramElement ddiagramElement = this.resolveDiagramElement();
        if (ddiagramElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)ddiagramElement;
            return new DDiagramElementContainerExperimentalQuery(ddec).isRegion();
        }
        return false;
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        DiagramContainerEditPartOperation.refreshVisuals(this);
    }

    protected void refreshForegroundColor() {
        super.refreshForegroundColor();
        DiagramContainerEditPartOperation.refreshForegroundColor(this);
    }

    protected void refreshBackgroundColor() {
        super.refreshBackgroundColor();
        DiagramContainerEditPartOperation.refreshBackgroundColor(this);
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramContainerEditPartOperation.refreshFont(this);
    }

    protected void refreshBounds() {
        if (this.isRegion()) {
            Dimension defaultSize = this.getDefaultDimension(this.resolveDiagramElement()).getCopy();
            IFigure mainFigure = ((BorderedNodeFigure)this.getFigure()).getMainFigure();
            if (mainFigure instanceof DefaultSizeNodeFigure) {
                ((DefaultSizeNodeFigure)mainFigure).setDefaultSize(this.getMapMode().DPtoLP(defaultSize.width), this.getMapMode().DPtoLP(defaultSize.height));
            }
        }
        super.refreshBounds();
    }

    private Dimension getDefaultDimension(DDiagramElement dde) {
        Dimension defaultSize = LayoutUtils.NEW_DEFAULT_CONTAINER_DIMENSION;
        if (dde instanceof DNodeContainer) {
            defaultSize = new DNodeContainerQuery((DNodeContainer)dde).getDefaultDimension();
        }
        if (new EditPartQuery(this).isCollapsed() && this.getParentStackDirection() == 5) {
            defaultSize = defaultSize.getCopy().setHeight(28);
        }
        return defaultSize;
    }

    protected NodeFigure createNodePlate() {
        DDiagramElement dde = this.resolveDiagramElement();
        Dimension defaultSize = this.getDefaultDimension(dde);
        Option<LabelBorderStyleDescription> getLabelBorderStyle = this.getLabelBorderStyle((DStylizable)dde);
        SiriusDefaultSizeNodeFigure result = getLabelBorderStyle.some() ? new ContainerWithTitleBlockFigure(this.getMapMode().DPtoLP(defaultSize.width), this.getMapMode().DPtoLP(defaultSize.height), (DStylizable)dde, (LabelBorderStyleDescription)getLabelBorderStyle.get()) : new SiriusDefaultSizeNodeFigure(this.getMapMode().DPtoLP(defaultSize.width), this.getMapMode().DPtoLP(defaultSize.height));
        return result;
    }

    private Option<LabelBorderStyleDescription> getLabelBorderStyle(DStylizable viewNode) {
        if (viewNode instanceof DDiagramElementContainer) {
            return new DDiagramElementContainerExperimentalQuery((DDiagramElementContainer)viewNode).getLabelBorderStyle();
        }
        return Options.newNone();
    }

    protected IFigure createNodeShape() {
        DDiagramElement diagramElement = this.resolveDiagramElement();
        ViewNodeContainerFigureDesc shapeFigure = null;
        if (diagramElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer container = (DDiagramElementContainer)diagramElement;
            ContainerStyle ownedStyle = container.getOwnedStyle();
            if (ownedStyle instanceof ShapeContainerStyle) {
                shapeFigure = new ViewNodeContainerParallelogram((View)this.getModel());
            } else if (ownedStyle instanceof WorkspaceImage) {
                shapeFigure = new ViewNodeContainerRectangleFigureDesc((View)this.getModel());
            }
        } else {
            this.deactivate();
        }
        if (shapeFigure == null) {
            shapeFigure = this.isRegion() ? new RegionRoundedGradientRectangle(DiagramContainerEditPartOperation.getCornerDimension(this), DiagramContainerEditPartOperation.getBackgroundStyle(this), (View)this.getModel(), this.useOverlayLabel()) : new GradientRoundedRectangle(DiagramContainerEditPartOperation.getCornerDimension(this), DiagramContainerEditPartOperation.getBackgroundStyle(this).getValue(), (View)this.getModel(), this.useOverlayLabel());
        }
        if (diagramElement != null) {
            shapeFigure.getLabelFigure().setVisible(!new DDiagramElementQuery(diagramElement).isLabelHidden());
        }
        return shapeFigure;
    }

    protected NodeFigure createNodeFigure() {
        BorderedNodeFigure nodeFigure = new BorderedNodeFigure((IFigure)this.createMainFigure()){

            public void paint(Graphics graphics) {
                ShowingViewUtil.initGraphicsForVisibleAndInvisibleElements((IFigure)this, graphics, (View)AbstractDiagramElementContainerEditPart.this.getModel());
                try {
                    super.paint(graphics);
                    graphics.restoreState();
                }
                finally {
                    graphics.popState();
                }
            }
        };
        nodeFigure.getBorderItemContainer().add((IFigure)new FoldingToggleImageFigure(this));
        nodeFigure.getBorderItemContainer().setClippingStrategy((IClippingStrategy)new FoldingToggleAwareClippingStrategy());
        return nodeFigure;
    }

    protected void addDropShadow(NodeFigure figure, IFigure shape) {
        if (this.isShadowBorderNeeded()) {
            AlphaDropShadowBorder shadowBorder = new AlphaDropShadowBorder(shape);
            figure.setBorder((Border)shadowBorder);
        }
    }

    public boolean isShadowBorderNeeded() {
        boolean needShadowBorder = true;
        DDiagramElement ddiagramElement = this.resolveDiagramElement();
        if (ddiagramElement instanceof DDiagramElementContainer) {
            DDiagramElementContainer ddec = (DDiagramElementContainer)ddiagramElement;
            needShadowBorder = !new DDiagramElementContainerExperimentalQuery(ddec).isRegion() && !(ddec.getOwnedStyle() instanceof WorkspaceImage);
        }
        return needShadowBorder;
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("sourceConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("sourceConnectionAnchorLocation");
                return this.getNodeFigure().getSourceConnectionAnchorAt(realLocation);
            }
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("targetConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("targetConnectionAnchorLocation");
                return this.getNodeFigure().getTargetConnectionAnchorAt(realLocation);
            }
        }
        return super.getTargetConnectionAnchor(request);
    }

    public void setLayoutConstraint(EditPart child, IFigure childFigure, Object constraint) {
        IFigure pane = this.getContentPaneFor((IGraphicalEditPart)child);
        if (childFigure.getParent() != pane) {
            return;
        }
        super.setLayoutConstraint(child, childFigure, constraint);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        boolean removed = false;
        if (childEditPart instanceof AbstractDiagramElementContainerNameEditPart) {
            SiriusWrapLabel labelFigure = this.getPrimaryShape().getLabelFigure();
            labelFigure.setVisible(false);
            removed = true;
        } else if (childEditPart instanceof DNode4EditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((DNode4EditPart)childEditPart).getFigure());
            removed = true;
        }
        return removed;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        boolean added = false;
        if (childEditPart instanceof AbstractDiagramElementContainerNameEditPart) {
            SiriusWrapLabel labelFigure = this.getPrimaryShape().getLabelFigure();
            labelFigure.setVisible(true);
            ((AbstractDiagramElementContainerNameEditPart)childEditPart).setLabel(labelFigure);
            added = true;
        } else if (childEditPart instanceof DNode4EditPart && ((DNode4EditPart)childEditPart).resolveSemanticElement() instanceof DDiagramElement) {
            IBorderItemLocator locator = this.createBorderItemLocator(this.getMainFigure(), (DDiagramElement)((DNode4EditPart)childEditPart).resolveSemanticElement());
            Point parentOrigin = this.getBorderedFigure().getHandleBounds().getTopLeft().getCopy();
            Point negateParentOrigin = parentOrigin.getNegated();
            Rectangle constraint = ((DNode4EditPart)childEditPart).getFigure().getBounds().getCopy();
            Point newTopLeft = constraint.getTopLeft().getCopy().translate(negateParentOrigin);
            locator.setConstraint(new Rectangle(newTopLeft.x, newTopLeft.y, constraint.width, constraint.height));
            this.getBorderedFigure().getBorderItemContainer().add(((DNode4EditPart)childEditPart).getFigure(), (Object)locator);
            added = true;
        }
        return added;
    }

    public void forceFigureAutosize() {
        Dimension size = new Dimension(-1, -1);
        int x = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)this.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        Point loc = new Point(x, y);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(loc, size));
    }

    public Rectangle getAutosizedDimensions() {
        ((GraphicalEditPart)this.getParent()).getFigure().validate();
        return this.getFigure().getBounds();
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.sirius.diagram.ui.tools.api.policies.LayoutEditPolicy lep = new org.eclipse.sirius.diagram.ui.tools.api.policies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                if (child instanceof AbstractBorderItemEditPart) {
                    return ((AbstractBorderItemEditPart)child).getPrimaryDragEditPolicy();
                }
                Object result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableAndNonDuplicableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }

            public Command getCommand(Request request) {
                Command command;
                if ("resize children".equals(request.getType()) && request instanceof ChangeBoundsRequest && (command = AbstractDiagramElementContainerEditPart.this.getResizeBorderItemCommand((ChangeBoundsRequest)request)) != null) {
                    return command;
                }
                return super.getCommand(request);
            }
        };
        return lep;
    }

    protected Command getResizeBorderItemCommand(ChangeBoundsRequest request) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        boolean valid = true;
        ResizeValidator resizeValidator = new ResizeValidator(request);
        valid = resizeValidator.validate();
        if (valid) {
            for (Object next : request.getEditParts()) {
                DNode viewNode;
                boolean collapsed;
                IGraphicalEditPart graphicalEditPart;
                EObject semantic;
                if (!(next instanceof IGraphicalEditPart) || !((semantic = (graphicalEditPart = (IGraphicalEditPart)next).resolveSemanticElement()) instanceof DNode)) continue;
                Dimension dimension = new Dimension();
                Point position = new Point();
                if (graphicalEditPart.getNotationView() instanceof Node && ((Node)graphicalEditPart.getNotationView()).getLayoutConstraint() instanceof Size) {
                    Size size = (Size)((Node)graphicalEditPart.getNotationView()).getLayoutConstraint();
                    dimension.width = size.getWidth();
                    dimension.height = size.getHeight();
                }
                if (graphicalEditPart.getNotationView() instanceof Node && ((Node)graphicalEditPart.getNotationView()).getLayoutConstraint() instanceof Location) {
                    Location location = (Location)((Node)graphicalEditPart.getNotationView()).getLayoutConstraint();
                    position.x = location.getX();
                    position.y = location.getY();
                }
                if (!((collapsed = new DDiagramElementQuery((DDiagramElement)(viewNode = (DNode)semantic)).isIndirectlyCollapsed()) || viewNode.getResizeKind() != ResizeKind.NSEW_LITERAL && viewNode.getResizeKind() != ResizeKind.NORTH_SOUTH_LITERAL)) {
                    dimension.height = (int)((double)dimension.height + (double)request.getSizeDelta().height / this.getZoomManager().getZoom());
                    switch (request.getResizeDirection()) {
                        case 1: 
                        case 9: 
                        case 17: {
                            position.y = (int)((double)position.y - (double)request.getSizeDelta().height / this.getZoomManager().getZoom());
                            break;
                        }
                    }
                }
                if (!(collapsed || viewNode.getResizeKind() != ResizeKind.NSEW_LITERAL && viewNode.getResizeKind() != ResizeKind.EAST_WEST_LITERAL)) {
                    dimension.width = (int)((double)dimension.width + (double)request.getSizeDelta().width / this.getZoomManager().getZoom());
                    switch (request.getResizeDirection()) {
                        case 8: 
                        case 9: 
                        case 12: {
                            position.x = (int)((double)position.x - (double)request.getSizeDelta().width / this.getZoomManager().getZoom());
                            break;
                        }
                    }
                }
                SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), Messages.IAbstractDiagramNodeEditPart_resizeCommandLabel, (IAdaptable)new EObjectAdapter((EObject)graphicalEditPart.getNotationView()), new Rectangle(position, dimension));
                cmd = new ICommandProxy((ICommand)setBoundsCommand);
            }
        }
        return cmd;
    }

    public ViewNodeContainerFigureDesc getPrimaryShape() {
        if (this.primaryShape instanceof ViewNodeContainerFigureDesc) {
            return (ViewNodeContainerFigureDesc)this.primaryShape;
        }
        return null;
    }

    public void reInitFigure() {
        IFigure mainFigure = ((BorderedNodeFigure)this.getFigure()).getMainFigure();
        ArrayList prevChildren = new ArrayList(mainFigure.getChildren());
        ShapeCompartmentFigure containerCompartment = null;
        ResizableCompartmentFigure listCompartment = null;
        SiriusWrapLabel wrapLabel = null;
        NodeFigure tmpFigure = this.createMainFigure();
        for (IFigure object : prevChildren) {
            if (object instanceof ShapeCompartmentFigure) {
                containerCompartment = (ShapeCompartmentFigure)object;
            } else if (object instanceof ViewNodeContainerFigureDesc) {
                for (Object object2 : ((ViewNodeContainerFigureDesc)object).getChildren()) {
                    if (object2 instanceof SiriusWrapLabel) {
                        wrapLabel = (SiriusWrapLabel)object2;
                        continue;
                    }
                    if (!(object2 instanceof ResizableCompartmentFigure)) continue;
                    listCompartment = (ResizableCompartmentFigure)object2;
                }
            }
            mainFigure.remove(object);
        }
        Object[] tmpChildren = tmpFigure.getChildren().toArray();
        int i = 0;
        while (i < tmpChildren.length) {
            if (tmpChildren[i] instanceof ViewNodeContainerFigureDesc) {
                ViewNodeContainerFigureDesc figure = (ViewNodeContainerFigureDesc)tmpChildren[i];
                if (wrapLabel != null) {
                    for (IFigure child : new ArrayList(figure.getChildren())) {
                        if (!(child instanceof SiriusWrapLabel)) continue;
                        figure.remove(child);
                    }
                    figure.add((IFigure)wrapLabel);
                }
                if (listCompartment != null) {
                    figure.add(listCompartment);
                }
            }
            mainFigure.add((IFigure)tmpChildren[i], i);
            ++i;
        }
        if (containerCompartment != null) {
            mainFigure.add((IFigure)containerCompartment);
        }
        mainFigure.setBorder(tmpFigure.getBorder());
    }

    protected boolean useOverlayLabel() {
        return this.useOverlayLabel;
    }

    protected void setUseOverlayLabel(boolean useOverlayLabel) {
        this.useOverlayLabel = useOverlayLabel;
    }

    private static /* synthetic */ boolean lambda$0(EditPart editPart, Object ed) {
        return ed instanceof AbstractDiagramElementContainerEditPart && !ed.equals(editPart);
    }
}

