/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.impl.expandbar;

import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.wait.AbstractWait;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.core.handler.ExpandItemHandler;
import org.eclipse.reddeer.swt.api.Control;
import org.eclipse.reddeer.swt.api.ExpandBar;
import org.eclipse.reddeer.swt.api.ExpandItem;
import org.eclipse.reddeer.swt.impl.expandbar.DefaultExpandBar;
import org.eclipse.reddeer.swt.widgets.AbstractItem;

public abstract class AbstractExpandItem
extends AbstractItem<org.eclipse.swt.widgets.ExpandItem>
implements ExpandItem {
    private static final Logger logger = Logger.getLogger(AbstractExpandItem.class);

    protected AbstractExpandItem(org.eclipse.swt.widgets.ExpandItem swtExpandItem) {
        super(swtExpandItem);
    }

    public String getToolTipText() {
        return ExpandItemHandler.getInstance().getToolTipText((org.eclipse.swt.widgets.ExpandItem)this.swtWidget);
    }

    @Override
    public void expand() {
        this.expand(TimePeriod.SHORT);
    }

    @Override
    public void expand(TimePeriod timePeriod) {
        logger.debug("Expand Expand Bar Item " + this.getText());
        if (!this.isExpanded()) {
            ExpandItemHandler.getInstance().expand((org.eclipse.swt.widgets.ExpandItem)this.getSWTWidget(), (org.eclipse.swt.widgets.ExpandBar)this.getParent().getSWTWidget());
            AbstractWait.sleep((TimePeriod)timePeriod);
            logger.info("Expand Bar Item " + this.getText() + " has been expanded");
        } else {
            logger.debug("Expand Bar Item " + this.getText() + " is already expanded. No action performed");
        }
    }

    @Override
    public void collapse() {
        logger.debug("Collapse Expand Bar Item " + this.getText());
        if (this.isExpanded()) {
            ExpandItemHandler.getInstance().collapse((org.eclipse.swt.widgets.ExpandItem)this.getSWTWidget(), (org.eclipse.swt.widgets.ExpandBar)this.getParent().getSWTWidget());
            logger.info("Expand Bar Item " + this.getText() + " has been collapsed");
        } else {
            logger.debug("Expand Bar Item " + this.getText() + " is already collapsed. No action performed");
        }
    }

    public org.eclipse.swt.widgets.Control getControl() {
        return ((org.eclipse.swt.widgets.ExpandItem)this.swtWidget).getControl();
    }

    @Override
    public ExpandBar getParent() {
        return new DefaultExpandBar(ExpandItemHandler.getInstance().getParent((org.eclipse.swt.widgets.ExpandItem)this.swtWidget));
    }

    @Override
    public Control<?> getParentControl() {
        return this.getParent();
    }

    @Override
    public boolean isExpanded() {
        return ExpandItemHandler.getInstance().isExpanded((org.eclipse.swt.widgets.ExpandItem)this.getSWTWidget());
    }
}

