/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.ui.editor;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public final class IDocumentCharSequence
implements CharSequence {
    private final IDocument document;
    private final int start;
    private final int end;

    public IDocumentCharSequence(IDocument document) {
        this(document, 0, document.getLength());
    }

    public IDocumentCharSequence(IDocument document, int start, int end) {
        this.document = document;
        this.start = start;
        this.end = end;
    }

    @Override
    public char charAt(int i) {
        try {
            return this.document.getChar(this.start + i);
        }
        catch (BadLocationException e) {
            throw new Error(e);
        }
    }

    @Override
    public int length() {
        return this.end - this.start;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new IDocumentCharSequence(this.document, start, end);
    }
}

