/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.analysis.dependence;

import java.util.ArrayList;
import java.util.List;

public final class Matrix {
    private ArrayList<double[]> rows;
    private int numColumns;

    public Matrix() {
        this.rows = new ArrayList();
        this.setNumColumns(0);
    }

    public Matrix(List<double[]> rowsIn) {
        this.setRows(rowsIn);
        this.setNumColumns(this.getSingleRow(0).length);
    }

    public Matrix cloneMatrix() {
        Matrix m = new Matrix();
        m.setRows(this.rows);
        m.setNumColumns(this.numColumns);
        return m;
    }

    public Matrix(List<double[]> rowsIn, int numColumns) {
        this.setRows(rowsIn);
        this.setNumColumns(numColumns);
    }

    public Matrix(Matrix aMatrix) {
        this(aMatrix.getRows(), aMatrix.getNumColumns());
    }

    public void setRows(List<double[]> rowsIn) {
        this.rows = new ArrayList();
        int i = 0;
        while (i < rowsIn.size()) {
            this.rows.add((double[])rowsIn.get(i).clone());
            ++i;
        }
        this.setNumColumns(this.rows.get(0).length);
        this.trimRowsToSize();
    }

    public void trimRowsToSize() {
        this.rows.trimToSize();
    }

    public void setSingleRow(int rowIndex, double[] rowIn) throws IndexOutOfBoundsException {
        if (this.rows.isEmpty()) {
            this.setNumColumns(rowIn.length);
            this.addRowAtIndex(0, rowIn);
        }
        if (rowIn.length != this.numColumns || rowIndex < 0 || rowIndex >= this.getNumRows()) {
            throw new IndexOutOfBoundsException("setSingleRow - index out of bounds");
        }
        this.rows.set(rowIndex, (double[])rowIn.clone());
    }

    public void setNumColumns(int numOfCol) {
        if (numOfCol < 0) {
            throw new IndexOutOfBoundsException("setNumColumns - numOfCol must be greater than 0");
        }
        this.numColumns = numOfCol;
    }

    public List<double[]> getRows() {
        return this.rows;
    }

    public double[] getSingleRow(int rowIndex) throws IndexOutOfBoundsException {
        if (rowIndex < 0 || rowIndex >= this.getNumRows()) {
            throw new IndexOutOfBoundsException("getSingleRow - index out of bounds");
        }
        return this.rows.get(rowIndex);
    }

    public int getNumColumns() {
        return this.numColumns;
    }

    public int getNumRows() {
        return this.rows.size();
    }

    public double getValueAtMatrixIndex(int rowIndex, int colIndex) throws IndexOutOfBoundsException {
        if (rowIndex < 0 || rowIndex >= this.getNumRows() || colIndex < 0 || colIndex >= this.getNumColumns()) {
            throw new IndexOutOfBoundsException("getValueAtMatrixIndex - index out of bounds");
        }
        return this.getSingleRow(rowIndex)[colIndex];
    }

    public void addRowAtIndex(int index, double[] rowIn) throws IllegalArgumentException {
        if (this.rows.isEmpty()) {
            this.setNumColumns(rowIn.length);
        }
        if (rowIn.length != this.numColumns || index < 0 || index > this.getNumRows() + 1) {
            throw new IllegalArgumentException("addRowAtIndex - invalid column or index number");
        }
        this.rows.add(index, (double[])rowIn.clone());
    }

    public boolean deleteRow(int rowIndex) throws IndexOutOfBoundsException {
        if (rowIndex < 0 || rowIndex >= this.getNumRows()) {
            throw new IndexOutOfBoundsException("deleteRow - index out of bounds");
        }
        this.rows.remove(rowIndex);
        return true;
    }

    public void divideRowByColIndex(int rowIndex, int colIndex) {
        double value = Math.abs(this.getValueAtMatrixIndex(rowIndex, colIndex));
        if (value == 0.0) {
            return;
        }
        int i = 0;
        while (i < this.getSingleRow(rowIndex).length) {
            this.getSingleRow((int)rowIndex)[i] = this.getSingleRow(rowIndex)[i] / value;
            ++i;
        }
    }

    public double[] addTwoRowsToCreateNewRow(double[] firstRow, double[] secondRow) throws IndexOutOfBoundsException {
        if (firstRow.length != secondRow.length) {
            throw new IndexOutOfBoundsException("addTwoRowsToCreateNewRow - invalid rows");
        }
        double[] newRow = new double[firstRow.length];
        int i = 0;
        while (i < firstRow.length) {
            newRow[i] = firstRow[i] + secondRow[i];
            ++i;
        }
        return newRow;
    }

    public boolean isRowFullOfZeroes(double[] row) {
        boolean isAllZeroes = true;
        int j = 0;
        while (j < this.getNumColumns()) {
            if (row[j] != 0.0) {
                return false;
            }
            ++j;
        }
        return isAllZeroes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        int numRow = 0;
        while (numRow < this.getNumRows()) {
            int numCol = 0;
            while (numCol < this.getNumColumns()) {
                if (numCol == this.getNumColumns() - 2) {
                    builder.append(String.valueOf(this.getValueAtMatrixIndex(numRow, numCol)) + " | ");
                } else {
                    builder.append(String.valueOf(this.getValueAtMatrixIndex(numRow, numCol)) + " ");
                }
                ++numCol;
            }
            builder.append("\n");
            ++numRow;
        }
        return builder.toString();
    }
}

