/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.hc.remote.impl;

import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.Map;
import java.util.Objects;
import org.eclipse.passage.lic.internal.hc.remote.Configuration;

final class HttpUrlConnectionConfiguration
implements Configuration<HttpURLConnection> {
    private final int timeout;
    private final Map<String, String> properties;

    public HttpUrlConnectionConfiguration(int timeout, Map<String, String> properties) {
        Objects.requireNonNull(properties, "HttpUrlConnectionConfiguration::properties");
        this.timeout = timeout;
        this.properties = properties;
    }

    @Override
    public HttpURLConnection apply(HttpURLConnection connection) throws ProtocolException {
        this.installRequestDemands(connection);
        this.installRequestProperties(connection);
        return connection;
    }

    private void installRequestDemands(HttpURLConnection connection) throws ProtocolException {
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(this.timeout);
        connection.setDoOutput(true);
    }

    private void installRequestProperties(HttpURLConnection connection) {
        this.properties.forEach((k, v) -> connection.addRequestProperty((String)k, (String)v));
    }
}

