/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.tools.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.infra.tools.Activator;
import org.osgi.framework.Bundle;

public class ClassLoaderHelper {
    private static final Map<String, Class<?>> classes = new HashMap();

    public static Class<?> loadClass(String className, URI context) {
        if (classes.containsKey(className)) {
            return classes.get(className);
        }
        return ClassLoaderHelper.loadClass(className, ClassLoaderHelper.getPluginId(context));
    }

    public static Class<?> loadClass(String className, String bundleId) {
        if (classes.containsKey(className)) {
            return classes.get(className);
        }
        Bundle bundle = Platform.getBundle((String)bundleId);
        return bundle == null ? ClassLoaderHelper.loadClass(className) : ClassLoaderHelper.loadClass(className, bundle);
    }

    public static Class<?> loadClass(String className) {
        try {
            Class result = classes.get(className);
            if (result == null) {
                result = Activator.getDefault().getBundle().loadClass(className);
                classes.put(className, result);
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            Activator.log.error(String.format("The class %s doesn't exist", className), (Throwable)ex);
        }
        catch (NullPointerException ex) {
            Activator.log.error("Cannot load class " + className, (Throwable)ex);
        }
        return null;
    }

    public static Class<?> loadClass(String className, Bundle bundle) {
        try {
            Class result = classes.get(className);
            if (result == null) {
                result = bundle.loadClass(className);
                classes.put(className, result);
            }
            return result;
        }
        catch (ClassNotFoundException ex) {
            Activator.log.error(String.format("The class %s doesn't exist", className), (Throwable)ex);
            return ClassLoaderHelper.loadClass(className);
        }
        catch (NullPointerException ex) {
            Activator.log.error("Cannot load class " + className, (Throwable)ex);
            return null;
        }
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> asSubClass, URI context) {
        return ClassLoaderHelper.loadClass(className, asSubClass, ClassLoaderHelper.getPluginId(context));
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> asSubClass, String bundleId) {
        Class<?> clazz = classes.get(className);
        if (clazz != null) {
            return clazz.asSubclass(asSubClass);
        }
        return ClassLoaderHelper.loadClass(className, asSubClass, bundleId == null ? null : Platform.getBundle((String)bundleId));
    }

    public static <T> Class<? extends T> loadClass(String className, Class<T> asSubClass, Bundle bundle) {
        Class<?> theClass;
        if (bundle == null) {
            Activator.log.warn("Using ClassLoaderHelper#loadClass without an appropriate context. This may degrade performances (Class: " + className + ")");
            bundle = Activator.getDefault().getBundle();
        }
        if ((theClass = ClassLoaderHelper.loadClass(className, bundle)) == null) {
            return null;
        }
        try {
            Class<T> typedClass = theClass.asSubclass(asSubClass);
            return typedClass;
        }
        catch (ClassCastException ex) {
            Activator.log.error(String.format("The class %1$s doesn't extend or implement %2$s", className, asSubClass.getName()), (Throwable)ex);
            return null;
        }
    }

    @Deprecated
    public static <T> Class<? extends T> loadClass(String className, Class<T> asSubClass) {
        if (!classes.containsKey(className)) {
            Activator.log.warn("Using ClassLoaderHelper#loadClass without an appropriate context. This may degrade performances (Class: " + className + ")");
        }
        return ClassLoaderHelper.loadClass(className, asSubClass, Activator.getDefault().getBundle());
    }

    public static <T> T newInstance(String className, Class<T> asSubclass, URI context) {
        Class<T> typedClass = ClassLoaderHelper.loadClass(className, asSubclass, context);
        if (typedClass == null) {
            return null;
        }
        return ClassLoaderHelper.newInstance(typedClass);
    }

    public static <T> T newInstance(String className, Class<T> asSubclass, String bundleId) {
        Class<T> typedClass = ClassLoaderHelper.loadClass(className, asSubclass, bundleId);
        if (typedClass == null) {
            return null;
        }
        return ClassLoaderHelper.newInstance(typedClass);
    }

    public static <T> T newInstance(String className, Class<T> asSubclass, Bundle bundle) {
        Class<T> typedClass = ClassLoaderHelper.loadClass(className, asSubclass, bundle);
        if (typedClass == null) {
            return null;
        }
        return ClassLoaderHelper.newInstance(typedClass);
    }

    @Deprecated
    public static <T> T newInstance(String className, Class<T> asSubclass) {
        Class<T> typedClass = ClassLoaderHelper.loadClass(className, asSubclass);
        if (typedClass == null) {
            return null;
        }
        return ClassLoaderHelper.newInstance(typedClass);
    }

    public static Object newInstance(String className, URI context) {
        return ClassLoaderHelper.newInstance(ClassLoaderHelper.loadClass(className, context));
    }

    public static Object newInstance(String className, String bundleId) {
        return ClassLoaderHelper.newInstance(ClassLoaderHelper.loadClass(className, bundleId));
    }

    public static Object newInstance(String className, Bundle bundle) {
        return ClassLoaderHelper.newInstance(ClassLoaderHelper.loadClass(className, bundle));
    }

    @Deprecated
    public static Object newInstance(String className) {
        return ClassLoaderHelper.newInstance(ClassLoaderHelper.loadClass(className));
    }

    public static <T> T newInstance(Class<T> theClass) {
        if (theClass == null) {
            return null;
        }
        try {
            return theClass.newInstance();
        }
        catch (IllegalAccessException ex) {
            Activator.log.error("Cannot find a valid public constructor for the class " + theClass.getName(), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            Activator.log.error(String.format("The class %s cannot be instantiated.", theClass.getName()), (Throwable)ex);
        }
        return null;
    }

    private static final String getPluginId(URI uri) {
        String[] segments;
        if (uri != null && (uri.isPlatformPlugin() || "ppe".equals(uri.scheme())) && (segments = uri.segments()).length > 2) {
            return segments[1];
        }
        return null;
    }
}

