/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.templates;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedFontRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.util.BaseResourceImpl;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Configuration;
import org.eclipse.oomph.setup.Installation;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.Workspace;
import org.eclipse.oomph.setup.editor.SetupTemplate;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.StringFilterRegistry;
import org.eclipse.oomph.setup.presentation.templates.Messages;
import org.eclipse.oomph.setup.ui.PropertyField;
import org.eclipse.oomph.ui.LabelDecorator;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.CollectionUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericSetupTemplate
extends SetupTemplate {
    private static final Pattern STRING_EXPANSION_PATTERN = Pattern.compile("\\$(\\{([^${}|/]+)(\\|([^{}/]+))?([^{}]*)}|\\$)");
    private static final Pattern GIT_REPOSITORY_URL_PATTERN = Pattern.compile("\\s*url\\s*=\\s*([^ ]+)");
    private final URI templateLocation;
    private Composite composite;
    private ModelElement setupModelElement;
    private final Map<VariableTask, PropertyField> fields = new LinkedHashMap<VariableTask, PropertyField>();
    private Set<PropertyField> dirtyFields = new HashSet<PropertyField>();
    private final Map<String, VariableTask> variables = new LinkedHashMap<String, VariableTask>();
    private Map<VariableTask, Set<EStructuralFeature.Setting>> usages;
    private PropertyField focusField;
    private final Map<EObject, Set<EStructuralFeature>> focusUsages = new HashMap<EObject, Set<EStructuralFeature>>();
    private LabelDecorator decorator;

    public GenericSetupTemplate(String label, URI templateLocation) {
        super(label);
        this.templateLocation = templateLocation;
    }

    @Override
    public Control createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 10;
        this.composite.setLayout((Layout)layout);
        return this.composite;
    }

    @Override
    public String getMessage() {
        for (PropertyField field : this.fields.values()) {
            if (!StringUtil.isEmpty((String)field.getValue())) continue;
            return "";
        }
        String location = this.expandString("${setup.location}", null);
        Path path = new Path(location);
        String[] segments = path.segments();
        if (segments.length == 0 || path.getDevice() != null) {
            return NLS.bind((String)Messages.GenericSetupTemplate_message_locationIsNotValidProjectPath, (Object)location);
        }
        String projectName = segments[0];
        if (!path.isValidSegment(projectName)) {
            return NLS.bind((String)Messages.GenericSetupTemplate_message_projectNameIsNotValid, (Object)projectName);
        }
        IProject project = EcorePlugin.getWorkspaceRoot().getProject(projectName);
        if (!project.isAccessible()) {
            return NLS.bind((String)Messages.GenericSetupTemplate_message_projectIsNotAccessible, (Object)projectName);
        }
        IProject container = project;
        int i = 1;
        while (i < segments.length) {
            String folderName = segments[i];
            if (!path.isValidSegment(folderName)) {
                return NLS.bind((String)Messages.GenericSetupTemplate_message_folderNameIsNotValid, (Object)folderName);
            }
            IFile file = container.getFile((IPath)new Path(folderName));
            if (file.exists()) {
                return NLS.bind((String)Messages.GenericSetupTemplate_message_fileExistsAt, (Object)file.getFullPath());
            }
            container = container.getFolder((IPath)new Path(folderName));
            ++i;
        }
        String filename = this.expandString("${setup.filename}", null);
        if (!path.isValidSegment(filename = this.expandString(filename, null))) {
            return NLS.bind((String)Messages.GenericSetupTemplate_message_fileNameIsNotValid, (Object)filename);
        }
        if (!filename.endsWith(".setup")) {
            return NLS.bind((String)Messages.GenericSetupTemplate_message_fileNameMissingSetupExtension, (Object)filename);
        }
        IFile file = container.getFile((IPath)new Path(filename));
        if (file.exists()) {
            return NLS.bind((String)Messages.GenericSetupTemplate_message_fileAlreadyExists, (Object)file.getFullPath());
        }
        return null;
    }

    @Override
    public LabelDecorator getDecorator() {
        if (this.decorator == null) {
            this.decorator = new LabelDecorator(){

                public Font decorateFont(Font font, Object element) {
                    String name;
                    VariableTask focusVariable;
                    if (GenericSetupTemplate.this.focusUsages.containsKey(element)) {
                        return ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
                    }
                    if (element instanceof EStructuralFeature.Setting) {
                        EStructuralFeature.Setting setting = (EStructuralFeature.Setting)element;
                        Set eStructuralFeatures = (Set)GenericSetupTemplate.this.focusUsages.get(setting.getEObject());
                        if (eStructuralFeatures != null && eStructuralFeatures.contains(setting.getEStructuralFeature())) {
                            return ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
                        }
                    } else if (element instanceof Resource && (focusVariable = GenericSetupTemplate.this.getFocusVariable()) != null && ("setup.location".equals(name = focusVariable.getName()) || "setup.filename".equals(name))) {
                        return ExtendedFontRegistry.INSTANCE.getFont(font, (Object)IItemFontProvider.BOLD_FONT);
                    }
                    return super.decorateFont(font, element);
                }
            };
        }
        return this.decorator;
    }

    private VariableTask getFocusVariable() {
        for (Map.Entry<VariableTask, PropertyField> entry : this.fields.entrySet()) {
            if (entry.getValue() != this.focusField) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void updatePreview() {
        VariableTask focusVariable = this.getFocusVariable();
        if (focusVariable != null) {
            this.updateSelection(focusVariable);
        }
    }

    protected void updateSelection(VariableTask variable) {
        TreeViewer previewer = this.getContainer().getPreviewer();
        if (previewer != null) {
            Set<EStructuralFeature.Setting> settings;
            this.focusUsages.clear();
            Set<EStructuralFeature.Setting> set = settings = this.usages == null ? null : this.usages.get(variable);
            if (settings != null) {
                for (EStructuralFeature.Setting setting : settings) {
                    CollectionUtil.add(this.focusUsages, (Object)setting.getEObject(), (Object)setting.getEStructuralFeature());
                }
            }
            previewer.refresh(true);
            if (this.focusUsages.isEmpty()) {
                String name = variable.getName();
                if ("setup.location".equals(name) || "setup.filename".equals(name)) {
                    previewer.setSelection((ISelection)new StructuredSelection((Object)this.getResource()), true);
                }
            } else {
                previewer.setSelection((ISelection)new StructuredSelection(this.focusUsages.keySet().toArray()), true);
            }
        }
    }

    @Override
    protected void init() {
        super.init();
        Resource resource = this.getResource();
        ResourceSet resourceSet = resource.getResourceSet();
        this.setupModelElement = (ModelElement)resourceSet.getEObject(this.templateLocation, true);
        this.update(this.setupModelElement);
        final Font normalFont = this.composite.getFont();
        final Font boldFont = ExtendedFontRegistry.INSTANCE.getFont(normalFont, (Object)IItemFontProvider.BOLD_FONT);
        CompoundTask compoundTask = (CompoundTask)this.setupModelElement.eResource().getEObject("template.variables");
        Control firstControl = null;
        VariableTask firstVariable = null;
        String defaultLocation = this.getContainer().getDefaultLocation();
        for (SetupTask setupTask : compoundTask.getSetupTasks()) {
            final VariableTask variable = (VariableTask)setupTask;
            final PropertyField field = PropertyField.createField((VariableTask)variable);
            field.fill(this.composite);
            field.setValue(variable.getValue(), false);
            field.addValueListener(new PropertyField.ValueListener(){

                public void valueChanged(String oldValue, String newValue) throws Exception {
                    GenericSetupTemplate.this.dirtyFields.add(field);
                    GenericSetupTemplate.this.modelChanged(variable);
                }
            });
            field.getControl().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (GenericSetupTemplate.this.focusField != null && GenericSetupTemplate.this.focusField != field) {
                        GenericSetupTemplate.this.focusField.getLabel().setFont(normalFont);
                    }
                    if (GenericSetupTemplate.this.focusField != field) {
                        GenericSetupTemplate.this.focusField = field;
                        field.getLabel().setFont(boldFont);
                        GenericSetupTemplate.this.updateSelection(variable);
                    }
                }
            });
            field.getLabel().setFont(boldFont);
            if (firstControl == null) {
                firstControl = field.getControl();
                firstVariable = variable;
            }
            this.variables.put(variable.getName(), variable);
            this.fields.put(variable, field);
            if (!"setup.location".equals(variable.getName())) continue;
            field.setValue(defaultLocation);
        }
        this.computeTemplateDefaults(true);
        Composite parent = this.composite.getParent();
        int currentHeight = this.composite.getSize().y;
        int newHeight = this.composite.computeSize((int)-1, (int)-1, (boolean)true).y;
        GridData data = UIUtil.applyGridData((Control)parent);
        data.heightHint = newHeight;
        if (currentHeight < newHeight) {
            Shell shell = parent.getShell();
            Point size = shell.getSize();
            shell.setSize(size.x, size.y + newHeight - currentHeight);
        }
        parent.setRedraw(false);
        parent.pack();
        parent.getParent().layout();
        for (PropertyField field : this.fields.values()) {
            field.getLabel().setFont(normalFont);
        }
        parent.setRedraw(true);
        this.modelChanged(firstVariable);
        if (firstControl instanceof Text) {
            Text text = (Text)firstControl;
            text.selectAll();
        }
        firstControl.setFocus();
    }

    private void update(ModelElement modelElement) {
        ProjectCatalog eclipseProjectCatalog;
        block20: {
            ResourceSet resourceSet = modelElement.eResource().getResourceSet();
            eclipseProjectCatalog = null;
            try {
                URI eclipseProjectCatalogLogicalURI = SetupContext.INDEX_ROOT_URI.appendSegment("org.eclipse.projects.setup");
                Resource eclipseProjectCatalogResource = resourceSet.getResource(eclipseProjectCatalogLogicalURI, true);
                eclipseProjectCatalog = (ProjectCatalog)EcoreUtil.getObjectByType((Collection)eclipseProjectCatalogResource.getContents(), (EClassifier)SetupPackage.Literals.PROJECT_CATALOG);
            }
            catch (Exception ex) {
                InputStream input = null;
                try {
                    try {
                        URI eclipseProjectCatalogPhysicalURI = URI.createURI((String)"http://git.eclipse.org/c/oomph/org.eclipse.oomph.git/plain/setups/org.eclipse.projects.setup");
                        input = URIConverter.INSTANCE.createInputStream(eclipseProjectCatalogPhysicalURI);
                        Resource eclipseProjectCatalogResource = resourceSet.createResource(eclipseProjectCatalogPhysicalURI);
                        eclipseProjectCatalogResource.unload();
                        eclipseProjectCatalogResource.load(input, resourceSet.getLoadOptions());
                        eclipseProjectCatalog = (ProjectCatalog)EcoreUtil.getObjectByType((Collection)eclipseProjectCatalogResource.getContents(), (EClassifier)SetupPackage.Literals.PROJECT_CATALOG);
                    }
                    catch (IOException eclipseProjectCatalogPhysicalURI) {
                        IOUtil.closeSilent(input);
                        break block20;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(input);
                    throw throwable;
                }
                IOUtil.closeSilent((Closeable)input);
            }
        }
        if (eclipseProjectCatalog != null) {
            VariableTask productReleaseTrainVariable;
            VariableTask eclipseTargetPlatformVariable = this.getVariable((ModelElement)eclipseProjectCatalog, "eclipse.target.platform");
            if (eclipseTargetPlatformVariable != null && (productReleaseTrainVariable = this.getVariable(modelElement, "product.release.train")) != null) {
                EList choices = productReleaseTrainVariable.getChoices();
                choices.clear();
                Collection eclipseTargetPlatformChoices = EcoreUtil.copyAll((Collection)eclipseTargetPlatformVariable.getChoices());
                Iterator it = eclipseTargetPlatformChoices.iterator();
                while (it.hasNext()) {
                    VariableChoice variableChoice = (VariableChoice)it.next();
                    String value = variableChoice.getValue();
                    if (!"None".equals(value) && !"Galileo".equals(value) && !"Helios".equals(value) && !"Indigo".equals(value)) continue;
                    it.remove();
                }
                choices.addAll(eclipseTargetPlatformChoices);
                productReleaseTrainVariable.setValue(((VariableChoice)choices.get(0)).getValue());
            }
            if (modelElement instanceof ProjectCatalog) {
                EObject eclipseProjectCatalogModularAPIBaselineTargletTask;
                EObject projectCatalogModularAPIBaselineTargletTask;
                EObject eclipseProjectCatalogModularTargletTask;
                EObject projectCatalogModularTargletTask;
                VariableTask eclipseApiBaselineTargetPlatformVariable;
                VariableTask apiBaselineTargetPlatformVariable;
                VariableTask targetPlatformVariable = this.getVariable(modelElement, "eclipse.target.platform");
                if (targetPlatformVariable != null) {
                    EcoreUtil.replace((EObject)targetPlatformVariable, (EObject)EcoreUtil.copy((EObject)eclipseTargetPlatformVariable));
                }
                if ((apiBaselineTargetPlatformVariable = this.getVariable(modelElement, "eclipse.api.baseline.target.platform")) != null && (eclipseApiBaselineTargetPlatformVariable = this.getVariable((ModelElement)eclipseProjectCatalog, "eclipse.api.baseline.target.platform")) != null) {
                    EcoreUtil.replace((EObject)apiBaselineTargetPlatformVariable, (EObject)EcoreUtil.copy((EObject)eclipseApiBaselineTargetPlatformVariable));
                }
                if ((projectCatalogModularTargletTask = this.getTargletTask(modelElement, "Modular Target")) != null && (eclipseProjectCatalogModularTargletTask = this.getTargletTask((ModelElement)eclipseProjectCatalog, "Modular Target")) != null) {
                    EcoreUtil.replace((EObject)projectCatalogModularTargletTask, (EObject)EcoreUtil.copy((EObject)eclipseProjectCatalogModularTargletTask));
                }
                if ((projectCatalogModularAPIBaselineTargletTask = this.getTargletTask(modelElement, "Modular API Baseline Target")) != null && (eclipseProjectCatalogModularAPIBaselineTargletTask = this.getTargletTask((ModelElement)eclipseProjectCatalog, "Modular API Baseline Target")) != null) {
                    EcoreUtil.replace((EObject)projectCatalogModularAPIBaselineTargletTask, (EObject)EcoreUtil.copy((EObject)eclipseProjectCatalogModularAPIBaselineTargletTask));
                }
            } else {
                EObject projectTargletTask = this.getTargletTask(modelElement, "Modular Target");
                if (projectTargletTask != null) {
                    EObject projectTarglet = (EObject)((List)projectTargletTask.eGet(projectTargletTask.eClass().getEStructuralFeature("targlets"))).get(0);
                    List repositoryLists = (List)projectTarglet.eGet(projectTarglet.eClass().getEStructuralFeature("repositoryLists"));
                    RepositoryList repositoryList = (RepositoryList)repositoryLists.get(0);
                    repositoryLists.clear();
                    VariableTask targetPlatformVariable = this.getVariable(modelElement, "eclipse.target.platform");
                    for (VariableChoice variableChoice : eclipseTargetPlatformVariable.getChoices()) {
                        String trainName = variableChoice.getValue();
                        if ("None".equals(trainName)) continue;
                        if (targetPlatformVariable != null) {
                            targetPlatformVariable.setDefaultValue(trainName);
                            targetPlatformVariable = null;
                        }
                        RepositoryList newRepositoryList = (RepositoryList)EcoreUtil.copy((EObject)repositoryList);
                        newRepositoryList.setName(trainName);
                        for (Repository repository : newRepositoryList.getRepositories()) {
                            if (!repository.getURL().contains("download.eclipse.org/releases")) continue;
                            repository.setURL("http://download.eclipse.org/releases/" + trainName.toLowerCase());
                        }
                        repositoryLists.add(newRepositoryList);
                    }
                }
            }
        }
    }

    private VariableTask getVariable(ModelElement modelElement, String variableName) {
        TreeIterator it = modelElement.eAllContents();
        while (it.hasNext()) {
            VariableTask variable;
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof VariableTask) || !variableName.equals((variable = (VariableTask)eObject).getName())) continue;
            return variable;
        }
        return null;
    }

    private EObject getTargletTask(ModelElement modelElement, String targetName) {
        TreeIterator it = modelElement.eAllContents();
        while (it.hasNext()) {
            EStructuralFeature targetNameFeature;
            EObject eObject = (EObject)it.next();
            EClass eClass = eObject.eClass();
            if (!"TargletTask".equals(eClass.getName()) || !targetName.equals(eObject.eGet(targetNameFeature = eClass.getEStructuralFeature("targetName")))) continue;
            return eObject;
        }
        return null;
    }

    private void modelChanged(final VariableTask triggerVariable) {
        this.computeTemplateDefaults(false);
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        ModelElement copy = (ModelElement)copier.copy((EObject)this.setupModelElement);
        copier.copyReferences();
        HashSet<BaseResourceImpl> resources = new HashSet<BaseResourceImpl>();
        for (Map.Entry entry : copier.entrySet()) {
            Resource.Internal internal;
            EObject key = (EObject)entry.getKey();
            if (key == this.setupModelElement || (internal = ((InternalEObject)key).eDirectResource()) == null) continue;
            BaseResourceImpl resource2 = new BaseResourceImpl(internal.getURI());
            resources.add(resource2);
            resource2.getContents().add((Object)((EObject)entry.getValue()));
        }
        HashSet<PropertyField> originalDirtyPropertyFields = new HashSet<PropertyField>(this.dirtyFields);
        for (VariableTask variable : this.variables.values()) {
            PropertyField propertyField = this.fields.get(variable);
            if (this.dirtyFields.contains(propertyField)) continue;
            String value = variable.getValue();
            if (!StringUtil.isEmpty((String)value)) {
                value = this.expandString(value, null);
                propertyField.setValue(value, false);
            }
            this.dirtyFields.add(propertyField);
        }
        this.usages = new HashMap<VariableTask, Set<EStructuralFeature.Setting>>();
        HashSet<Object> eObjectsToDelete = new HashSet<Object>();
        LinkedHashSet<Annotation> featureSubstitutions = new LinkedHashSet<Annotation>();
        TreeIterator treeIterator = EcoreUtil.getAllContents(Collections.singleton(copy));
        while (treeIterator.hasNext()) {
            CompoundTask compoundTask;
            InternalEObject eObject = (InternalEObject)treeIterator.next();
            for (EAttribute eAttribute : eObject.eClass().getEAllAttributes()) {
                String value;
                EDataType eAttributeType = eAttribute.getEAttributeType();
                Class instanceClass = eAttributeType.getInstanceClass();
                if (instanceClass != String.class && instanceClass != URI.class || eAttribute.isDerived() || eAttribute.isMany() || (value = EcoreUtil.convertToString((EDataType)eAttributeType, (Object)eObject.eGet((EStructuralFeature)eAttribute))) == null) continue;
                HashSet<VariableTask> usedVariables = new HashSet<VariableTask>();
                String replacement = this.expandString(value, usedVariables);
                CollectionUtil.addAll(this.usages, usedVariables, (Object)eObject.eSetting((EStructuralFeature)eAttribute));
                eObject.eSet((EStructuralFeature)eAttribute, EcoreUtil.createFromString((EDataType)eAttributeType, (String)replacement));
            }
            if (eObject instanceof Annotation) {
                Annotation annotation = (Annotation)eObject;
                if (!"http://www.eclipse.org/oomph/setup/FeatureSubstitution".equals(annotation.getSource())) continue;
                featureSubstitutions.add(annotation);
                eObjectsToDelete.add(annotation);
                continue;
            }
            if (!(eObject instanceof CompoundTask) || !"template.variables".equals((compoundTask = (CompoundTask)eObject).getID())) continue;
            EObject eContainer = compoundTask.eContainer();
            eObjectsToDelete.add(eContainer instanceof Scope ? compoundTask : eContainer);
        }
        for (Annotation annotation : featureSubstitutions) {
            ModelElement modelElement = annotation.getModelElement();
            EClass eClass = modelElement.eClass();
            for (Map.Entry detail : annotation.getDetails()) {
                EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature((String)detail.getKey());
                if (!(eStructuralFeature instanceof EAttribute)) continue;
                try {
                    modelElement.eSet(eStructuralFeature, EcoreUtil.createFromString((EDataType)((EAttribute)eStructuralFeature).getEAttributeType(), (String)((String)detail.getValue())));
                    block8: for (Map.Entry<VariableTask, Set<EStructuralFeature.Setting>> entry : this.usages.entrySet()) {
                        Set<EStructuralFeature.Setting> settings = entry.getValue();
                        for (EStructuralFeature.Setting setting : settings) {
                            if (setting.getEObject() != detail || setting.getEStructuralFeature() != BasePackage.Literals.STRING_TO_STRING_MAP_ENTRY__VALUE) continue;
                            settings.add(((InternalEObject)modelElement).eSetting(eStructuralFeature));
                            continue block8;
                        }
                    }
                }
                catch (RuntimeException entry) {
                    // empty catch block
                }
            }
        }
        for (EObject eObject : eObjectsToDelete) {
            EcoreUtil.delete((EObject)eObject);
        }
        for (Resource resource : resources) {
            URI uri = resource.getURI();
            String expandedURI = this.expandString(uri.toString(), null);
            resource.setURI(URI.createURI((String)expandedURI));
        }
        final Resource resource = this.getResource();
        final ArrayList<String> strings = new ArrayList<String>();
        final TreeViewer previewer = this.getContainer().getPreviewer();
        if (previewer != null) {
            Object[] objectArray = previewer.getExpandedElements();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    strings.add(resource.getURIFragment(eObject));
                }
                ++n2;
            }
            previewer.getControl().setRedraw(false);
            this.updateResource(copy);
            UIUtil.asyncExec((Runnable)new Runnable(){

                public void run() {
                    if (!previewer.getControl().isDisposed()) {
                        ArrayList<EObject> eObjects = new ArrayList<EObject>();
                        for (String fragment : strings) {
                            EObject eObject = resource.getEObject(fragment);
                            if (eObject == null) continue;
                            eObjects.add(eObject);
                        }
                        previewer.setExpandedElements(eObjects.toArray());
                        GenericSetupTemplate.this.updateSelection(triggerVariable);
                        previewer.getControl().setRedraw(true);
                    }
                }
            });
        } else {
            this.updateResource(copy);
        }
        this.dirtyFields = originalDirtyPropertyFields;
        this.getContainer().validate();
    }

    private void updateResource(ModelElement setup) {
        Resource resource = this.getResource();
        EList contents = resource.getContents();
        if (contents.isEmpty()) {
            contents.add((Object)setup);
        } else {
            contents.set(0, (Object)setup);
        }
        String location = this.expandString("${setup.location}", null);
        String fileName = this.expandString("${setup.filename}", null);
        resource.setURI(URI.createURI((String)("platform:/resource" + new Path(location).makeAbsolute() + "/" + fileName)));
    }

    private String expandString(String string, Set<VariableTask> usedVariables) {
        if (string == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int previous = 0;
        Matcher matcher = STRING_EXPANSION_PATTERN.matcher(string);
        while (matcher.find()) {
            result.append(string.substring(previous, matcher.start()));
            String key = matcher.group(1);
            if ("$".equals(key)) {
                result.append('$');
            } else {
                key = matcher.group(2);
                String suffix = matcher.group(5);
                VariableTask variable = this.variables.get(key);
                if (variable == null) {
                    result.append(matcher.group());
                } else {
                    PropertyField field;
                    String value;
                    if (usedVariables != null) {
                        usedVariables.add(variable);
                    }
                    String string2 = value = this.dirtyFields.contains(field = this.fields.get(variable)) ? field.getValue() : variable.getValue();
                    if (StringUtil.isEmpty((String)value)) {
                        result.append(matcher.group());
                    } else {
                        String filters = matcher.group(4);
                        if (filters != null) {
                            String[] stringArray = filters.split("\\|");
                            int n = stringArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String filterName = stringArray[n2];
                                value = this.filter(variable, value, filterName);
                                ++n2;
                            }
                        }
                        result.append(value);
                        result.append(suffix);
                    }
                }
            }
            previous = matcher.end();
        }
        result.append(string.substring(previous));
        return result.toString();
    }

    private String filter(VariableTask variable, String value, String filterName) {
        if (filterName.equals("label")) {
            for (VariableChoice choice : variable.getChoices()) {
                if (!value.equals(choice.getValue())) continue;
                return choice.getLabel();
            }
        }
        if (filterName.equals("firstSegment")) {
            URI uri = URI.createURI((String)value);
            return uri.segmentCount() > 0 ? uri.segment(0) : "";
        }
        if (filterName.equals("not")) {
            return "false".equals(value) ? "true" : "false";
        }
        if (filterName.equals("description")) {
            return value.startsWith("...") ? String.valueOf(StringUtil.NL) + Messages.GenericSetupTemplate_beforeEnablingTaskReplacePlaceholderWithRepoPath : "";
        }
        if (filterName.equals("requiredJavaVersion")) {
            if ("Juno".equals(value)) {
                return "1.5";
            }
            if ("Kepler".equals(value) || "Luna".equals(value)) {
                return "1.6";
            }
            if ("Mars".equals(value)) {
                return "1.7";
            }
            return "1.8";
        }
        if (filterName.equals("isClonePath")) {
            return this.filter(variable, value, "clonePath").startsWith("...") ? "false" : "true";
        }
        if (filterName.equals("clonePath")) {
            try {
                IProject project = EcorePlugin.getWorkspaceRoot().getProject(new Path(value).segment(0));
                IPath location = project.getLocation();
                StringBuilder path = new StringBuilder();
                if (location != null) {
                    File file = location.toFile();
                    while (file != null) {
                        File[] gitFile = file.listFiles(new FileFilter(){

                            public boolean accept(File pathname) {
                                return ".git".equals(pathname.getName());
                            }
                        });
                        if (gitFile.length == 1) {
                            return path.toString();
                        }
                        if (path.length() != 0) {
                            path.insert(0, '/');
                        }
                        path.insert(0, file.getName());
                        file = file.getParentFile();
                    }
                    return ".../" + location.segment(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return "...";
        }
        return StringFilterRegistry.INSTANCE.filter(value, filterName);
    }

    private void computeTemplateDefaults(boolean initial) {
        if (this.variables.containsKey("project.name")) {
            Path path;
            String fileLocation = this.expandString("${setup.location}", null);
            if (fileLocation != null && !fileLocation.equals("${setup.location}") && (path = new Path(fileLocation)).segmentCount() > 0) {
                String firstSegment;
                List qualifiedName;
                try {
                    IProject project = EcorePlugin.getWorkspaceRoot().getProject(path.segment(0));
                    IPath location = project.getLocation();
                    if (location != null) {
                        File file = location.toFile();
                        while (file != null) {
                            File[] gitFile = file.listFiles(new FileFilter(){

                                public boolean accept(File pathname) {
                                    return ".git".equals(pathname.getName());
                                }
                            });
                            if (gitFile.length == 1) {
                                List lines = IOUtil.readLines((File)new File(gitFile[0], "config"), (String)"UTF-8");
                                for (String line : lines) {
                                    Matcher matcher = GIT_REPOSITORY_URL_PATTERN.matcher(line);
                                    if (!matcher.matches()) continue;
                                    URI repositoryURI = URI.createURI((String)matcher.group(1));
                                    String host = repositoryURI.host();
                                    List segments = repositoryURI.isHierarchical() ? repositoryURI.segmentsList() : URI.createURI((String)repositoryURI.opaquePart()).segmentsList();
                                    String firstSegment2 = (String)segments.get(0);
                                    String lastSegment = (String)segments.get(segments.size() - 1);
                                    List qualifiedName2 = StringUtil.explode((String)lastSegment, (String)".-");
                                    String projectRemoteURIs = null;
                                    if ("git.eclipse.org".equals(host)) {
                                        if ("r".equals(firstSegment2) || "gitroot".equals(firstSegment2)) {
                                            segments.remove(0);
                                        }
                                        if ("r".equals(firstSegment2) || repositoryURI.port() != null) {
                                            projectRemoteURIs = "eclipse.git.gerrit.remoteURIs";
                                        }
                                        if ("org".equals(qualifiedName2.get(0))) {
                                            qualifiedName2.remove(0);
                                        }
                                        if ("eclipse".equals(qualifiedName2.get(0))) {
                                            qualifiedName2.remove(0);
                                        }
                                    } else if ("github.com".equals(host) && "eclipse".equals(firstSegment2)) {
                                        projectRemoteURIs = "github.remoteURIs";
                                    }
                                    String projectName = StringUtil.implode((List)qualifiedName2, (char)'.');
                                    ListIterator<String> it = qualifiedName2.listIterator();
                                    while (it.hasNext()) {
                                        String nameSegment = (String)it.next();
                                        it.set(nameSegment.length() <= 4 ? nameSegment.toUpperCase() : StringUtil.cap((String)nameSegment));
                                    }
                                    String projectLabel = StringUtil.implode((List)qualifiedName2, (char)' ');
                                    this.applyVariableValue("project.label", projectLabel);
                                    this.applyVariableValue("project.name", projectName);
                                    this.applyVariableValue("project.git.path", StringUtil.implode((List)segments, (char)'/'));
                                    if (projectRemoteURIs != null) {
                                        this.applyVariableValue("project.remote.uris", projectRemoteURIs);
                                    }
                                    return;
                                }
                            }
                            file = file.getParentFile();
                        }
                    }
                }
                catch (Exception project) {
                    // empty catch block
                }
                if (!(qualifiedName = StringUtil.explode((String)(firstSegment = path.segment(0)), (String)".-_ ")).isEmpty()) {
                    ArrayList<String> domainPrefixes = new ArrayList<String>(Arrays.asList(Locale.getISOCountries()));
                    domainPrefixes.add("COM");
                    domainPrefixes.add("ORG");
                    if (domainPrefixes.contains(((String)qualifiedName.get(0)).toUpperCase())) {
                        qualifiedName.remove(0);
                        if (qualifiedName.size() > 1) {
                            qualifiedName.remove(0);
                        }
                    }
                    String nameSegment = (String)qualifiedName.get(0);
                    String projectName = nameSegment.toLowerCase();
                    String projectLabel = nameSegment.length() <= 4 ? nameSegment.toUpperCase() : StringUtil.cap((String)nameSegment);
                    this.applyVariableValue("project.label", projectLabel);
                    this.applyVariableValue("project.name", projectName);
                    return;
                }
            }
            this.restoreDefaultValue("project.label");
            this.restoreDefaultValue("project.name");
            this.restoreDefaultValue("project.git.path");
            this.restoreDefaultValue("project.remote.uris");
        } else if (initial && this.templateLocation.lastSegment().contains("Copy") && this.setupModelElement instanceof Configuration) {
            Workspace actualWorkspace;
            Workspace workspace;
            Installation actualInstallation;
            Configuration configuration = (Configuration)this.setupModelElement;
            SetupContext setupContext = SetupContext.create((ResourceSet)this.setupModelElement.eResource().getResourceSet());
            Installation installation = configuration.getInstallation();
            if (installation != null && (actualInstallation = setupContext.getInstallation()) != null) {
                Resource eResource;
                ProductVersion productVersion = actualInstallation.getProductVersion();
                if (productVersion != null && (eResource = productVersion.eResource()) != null && !"catalog".equals(eResource.getURI().scheme())) {
                    installation.setProductVersion(productVersion);
                }
                this.copyContents((Scope)installation, (Scope)actualInstallation);
                this.computeDefaultAttributes((Scope)installation, (Scope)actualInstallation, "installation.");
            }
            if ((workspace = configuration.getWorkspace()) != null && (actualWorkspace = setupContext.getWorkspace()) != null) {
                EList streams = actualWorkspace.getStreams();
                workspace.getStreams().addAll((Collection)streams);
                this.copyContents((Scope)workspace, (Scope)actualWorkspace);
                this.computeDefaultAttributes((Scope)workspace, (Scope)actualWorkspace, "workspace.");
            }
        }
    }

    private void copyContents(Scope target, Scope source) {
        EList annotations = source.getAnnotations();
        EList setupTasks = source.getSetupTasks();
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        Collection annotationCopies = copier.copyAll((Collection)annotations);
        Collection setupTaskCopies = copier.copyAll((Collection)setupTasks);
        copier.copyReferences();
        target.getAnnotations().addAll(annotationCopies);
        target.getSetupTasks().addAll(setupTaskCopies);
        HashSet<EObject> eObjectsToDelete = new HashSet<EObject>();
        TreeIterator it = target.eAllContents();
        while (it.hasNext()) {
            EObject eObject = (EObject)it.next();
            if (!(eObject instanceof SetupTask) || ((SetupTask)eObject).getRestrictions().isEmpty()) continue;
            eObjectsToDelete.add(eObject);
        }
        EcoreUtil.deleteAll(eObjectsToDelete, (boolean)true);
    }

    private void computeDefaultAttributes(Scope target, Scope source, String variablePrefix) {
        String description;
        String label;
        String name = source.getName();
        if (!StringUtil.isEmpty((String)name) && name != null && !(String.valueOf(name) + ".").equals(variablePrefix)) {
            this.applyVariableValue(String.valueOf(variablePrefix) + "name", name);
        }
        if (!StringUtil.isEmpty((String)(label = source.getLabel()))) {
            this.applyVariableValue(String.valueOf(variablePrefix) + "label", label);
        }
        if (!StringUtil.isEmpty((String)(description = source.getDescription()))) {
            this.applyVariableValue(String.valueOf(variablePrefix) + "description", description);
        }
    }

    private void applyVariableValue(String name, String value) {
        PropertyField field;
        VariableTask variable = this.variables.get(name);
        if (variable != null && !this.dirtyFields.contains(field = this.fields.get(variable))) {
            if (variable.getDefaultValue() == null) {
                variable.setDefaultValue(variable.getValue());
            }
            variable.setValue(value);
            field.setValue(value, false);
        }
    }

    private void restoreDefaultValue(String name) {
        String defaultValue;
        PropertyField field;
        VariableTask variable = this.variables.get(name);
        if (variable != null && !this.dirtyFields.contains(field = this.fields.get(variable)) && (defaultValue = variable.getDefaultValue()) != null) {
            variable.setValue(defaultValue);
            field.setValue(defaultValue, false);
        }
    }
}

