/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.utilities;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Iteration;
import org.eclipse.ocl.pivot.LambdaType;
import org.eclipse.ocl.pivot.LoopExp;
import org.eclipse.ocl.pivot.MapType;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.internal.resource.ASSaver;
import org.eclipse.ocl.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.pivot.util.Visitable;

public class ASSaverLocateVisitor
extends AbstractExtendingVisitor<Object, ASSaver> {
    public ASSaverLocateVisitor(@NonNull ASSaver context) {
        super(context);
    }

    @Override
    public Object visitClass(@NonNull Class object) {
        for (Class superClass : object.getSuperClasses()) {
            if (superClass.getOwnedBindings().size() <= 0) continue;
            ((ASSaver)this.context).addSpecializingElement(object);
            break;
        }
        return null;
    }

    @Override
    public Object visitCollectionType(@NonNull CollectionType object) {
        Class referredClass;
        Type referredType = object.getElementType();
        Class clazz = referredClass = referredType != null ? referredType.isClass() : null;
        if (referredClass != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass);
        }
        return super.visitCollectionType(object);
    }

    @Override
    public Object visitLambdaType(@NonNull LambdaType object) {
        Class referredClass;
        boolean doneIt = false;
        Type referredType = object.getContextType();
        Class clazz = referredClass = referredType != null ? referredType.isClass() : null;
        if (referredClass != null && ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass)) {
            doneIt = true;
        }
        if (!doneIt) {
            referredType = object.getResultType();
            Class clazz2 = referredClass = referredType != null ? referredType.isClass() : null;
            if (referredClass != null && ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass)) {
                doneIt = true;
            }
            if (!doneIt) {
                for (Type parameterType : object.getParameterType()) {
                    Class clazz3 = referredClass = parameterType != null ? parameterType.isClass() : null;
                    if (referredClass != null && ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass)) break;
                }
            }
        }
        return super.visitLambdaType(object);
    }

    @Override
    public Object visitLoopExp(@NonNull LoopExp object) {
        Iteration referredIteration = object.getReferredIteration();
        if (referredIteration != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredIteration);
        }
        return super.visitLoopExp(object);
    }

    @Override
    public Object visitMapType(@NonNull MapType object) {
        Class referredClass;
        Type referredType = object.getKeyType();
        Class clazz = referredClass = referredType != null ? referredType.isClass() : null;
        if (referredClass != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass);
        }
        Class clazz2 = referredClass = (referredType = object.getValueType()) != null ? referredType.isClass() : null;
        if (referredClass != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass);
        }
        return super.visitMapType(object);
    }

    @Override
    public Object visitOperationCallExp(@NonNull OperationCallExp object) {
        Operation referredOperation = object.getReferredOperation();
        if (referredOperation != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredOperation);
        }
        return super.visitOperationCallExp(object);
    }

    @Override
    public Object visitProperty(@NonNull Property object) {
        Property opposite = object.getOpposite();
        if (opposite != null) {
            Resource eResource = opposite.eResource();
            assert (eResource != null);
        }
        return super.visitProperty(object);
    }

    @Override
    public Object visitPropertyCallExp(@NonNull PropertyCallExp object) {
        Property referredProperty;
        OCLExpression ownedSource = object.getOwnedSource();
        if (ownedSource != null && (referredProperty = object.getReferredProperty()) != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredProperty);
        }
        return super.visitPropertyCallExp(object);
    }

    @Override
    public Object visitTemplateParameter(@NonNull TemplateParameter object) {
        for (Class constrainingType : object.getConstrainingClasses()) {
            if (constrainingType != null && ((ASSaver)this.context).addSpecializingElement((Element)object, constrainingType)) break;
        }
        return null;
    }

    @Override
    public Object visitTemplateParameterSubstitution(@NonNull TemplateParameterSubstitution object) {
        Class referredClass;
        Type actual = object.getActual();
        Class clazz = referredClass = actual != null ? actual.isClass() : null;
        if (referredClass != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass);
        }
        return null;
    }

    @Override
    public Object visitTypeExp(@NonNull TypeExp object) {
        Type referredType = object.getReferredType();
        if (referredType instanceof Class) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, (Class)referredType);
        }
        return super.visitTypeExp(object);
    }

    @Override
    public Object visitTypedElement(@NonNull TypedElement object) {
        Class referredClass;
        Type referredType = object.getType();
        Class clazz = referredClass = referredType != null ? referredType.isClass() : null;
        if (referredClass != null) {
            ((ASSaver)this.context).addSpecializingElement((Element)object, referredClass);
        }
        return null;
    }

    @Override
    public Object visiting(@NonNull Visitable visitable) {
        return null;
    }
}

