/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.validity.locator;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.emf.validation.validity.LeafConstrainingNode;
import org.eclipse.ocl.examples.emf.validation.validity.Result;
import org.eclipse.ocl.examples.emf.validation.validity.Severity;
import org.eclipse.ocl.examples.emf.validation.validity.ValidatableNode;
import org.eclipse.ocl.examples.emf.validation.validity.locator.ConstraintLocator;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ConstrainingURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.TypeURI;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityManager;
import org.eclipse.ocl.examples.emf.validation.validity.manager.ValidityModel;
import org.eclipse.ocl.examples.validity.locator.AbstractPivotConstraintLocator;
import org.eclipse.ocl.pivot.Constraint;
import org.eclipse.ocl.pivot.ExpressionInOCL;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.utilities.EnvironmentFactoryInternal;
import org.eclipse.ocl.pivot.internal.utilities.PivotUtilInternal;
import org.eclipse.ocl.pivot.utilities.ParserException;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.ValueSpecification;

public class UMLConstraintLocator
extends AbstractPivotConstraintLocator {
    public static @NonNull UMLConstraintLocator INSTANCE = new UMLConstraintLocator();

    protected void appendPath(@NonNull StringBuilder s, @NonNull NamedElement eObject) {
        EObject eContainer = eObject.eContainer();
        if (eContainer instanceof NamedElement) {
            this.appendPath(s, (NamedElement)eContainer);
            s.append("::");
        }
        s.append(eObject.getName());
    }

    public @NonNull Set<@NonNull TypeURI> getAllTypes(@NonNull ValidityManager validityManager, @NonNull EObject constrainingType) {
        if (constrainingType instanceof Class) {
            HashSet<@NonNull TypeURI> allTypes = new HashSet<TypeURI>();
            allTypes.add(validityManager.getTypeURI(constrainingType));
            if (constrainingType instanceof Class) {
                this.getAllTypes(allTypes, validityManager, (Iterable<Class>)((Class)constrainingType).getSuperClasses());
            }
            return allTypes;
        }
        return super.getAllTypes(validityManager, constrainingType);
    }

    private void getAllTypes(Set<@NonNull TypeURI> knownTypes, @NonNull ValidityManager validityManager, Iterable<Class> moreTypes) {
        for (Class anotherType : moreTypes) {
            if (anotherType == null || !knownTypes.add(validityManager.getTypeURI((EObject)anotherType))) continue;
            this.getAllTypes(knownTypes, validityManager, (Iterable<Class>)anotherType.getSuperClasses());
        }
    }

    public @Nullable ConstrainingURI getConstrainingURI(@NonNull EObject eObject) {
        Object value;
        EObject eContainer = eObject;
        while (true) {
            if (eContainer == null) {
                return null;
            }
            if (eContainer instanceof Package) break;
            eContainer = eContainer.eContainer();
        }
        String nsURI = null;
        Stereotype appliedStereotype = ((Package)eContainer).getAppliedStereotype("Ecore::EPackage");
        if (appliedStereotype != null && (value = ((Package)eContainer).getValue(appliedStereotype, "nsURI")) != null) {
            nsURI = value.toString();
        }
        if (nsURI == null) {
            nsURI = ((Package)eContainer).getURI();
        }
        if (nsURI == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        String uriFragment = resource.getURIFragment(eObject);
        if (uriFragment == null) {
            return null;
        }
        if (!uriFragment.startsWith("//")) {
            uriFragment = "//" + uriFragment;
        }
        @NonNull URI constrainingURI = URI.createURI((String)nsURI).appendFragment(uriFragment);
        return new ConstrainingURI(constrainingURI);
    }

    public @Nullable Map<@NonNull EObject, @NonNull List<@NonNull LeafConstrainingNode>> getConstraints(@NonNull ValidityModel validityModel, @NonNull EPackage ePackage, @NonNull Set<@NonNull Resource> resources, @NonNull Monitor monitor) {
        Map map = null;
        for (Resource resource : resources) {
            if (monitor.isCanceled()) {
                return null;
            }
            TreeIterator tit = resource.getAllContents();
            while (tit.hasNext()) {
                org.eclipse.uml2.uml.Constraint umlConstraint;
                Namespace contextElement;
                EObject eObject = (EObject)tit.next();
                if (eObject instanceof org.eclipse.uml2.uml.Constraint && (contextElement = (umlConstraint = (org.eclipse.uml2.uml.Constraint)eObject).getContext()) instanceof org.eclipse.uml2.uml.Type) {
                    @NonNull String label = String.valueOf(umlConstraint.getName());
                    map = this.createLeafConstrainingNode(map, validityModel, (EObject)contextElement, umlConstraint, label);
                }
                if (!monitor.isCanceled()) continue;
                return null;
            }
        }
        return map;
    }

    public @Nullable Collection<@NonNull Resource> getImports(@NonNull EPackage ePackage, @NonNull Resource resource) {
        HashSet<@NonNull Resource> imports = new HashSet<Resource>();
        TreeIterator tit = resource.getAllContents();
        while (tit.hasNext()) {
            Resource eResource;
            Resource eResource2;
            PackageImport umlPackageImport;
            Package importedPackage;
            EObject eObject = (EObject)tit.next();
            if (eObject instanceof PackageImport && (importedPackage = (umlPackageImport = (PackageImport)eObject).getImportedPackage()) != null && (eResource2 = importedPackage.eResource()) != null) {
                imports.add(eResource2);
            }
            if ((eResource = eObject.eClass().eResource()) == null) continue;
            imports.add(eResource);
        }
        return imports;
    }

    public @NonNull ConstraintLocator getInstance() {
        return INSTANCE;
    }

    public @NonNull String getLabel(@NonNull EModelElement eObject) {
        if (eObject instanceof NamedElement) {
            StringBuilder s = new StringBuilder();
            this.appendPath(s, (NamedElement)eObject);
            return s.toString();
        }
        return super.getLabel(eObject);
    }

    public @NonNull String getName() {
        return "UML Constraints";
    }

    public @Nullable String getSourceExpression(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof org.eclipse.uml2.uml.Constraint)) {
            return null;
        }
        ValueSpecification specification = ((org.eclipse.uml2.uml.Constraint)constrainingObject).getSpecification();
        if (!(specification instanceof OpaqueExpression)) {
            return null;
        }
        EList bodies = ((OpaqueExpression)specification).getBodies();
        return bodies.size() > 0 ? (String)bodies.get(0) : null;
    }

    @Override
    public @Nullable Resource getSourceResource(@NonNull LeafConstrainingNode node) {
        Object constrainingObject = node.getConstrainingObject();
        if (!(constrainingObject instanceof EObject)) {
            return null;
        }
        return ((EObject)constrainingObject).eResource();
    }

    public @Nullable TypeURI getTypeURI(@NonNull EObject eObject) {
        Object value;
        EObject eContainer = eObject;
        while (true) {
            if (eContainer == null) {
                return null;
            }
            if (eContainer instanceof Package) break;
            eContainer = eContainer.eContainer();
        }
        String nsURI = null;
        Stereotype appliedStereotype = ((Package)eContainer).getAppliedStereotype("Ecore::EPackage");
        if (appliedStereotype != null && (value = ((Package)eContainer).getValue(appliedStereotype, "nsURI")) != null) {
            nsURI = value.toString();
        }
        if (nsURI == null) {
            nsURI = ((Package)eContainer).getURI();
        }
        if (nsURI == null) {
            return null;
        }
        Resource resource = eObject.eResource();
        if (resource == null) {
            return null;
        }
        String uriFragment = resource.getURIFragment(eObject);
        if (!uriFragment.startsWith("//")) {
            uriFragment = "//" + uriFragment;
        }
        @NonNull URI typeURI = URI.createURI((String)nsURI).appendFragment(uriFragment);
        return new TypeURI(typeURI);
    }

    public @Nullable Set<@NonNull TypeURI> getTypeURIs(@NonNull ValidityManager validityManager, @NonNull EObject validatableObject) {
        EObject umlClass;
        EAnnotation eAnnotation;
        EClass eClass = validatableObject.eClass();
        if (eClass != null && (eAnnotation = eClass.getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && eAnnotation.getReferences().size() > 0 && (umlClass = (EObject)eAnnotation.getReferences().get(0)) != null) {
            HashSet<@NonNull TypeURI> allTypeURIs = new HashSet<TypeURI>();
            TypeURI typeURI = validityManager.getTypeURI(umlClass);
            allTypeURIs.add(typeURI);
            return allTypeURIs;
        }
        if (validatableObject instanceof InstanceSpecification) {
            HashSet<@NonNull TypeURI> allTypeURIs = new HashSet<TypeURI>();
            for (Classifier umlClassifier : ((InstanceSpecification)validatableObject).getClassifiers()) {
                if (umlClassifier == null) continue;
                TypeURI typeURI = validityManager.getTypeURI((EObject)umlClassifier);
                allTypeURIs.add(typeURI);
            }
            return allTypeURIs;
        }
        return null;
    }

    public void validate(@NonNull Result result, @NonNull ValidityManager validityManager, @Nullable Monitor monitor) {
        ValidatableNode validatableNode = result.getValidatableNode();
        EObject contextObject = validatableNode.getConstrainedObject();
        LeafConstrainingNode leafConstrainingNode = result.getLeafConstrainingNode();
        org.eclipse.uml2.uml.Constraint umlConstraint = (org.eclipse.uml2.uml.Constraint)leafConstrainingNode.getConstrainingObject();
        if (umlConstraint == null) {
            return;
        }
        EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)PivotUtilInternal.findEnvironmentFactory((EObject)umlConstraint);
        if (environmentFactory == null) {
            Resource eResource = umlConstraint.eResource();
            if (eResource == null) {
                return;
            }
            environmentFactory = (EnvironmentFactoryInternal.EnvironmentFactoryInternalExtension)PivotUtilInternal.getEnvironmentFactory((Resource)eResource);
        }
        PivotMetamodelManager metamodelManager = environmentFactory.getMetamodelManager();
        Severity severity = Severity.UNKNOWN;
        try {
            try {
                final Constraint pivotConstraint = (Constraint)environmentFactory.getASOf(Constraint.class, (EObject)umlConstraint);
                if (pivotConstraint == null) {
                    throw new ParserException("Failed to create pivot Constraint");
                }
                ResourceSet resourceSet = contextObject.eResource().getResourceSet();
                if (resourceSet != null) {
                    ExpressionInOCL query = this.getQuery(metamodelManager, pivotConstraint);
                    EvaluationVisitor evaluationVisitor = this.createEvaluationVisitor((EnvironmentFactoryInternal)environmentFactory, query, contextObject, monitor);
                    AbstractPivotConstraintLocator.AbstractConstraintLocator constraintEvaluator = new AbstractPivotConstraintLocator.AbstractConstraintLocator(metamodelManager, query, contextObject){

                        protected String getObjectLabel() {
                            Type type = PivotUtil.getContainingType((EObject)pivotConstraint);
                            return type != null ? type.getName() : "??";
                        }
                    };
                    @Nullable Diagnostic diagnostic = (Diagnostic)constraintEvaluator.evaluate(evaluationVisitor);
                    result.setDiagnostic((Object)diagnostic);
                    severity = diagnostic != null ? this.getSeverity(diagnostic) : Severity.OK;
                }
            }
            catch (Throwable e) {
                result.setException(e);
                severity = Severity.FATAL;
                result.setSeverity(severity);
            }
        }
        finally {
            result.setSeverity(severity);
        }
    }
}

