/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.xml.internal.markers;

import java.net.URI;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.editor.pom.XMLEditorUtility;
import org.eclipse.m2e.editor.xml.internal.Messages;
import org.eclipse.m2e.editor.xml.internal.markers.AbstractPomProblemResolution;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.w3c.dom.Element;

public class OpenManagedVersionDefinitionResolution
extends AbstractPomProblemResolution {
    public OpenManagedVersionDefinitionResolution(IMarker marker) {
        super(marker);
    }

    public int getOrder() {
        return 90;
    }

    @Override
    public boolean canFix(String editorHint) {
        try {
            return this.getMarker().getAttribute("managedVersionLocation") != null;
        }
        catch (CoreException ex) {
            return false;
        }
    }

    public String getLabel() {
        return Messages.MavenMarkerResolution_openManaged_label;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OPEN_MARKER");
    }

    public String getDescription() {
        try {
            String locationURIString = (String)this.getMarker().getAttribute("managedVersionLocation");
            return NLS.bind((String)Messages.MavenMarkerResolution_openManaged_description, (Object)locationURIString);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    @Override
    protected void processFix(IStructuredDocument doc, Element root, List<IMarker> markers) {
        try {
            String locationURIString = (String)this.getMarker().getAttribute("managedVersionLocation");
            if (locationURIString != null) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(new URI(locationURIString));
                int lineNumber = this.getMarker().getAttribute("managedVersionLine", -1);
                int columnNumber = Math.max(1, this.getMarker().getAttribute("managedVersionColumn", -1));
                XMLEditorUtility.openXmlEditor((IFileStore)fileStore, (int)lineNumber, (int)columnNumber, (String)fileStore.getName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

