/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.utils.IGenericListener;
import org.eclipse.jubula.tools.internal.exception.UnexpectedGenericTypeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerManager<TYPE extends IGenericListener> {
    private static final Logger LOG = LoggerFactory.getLogger(ListenerManager.class);
    private Set<TYPE> m_listeners = new HashSet<TYPE>();

    public void addListener(TYPE l) {
        this.m_listeners.add(l);
    }

    public void removeListener(TYPE l) {
        this.m_listeners.remove(l);
    }

    public void fireNotification(List<? extends Object> params) {
        HashSet<TYPE> stableListeners = new HashSet<TYPE>(this.m_listeners);
        for (IGenericListener l : stableListeners) {
            try {
                l.checkGenericListElementType(params);
                l.eventOccurred(params);
            }
            catch (UnexpectedGenericTypeException u) {
                LOG.error(u.getMessage());
            }
            catch (Throwable t) {
                LOG.error(Messages.UnhandledExceptionWhileCallingListeners, t);
            }
        }
    }
}

