/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.urlhandling;

import java.util.regex.Pattern;
import org.eclipse.epp.internal.mpc.core.service.UserFavoritesService;
import org.eclipse.epp.internal.mpc.ui.urlhandling.FavoritesUrlHandler;
import org.eclipse.epp.internal.mpc.ui.urlhandling.MarketplaceUrlUtil;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.MarketplaceUrlHandler;

public class HttpFavoritesUrlHandler
implements FavoritesUrlHandler {
    private static final Pattern FAVORITES_URL_PATTERN = UserFavoritesService.FAVORITES_URL_PATTERN;
    private static final Pattern FAVORITES_API_URL_PATTERN = Pattern.compile("(?:^|/)marketplace/favorites/?(?:\\?(?:[^#]*&)?name=.*)?$");

    @Override
    public boolean handles(String url) {
        return url != null && url.toLowerCase().startsWith("http");
    }

    @Override
    public MarketplaceUrlHandler.FavoritesDescriptor parse(String url) {
        CatalogDescriptor catalogDescriptor = MarketplaceUrlUtil.findCatalogDescriptor(url, true);
        return new MarketplaceUrlHandler.FavoritesDescriptor(url, catalogDescriptor);
    }

    @Override
    public boolean isPotentialFavoritesList(String url) {
        return FAVORITES_URL_PATTERN.matcher(url).find() || FAVORITES_API_URL_PATTERN.matcher(url).find();
    }
}

