/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.flow;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.eef.codegen.flow.IdentityStep;
import org.eclipse.emf.eef.codegen.flow.Step;
import org.eclipse.emf.eef.codegen.flow.var.WorkflowContext;

public abstract class ConditionalStep
extends Step {
    private Step thenStep;
    private Step elseStep;

    public ConditionalStep(Step thenStep) {
        super("Conditional step");
        this.thenStep = thenStep;
        this.elseStep = new IdentityStep();
    }

    public ConditionalStep(Step thenStep, Step elseStep) {
        super("Conditional step");
        this.thenStep = thenStep;
        this.elseStep = elseStep;
    }

    public IStatus execute(IProgressMonitor monitor) {
        if (this.condition()) {
            return this.thenStep.execute(monitor);
        }
        if (this.elseStep != null) {
            return this.elseStep.execute(monitor);
        }
        return Status.OK_STATUS;
    }

    public abstract boolean condition();

    public String getName() {
        return super.getName();
    }

    public Step getThenStep() {
        return this.thenStep;
    }

    public Step getElseStep() {
        return this.elseStep;
    }

    public void setContext(WorkflowContext context) {
        super.setContext(context);
        this.thenStep.setContext(context);
        if (this.elseStep != null) {
            this.elseStep.setContext(context);
        }
    }

    public void setResourceSet(ResourceSet resourceSet) {
        super.setResourceSet(resourceSet);
        this.thenStep.setResourceSet(resourceSet);
        if (this.elseStep != null) {
            this.elseStep.setResourceSet(resourceSet);
        }
    }

    public boolean validateExecution() {
        if (this.condition()) {
            return this.thenStep.validateExecution();
        }
        if (this.elseStep != null) {
            return this.elseStep.validateExecution();
        }
        return super.validateExecution();
    }
}

