/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.ide.utils;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.compare.ide.EMFCompareIDEPlugin;
import org.eclipse.emf.compare.ide.internal.utils.StoragePathAdapter;
import org.eclipse.emf.compare.ide.internal.utils.URIStorage;
import org.eclipse.emf.compare.ide.utils.IStoragePathAdapterProvider;
import org.eclipse.emf.compare.ide.utils.IStoragePathProvider;
import org.eclipse.emf.compare.ide.utils.IStoragePathProvider2;
import org.eclipse.emf.compare.ide.utils.StorageTraversal;
import org.eclipse.emf.compare.merge.ResourceChangeAdapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public final class ResourceUtil {
    private static final String[] MODEL_CONTENT_TYPES = new String[]{"org.eclipse.emf.compare.content.type", "org.eclipse.emf.ecore", "org.eclipse.emf.ecore.xmi"};
    private static final Function<IStorage, URI> AS_URI = new Function<IStorage, URI>(){

        public URI apply(IStorage input) {
            if (input != null) {
                return ResourceUtil.createURIFor(input);
            }
            return null;
        }
    };

    private ResourceUtil() {
    }

    public static Function<IStorage, URI> asURI() {
        return AS_URI;
    }

    public static Resource loadResource(IStorage storage, ResourceSet resourceSet, Map<?, ?> options) {
        URI uri = ResourceUtil.createURIFor(storage);
        try {
            Resource resource = resourceSet.createResource(uri);
            ResourceUtil.setAssociatedStorage(resource, storage);
            Throwable throwable = null;
            Object var6_8 = null;
            try (InputStream stream = storage.getContents();){
                resource.load(stream, options);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return resource;
        }
        catch (IOException | CoreException | WrappedException throwable) {
            return null;
        }
    }

    public static IStorage getAssociatedStorage(Resource resource) {
        StorageProvider storageProvider = (StorageProvider)EcoreUtil.getExistingAdapter((Notifier)resource, StorageProvider.class);
        if (storageProvider != null) {
            return storageProvider.getStorage();
        }
        return null;
    }

    public static void setAssociatedStorage(Resource resource, IStorage storage) {
        String fullPath = storage.getFullPath().toString();
        boolean isLocal = storage instanceof IFile;
        EList eAdapters = resource.eAdapters();
        if (storage instanceof IStoragePathAdapterProvider) {
            eAdapters.add((Object)((IStoragePathAdapterProvider)storage).createStoragePathAdapter(fullPath, isLocal));
        } else {
            eAdapters.add((Object)new StoragePathAdapter(fullPath, isLocal));
        }
        eAdapters.add((Object)new StorageProvider(storage));
    }

    /*
     * Loose catch block
     */
    public static boolean binaryIdentical(IStorage left, IStorage right) {
        int maxBufferSize = 8192;
        byte[] buffer = new byte[8192];
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                boolean bl;
                BufferedInputStream rightStream;
                BufferedInputStream leftStream;
                block20: {
                    block19: {
                        int readLeft;
                        leftStream = new BufferedInputStream(left.getContents(), 8192);
                        rightStream = new BufferedInputStream(right.getContents(), 8192);
                        boolean identical = true;
                        do {
                            if ((readLeft = leftStream.read(buffer, 0, buffer.length)) == -1) {
                                identical = rightStream.read() == -1;
                                break;
                            }
                            if (ResourceUtil.verifyNextBytes(rightStream, buffer, 0, readLeft)) continue;
                            identical = false;
                            break;
                        } while (readLeft > 0);
                        bl = identical;
                        if (rightStream == null) break block19;
                        rightStream.close();
                    }
                    if (leftStream == null) break block20;
                    leftStream.close();
                }
                return bl;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (rightStream != null) {
                                rightStream.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (leftStream != null) {
                                leftStream.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            ResourceUtil.logError((Exception)e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean binaryIdentical(IStorage left, IStorage right, IStorage origin) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean verifyNextBytes(InputStream stream, byte[] bytes, int offset, int length) throws IOException {
        int done = 0;
        byte[] buffer = new byte[offset + length];
        while (done < length) {
            int read = stream.read(buffer, offset + done, length - done);
            if (read == -1 || !ResourceUtil.equalArrays(offset + done, read, bytes, buffer)) {
                return false;
            }
            done += read;
        }
        return true;
    }

    public static URI createURIFor(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }

    public static URI createURIFor(IStorage storage) {
        URI shortcut = null;
        if (storage instanceof IFile) {
            shortcut = ResourceUtil.createURIFor((IFile)storage);
        } else if (storage instanceof URIStorage) {
            shortcut = ((URIStorage)storage).getURI();
        }
        if (shortcut != null) {
            return shortcut;
        }
        String path = ResourceUtil.getFixedPath(storage).toString();
        URI uri = path.startsWith("platform:/plugin/") ? URI.createURI((String)path) : (path.startsWith("file:/") ? URI.createURI((String)path) : (ResourceUtil.hasStoragePathProvider(storage) ? URI.createPlatformResourceURI((String)path, (boolean)true) : URI.createURI((String)path, (boolean)true)));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path iPath = new Path(path);
        if (root != null && iPath.segmentCount() >= 2 && root.getFile((IPath)iPath).exists()) {
            uri = URI.createPlatformResourceURI((String)path, (boolean)true);
        }
        return uri;
    }

    public static IResource getResourceFromURI(URI uri) {
        IFile targetFile;
        if (uri.isPlatform()) {
            Path platformString = new Path(uri.trimFragment().toPlatformString(true));
            targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)platformString);
        } else {
            targetFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.trimFragment().toString()));
        }
        return targetFile;
    }

    public static IPath getFixedPath(IStorage storage) {
        Object adapter = Platform.getAdapterManager().loadAdapter((Object)storage, IStoragePathProvider.class.getName());
        if (adapter instanceof IStoragePathProvider) {
            return ((IStoragePathProvider)adapter).computeFixedPath(storage);
        }
        return storage.getFullPath();
    }

    public static IPath getAbsolutePath(IStorage storage) {
        Object adapter = Platform.getAdapterManager().loadAdapter((Object)storage, IStoragePathProvider.class.getName());
        Object absolutePath = adapter instanceof IStoragePathProvider2 ? ((IStoragePathProvider2)adapter).computeAbsolutePath(storage) : (storage instanceof File ? new Path(((File)storage).getAbsolutePath()) : storage.getFullPath());
        return absolutePath;
    }

    private static boolean hasStoragePathProvider(IStorage storage) {
        Object adapter = Platform.getAdapterManager().loadAdapter((Object)storage, IStoragePathProvider.class.getName());
        boolean hasProvider = adapter instanceof IStoragePathProvider;
        return hasProvider;
    }

    public static void saveAllResources(ResourceSet resourceSet, Map<?, ?> options) {
        ArrayList resources = Lists.newArrayList((Iterable)resourceSet.getResources());
        for (Resource resource : resources) {
            ResourceUtil.saveResource(resource, options);
        }
    }

    public static void saveAllResources(ResourceSet resourceSet, Map<?, ?> options, StorageTraversal leftTraversal, StorageTraversal rightTraversal, StorageTraversal originTraversal) {
        ArrayList resources = Lists.newArrayList((Iterable)Iterables.filter((Iterable)resourceSet.getResources(), (Predicate)new Predicate<Resource>(){

            public boolean apply(Resource input) {
                return ResourceUtil.supportsOutput(input);
            }
        }));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        HashSet wsResources = Sets.newHashSet();
        HashSet nonWsResources = Sets.newHashSet();
        for (Resource resource : resources) {
            String projectName = new Path(resource.getURI().toPlatformString(true)).segment(0);
            IProject project = root.getProject(projectName);
            if (project != null && project.isAccessible()) {
                wsResources.add(resource);
                continue;
            }
            nonWsResources.add(resource);
        }
        for (Resource resource : wsResources) {
            ResourceUtil.saveResource(resource, options);
        }
        resources.removeAll(wsResources);
        Set<? extends IStorage> leftStorages = leftTraversal.getStorages();
        Set<? extends IStorage> rightStorages = rightTraversal.getStorages();
        Set<? extends IStorage> originStorages = originTraversal != null ? originTraversal.getStorages() : null;
        for (Resource resource : nonWsResources) {
            String absolutePath = ResourceUtil.getAbsolutePath(resource, leftStorages, rightStorages, originStorages);
            URI fileURI = URI.createFileURI((String)absolutePath);
            resource.setURI(fileURI);
        }
        for (Resource resource : nonWsResources) {
            ResourceUtil.saveResource(resource, options);
        }
    }

    private static String getAbsolutePath(Resource resource, Set<? extends IStorage> leftStorages, Set<? extends IStorage> rightStorages, Set<? extends IStorage> originStorages) {
        URI uri = resource.getURI();
        String absolutePath = ResourceUtil.getAbsolutePath(uri, leftStorages);
        if (absolutePath == null) {
            absolutePath = ResourceUtil.getAbsolutePath(uri, rightStorages);
        }
        if (absolutePath == null && originStorages != null) {
            absolutePath = ResourceUtil.getAbsolutePath(uri, originStorages);
        }
        return absolutePath;
    }

    private static String getAbsolutePath(URI uri, Set<? extends IStorage> storages) {
        for (IStorage iStorage : storages) {
            IPath absolutePath;
            IPath storagePath = ResourceUtil.getFixedPath(iStorage);
            if (!storagePath.makeAbsolute().toString().equals(uri.toPlatformString(true)) || (absolutePath = ResourceUtil.getAbsolutePath(iStorage)) == null) continue;
            return absolutePath.toString();
        }
        return null;
    }

    public static void saveResource(Resource resource, Map<?, ?> options) {
        if (ResourceUtil.supportsOutput(resource)) {
            try {
                if (ResourceUtil.mustDelete(resource)) {
                    ResourceUtil.deleteResource(resource);
                } else {
                    resource.save(options);
                }
            }
            catch (IOException e) {
                ResourceUtil.logError(e);
            }
        }
    }

    protected static boolean mustDelete(Resource resource) {
        Adapter adapter = EcoreUtil.getAdapter((List)resource.eAdapters(), ResourceChangeAdapter.class);
        if (adapter instanceof ResourceChangeAdapter) {
            return ((ResourceChangeAdapter)adapter).mustDelete(resource);
        }
        return false;
    }

    protected static void deleteResource(Resource resource) {
        try {
            resource.delete(Collections.emptyMap());
        }
        catch (IOException e) {
            ResourceUtil.logError(e);
        }
    }

    public static boolean hasContentType(String contentTypeId, List<IContentType> contentTypes) {
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType expected = ctManager.getContentType(contentTypeId);
        if (expected == null) {
            return false;
        }
        boolean hasContentType = false;
        int i = 0;
        while (i < contentTypes.size() && !hasContentType) {
            if (contentTypes.get(i).isKindOf(expected)) {
                hasContentType = true;
            }
            ++i;
        }
        return hasContentType;
    }

    public static boolean hasModelType(IFile file) {
        boolean isModel = false;
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        ArrayList fileNameTypes = Lists.newArrayList((Object[])ctManager.findContentTypesFor(file.getName()));
        int i = 0;
        while (i < MODEL_CONTENT_TYPES.length && !isModel) {
            isModel = ResourceUtil.hasContentType(MODEL_CONTENT_TYPES[i], fileNameTypes);
            ++i;
        }
        if (isModel) {
            return true;
        }
        ArrayList contentTypes = Lists.newArrayList((Object[])ResourceUtil.getContentTypes(file));
        contentTypes.removeAll(fileNameTypes);
        int i2 = 0;
        while (i2 < MODEL_CONTENT_TYPES.length && !isModel) {
            isModel = ResourceUtil.hasContentType(MODEL_CONTENT_TYPES[i2], contentTypes);
            ++i2;
        }
        return isModel;
    }

    public static IContentType[] getContentTypes(IFile file) {
        IContentTypeManager ctManager = Platform.getContentTypeManager();
        IContentType[] contentTypes = new IContentType[]{};
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream resourceContent = file.getContents();){
                contentTypes = ctManager.findContentTypesFor(resourceContent, file.getName());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            ctManager.findContentTypesFor(file.getName());
        }
        return contentTypes;
    }

    private static boolean supportsOutput(Resource resource) {
        URI uri = resource.getURI();
        return uri.isPlatformResource() || uri.isRelative() || uri.isFile();
    }

    private static boolean equalArrays(int offset, int length, byte[] array1, byte[] array2) {
        boolean result = true;
        if (array1 == array2) {
            result = true;
        } else if (array1 == null || array2 == null) {
            result = false;
        } else {
            int i = offset;
            while (result && i < offset + length) {
                result = array1[i] == array2[i];
                ++i;
            }
        }
        return result;
    }

    private static void logError(Exception e) {
        Status status = new Status(4, "org.eclipse.emf.compare.ide", e.getMessage(), (Throwable)e);
        EMFCompareIDEPlugin.getDefault().getLog().log((IStatus)status);
    }

    private static final class StorageProvider
    extends AdapterImpl {
        private final IStorage storage;

        StorageProvider(IStorage storage) {
            this.storage = storage;
        }

        public boolean isAdapterForType(Object type) {
            return type == StorageProvider.class;
        }

        public IStorage getStorage() {
            return this.storage;
        }
    }
}

