/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.navigator;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.navigator.CommonDragAdapterAssistant;

public class CNavigatorDragAdapterAssistant
extends CommonDragAdapterAssistant {
    private static final Transfer[] TRANSFERS = new Transfer[]{LocalSelectionTransfer.getTransfer(), FileTransfer.getInstance()};

    public Transfer[] getSupportedTransferTypes() {
        return TRANSFERS;
    }

    public boolean setDragData(DragSourceEvent event, IStructuredSelection selection) {
        if (selection != null) {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.dataType)) {
                boolean applicable = false;
                for (Object element : selection) {
                    if (!(element instanceof ICElement) || element instanceof ITranslationUnit) continue;
                    if (!(element instanceof ISourceReference)) {
                        return false;
                    }
                    applicable = true;
                }
                if (applicable) {
                    event.data = selection;
                    return true;
                }
            } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
                ArrayList<String> files = new ArrayList<String>();
                for (Object element : selection) {
                    ITranslationUnit tu;
                    IPath location;
                    if (!(element instanceof ITranslationUnit) || (location = (tu = (ITranslationUnit)element).getLocation()) == null) continue;
                    files.add(location.toOSString());
                }
                if (!files.isEmpty()) {
                    event.data = files.toArray(new String[files.size()]);
                    return true;
                }
            }
        }
        return false;
    }
}

