/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.workspace.ProjectClosedEvent;
import org.eclipse.buildship.core.internal.workspace.ProjectCreatedEvent;
import org.eclipse.buildship.core.internal.workspace.ProjectDeletedEvent;
import org.eclipse.buildship.core.internal.workspace.ProjectMovedEvent;
import org.eclipse.buildship.core.internal.workspace.ProjectOpenedEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class ProjectChangeListener
implements IResourceChangeListener {
    private ProjectChangeListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                this.visitDelta(delta);
            }
            catch (CoreException e) {
                CorePlugin.logger().warn("Failed to detect project changes", e);
            }
        }
    }

    private void visitDelta(IResourceDelta delta) throws CoreException {
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                try {
                    return ProjectChangeListener.this.doVisitDelta(delta);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.buildship.core", "ProjectChangeListener failed", (Throwable)e));
                }
            }
        });
    }

    private boolean doVisitDelta(IResourceDelta delta) throws Exception {
        if (delta.getResource() instanceof IProject) {
            IProject project = (IProject)delta.getResource();
            IPath fromPath = delta.getMovedFromPath();
            IPath toPath = delta.getMovedToPath();
            if (delta.getKind() == 2) {
                if (fromPath == null && toPath == null) {
                    CorePlugin.listenerRegistry().dispatch(new ProjectDeletedEvent(project));
                }
            } else if (delta.getKind() == 1) {
                if (fromPath == null && toPath == null) {
                    CorePlugin.listenerRegistry().dispatch(new ProjectCreatedEvent(project));
                } else if (fromPath != null) {
                    CorePlugin.listenerRegistry().dispatch(new ProjectMovedEvent(project, fromPath.lastSegment()));
                }
            } else if (delta.getFlags() == 16384) {
                if (project.isOpen()) {
                    CorePlugin.listenerRegistry().dispatch(new ProjectOpenedEvent(project));
                } else {
                    CorePlugin.listenerRegistry().dispatch(new ProjectClosedEvent(project));
                }
            }
            return false;
        }
        return delta.getResource() instanceof IWorkspaceRoot;
    }

    public static ProjectChangeListener createAndRegister() {
        ProjectChangeListener listener = new ProjectChangeListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        return listener;
    }

    public void close() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

