/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.validation.validators;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.RootElement;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.core.validation.validators.AbstractBpmn2ElementValidator;
import org.eclipse.bpmn2.modeler.core.validation.validators.Messages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;

public class ProcessValidator
extends AbstractBpmn2ElementValidator<Process> {
    public ProcessValidator(IValidationContext ctx) {
        super(ctx);
    }

    public ProcessValidator(AbstractBpmn2ElementValidator other) {
        super(other);
    }

    @Override
    public IStatus validate(Process process) {
        boolean foundStartEvent = false;
        ArrayList<StartEvent> untriggeredStartEvents = new ArrayList<StartEvent>();
        boolean foundEndEvent = false;
        List flowElements = process.getFlowElements();
        for (FlowElement fe : flowElements) {
            if (fe instanceof StartEvent) {
                foundStartEvent = true;
                if (((StartEvent)fe).getEventDefinitions().size() == 0) {
                    untriggeredStartEvents.add((StartEvent)fe);
                }
            }
            if (!(fe instanceof EndEvent)) continue;
            foundEndEvent = true;
        }
        if (!foundStartEvent) {
            this.addStatus((EObject)process, 2, Messages.ProcessValidator_No_StartEvent, new Object[0]);
        }
        if (untriggeredStartEvents.size() > 1) {
            this.addStatus((EObject)process, (EObject[])untriggeredStartEvents.toArray(new StartEvent[untriggeredStartEvents.size()]), 4, Messages.ProcessValidator_Multiple_UntriggeredStartEvents, new Object[0]);
        }
        if (!foundEndEvent) {
            this.addStatus((EObject)process, 2, Messages.ProcessValidator_No_EndEvent, new Object[0]);
        }
        if (ProcessValidator.isEmpty(process.getName())) {
            this.addStatus((EObject)process, "name", 2, Messages.ProcessValidator_No_Name, process.getId());
        }
        return this.getResult();
    }

    @Override
    public boolean checkSuperType(EClass eClass, Process object) {
        if ("FlowElementsContainer".equals(eClass.getName())) {
            return true;
        }
        return "BaseElement".equals(eClass.getName());
    }

    public static boolean isContainingProcessExecutable(EObject object) {
        Process process = null;
        if (object instanceof Process) {
            process = (Process)object;
        } else if (object instanceof RootElement) {
            Definitions definitions = ModelUtil.getDefinitions(object);
            if (definitions != null) {
                for (RootElement re : definitions.getRootElements()) {
                    if (!(re instanceof Process)) continue;
                    process = (Process)re;
                    break;
                }
            }
        } else {
            process = (Process)ModelUtil.findNearestAncestor(object, new Class[]{Process.class});
        }
        return process != null && process.isIsExecutable();
    }
}

