/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.xpath;

import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.xpath.XPathValidator;
import org.eclipse.bpel.xpath10.Expr;
import org.eclipse.bpel.xpath10.FunctionCallExpr;
import org.eclipse.bpel.xpath10.VariableReferenceExpr;

public class JoinCondition
extends XPathValidator {
    @Override
    @ARule(sa=73, desc="Checks for boolean expression on joinCondition", author="michal.chmielewski@oracle.com", date="01/30/2007", order=15)
    public void checkBooleanExpression() {
        super.checkBooleanExpression();
    }

    @ARule(sa=28, desc="BPEL Functions must not be used in joinConditions", author="michal.chmielewski@oracle.com", date="01/20/2007", tag="bpel.functions")
    public void checkBPELFunctionsInJoinConditions(FunctionCallExpr expr) {
        IProblem problem = this.createError();
        problem.fill("XPATH_BPEL_FUNCTION", this.toString(this.mNode.nodeName()), expr.getFunctionName(), this.fExprByNode);
        this.repointOffsets(problem, (Expr)expr);
    }

    @ARule(sa=73, desc="Check the link reference for joinCondition (only incoming link names)", author="michal.chmielewski@oracle.com", date="01/30/2007", tag="variables", order=17)
    public void checkLinkReference(VariableReferenceExpr expr) {
        INode target;
        IProblem problem;
        String prefix = expr.getPrefix();
        final String name = expr.getVariableName();
        if (!JoinCondition.isEmpty(prefix)) {
            if (this.duplicateThing("duplicate.joinCondition.link.check.", name)) {
                return;
            }
            problem = this.createError();
            problem.fill("XPATH_PREFIX_NOT_ALLOWED", this.toString(this.mNode.nodeName()), expr.getText(), prefix);
            this.repointOffsets(problem, (Expr)expr);
        }
        if (this.isUndefined(target = mSelector.selectNode(this.fParentNode, ND_TARGET, new IFilter<INode>(){

            @Override
            public boolean select(INode node) {
                return name.equals(node.getAttribute(AT_LINK_NAME));
            }
        }))) {
            if (this.duplicateThing("duplicate.joinCondition.link.check.", name)) {
                return;
            }
            problem = this.createError();
            problem.fill("XPATH_LINK_UNDEF", name, expr.getText());
            this.repointOffsets(problem, (Expr)expr);
        }
    }
}

