/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.yaml;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.jsonrpc.messages.Message;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.InitializeLaunchConfigurations;

public class YAMLLanguageServer
extends ProcessStreamConnectionProvider {
    private String cachedSchema;

    public YAMLLanguageServer() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(InitializeLaunchConfigurations.getNodeJsLocation());
        try {
            URL url = FileLocator.toFileURL((URL)((Object)((Object)this)).getClass().getResource("/node_modules/yaml-language-server/out/server/src/server.js"));
            commands.add(new File(url.getPath()).getAbsolutePath());
            commands.add("--stdio");
            this.setCommands(commands);
            this.setWorkingDirectory(System.getProperty("user.dir"));
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
    }

    public void handleMessage(Message message, LanguageServer languageServer, URI rootUri) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        String schemaStr = preferenceStore.getString("wildwebdeveloper.yaml.schema");
        if (this.cachedSchema == null || !schemaStr.equals(this.cachedSchema)) {
            this.cachedSchema = schemaStr;
            Map schemas = (Map)new Gson().fromJson(schemaStr, new TypeToken<HashMap<String, Object>>(){}.getType());
            HashMap<String, Object> yaml = new HashMap<String, Object>();
            yaml.put("schemas", schemas);
            yaml.put("validate", true);
            yaml.put("completion", true);
            yaml.put("hover", true);
            HashMap<String, HashMap<String, Object>> settings = new HashMap<String, HashMap<String, Object>>();
            settings.put("yaml", yaml);
            DidChangeConfigurationParams params = new DidChangeConfigurationParams(settings);
            languageServer.getWorkspaceService().didChangeConfiguration(params);
        }
    }

    public String toString() {
        return "YAML Language Server: " + super.toString();
    }
}

