/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.MigLayout.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.model.util.ObjectInfoAction;
import org.eclipse.wb.internal.swing.MigLayout.model.CellConstraintsSupport;
import org.eclipse.wb.internal.swing.MigLayout.model.MigColumnInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigLayoutInfo;
import org.eclipse.wb.internal.swing.MigLayout.model.MigRowInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionActionsSupport
extends ObjectEventListener {
    private final MigLayoutInfo m_layout;

    public SelectionActionsSupport(MigLayoutInfo layout) {
        this.m_layout = layout;
        this.m_layout.addBroadcastListener((Object)this);
    }

    public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
        if (objects.isEmpty()) {
            return;
        }
        ArrayList constraints = Lists.newArrayList();
        for (ObjectInfo object : objects) {
            if (!(object instanceof ComponentInfo) || object.getParent() != this.m_layout.getContainer()) {
                return;
            }
            ComponentInfo component = (ComponentInfo)object;
            constraints.add(MigLayoutInfo.getConstraints(component));
        }
        actions.add(new Separator());
        this.addHorizontalAlignmentAction(actions, constraints, MigColumnInfo.Alignment.DEFAULT);
        this.addHorizontalAlignmentAction(actions, constraints, MigColumnInfo.Alignment.LEFT);
        this.addHorizontalAlignmentAction(actions, constraints, MigColumnInfo.Alignment.CENTER);
        this.addHorizontalAlignmentAction(actions, constraints, MigColumnInfo.Alignment.RIGHT);
        this.addHorizontalAlignmentAction(actions, constraints, MigColumnInfo.Alignment.FILL);
        this.addHorizontalAlignmentAction(actions, constraints, MigColumnInfo.Alignment.LEADING);
        this.addHorizontalAlignmentAction(actions, constraints, MigColumnInfo.Alignment.TRAILING);
        actions.add(new Separator());
        this.addVerticalAlignmentAction(actions, constraints, MigRowInfo.Alignment.DEFAULT);
        this.addVerticalAlignmentAction(actions, constraints, MigRowInfo.Alignment.TOP);
        this.addVerticalAlignmentAction(actions, constraints, MigRowInfo.Alignment.CENTER);
        this.addVerticalAlignmentAction(actions, constraints, MigRowInfo.Alignment.BOTTOM);
        this.addVerticalAlignmentAction(actions, constraints, MigRowInfo.Alignment.FILL);
        this.addVerticalAlignmentAction(actions, constraints, MigRowInfo.Alignment.BASELINE);
    }

    private void addHorizontalAlignmentAction(List<Object> actions, List<CellConstraintsSupport> constraints, MigColumnInfo.Alignment alignment) {
        boolean isChecked = this.hasGivenHorizontalAlignment(constraints, alignment);
        HorizontalAlignmentAction action = new HorizontalAlignmentAction(constraints, isChecked, alignment);
        actions.add((Object)action);
    }

    private boolean hasGivenHorizontalAlignment(List<CellConstraintsSupport> constraints, MigColumnInfo.Alignment alignment) {
        for (CellConstraintsSupport constraint : constraints) {
            if (constraint.getHorizontalAlignment() == alignment) continue;
            return false;
        }
        return true;
    }

    private void addVerticalAlignmentAction(List<Object> actions, List<CellConstraintsSupport> constraints, MigRowInfo.Alignment alignment) {
        boolean isChecked = this.hasGivenVerticalAlignment(constraints, alignment);
        VerticalAlignmentAction action = new VerticalAlignmentAction(constraints, isChecked, alignment);
        actions.add((Object)action);
    }

    private boolean hasGivenVerticalAlignment(List<CellConstraintsSupport> constraints, MigRowInfo.Alignment alignment) {
        for (CellConstraintsSupport constraint : constraints) {
            if (constraint.getVerticalAlignment() == alignment) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HorizontalAlignmentAction
    extends ObjectInfoAction {
        private final List<CellConstraintsSupport> m_constraints;
        private final MigColumnInfo.Alignment m_alignment;

        public HorizontalAlignmentAction(List<CellConstraintsSupport> constraints, boolean checked, MigColumnInfo.Alignment alignment) {
            super((ObjectInfo)SelectionActionsSupport.this.m_layout, alignment.getText(), alignment.getMenuImage(), 8);
            this.setChecked(checked);
            this.m_constraints = constraints;
            this.m_alignment = alignment;
        }

        protected void runEx() throws Exception {
            for (CellConstraintsSupport constraint : this.m_constraints) {
                constraint.setHorizontalAlignment(this.m_alignment);
                constraint.write();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class VerticalAlignmentAction
    extends ObjectInfoAction {
        private final List<CellConstraintsSupport> m_constraints;
        private final MigRowInfo.Alignment m_alignment;

        public VerticalAlignmentAction(List<CellConstraintsSupport> constraints, boolean checked, MigRowInfo.Alignment alignment) {
            super((ObjectInfo)SelectionActionsSupport.this.m_layout, alignment.getText(), alignment.getMenuImage(), 8);
            this.setChecked(checked);
            this.m_constraints = constraints;
            this.m_alignment = alignment;
        }

        protected void runEx() throws Exception {
            for (CellConstraintsSupport constraint : this.m_constraints) {
                constraint.setVerticalAlignment(this.m_alignment);
                constraint.write();
            }
        }
    }
}

