/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.dialogfields;

import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wb.internal.core.utils.dialogfields.DialogField;
import org.eclipse.wb.internal.core.utils.dialogfields.SwtUtil;

public class LayoutUtil {
    public static int getNumberOfColumns(DialogField[] editors) {
        int nCulumns = 0;
        int i = 0;
        while (i < editors.length) {
            nCulumns = Math.max(editors[i].getNumberOfControls(), nCulumns);
            ++i;
        }
        return nCulumns;
    }

    public static void doDefaultLayout(Composite parent, DialogField[] editors, boolean labelOnTop) {
        LayoutUtil.doDefaultLayout(parent, editors, labelOnTop, 0, 0);
    }

    public static void doDefaultLayout(Composite parent, DialogField[] editors, boolean labelOnTop, int marginWidth, int marginHeight) {
        int nCulumns = LayoutUtil.getNumberOfColumns(editors);
        Control[][] controls = new Control[editors.length][];
        int i = 0;
        while (i < editors.length) {
            controls[i] = editors[i].doFillIntoGrid(parent, nCulumns);
            ++i;
        }
        if (labelOnTop) {
            LayoutUtil.modifyLabelSpans(controls, --nCulumns);
        }
        GridLayout layout = null;
        layout = parent.getLayout() instanceof GridLayout ? (GridLayout)parent.getLayout() : new GridLayout();
        if (marginWidth != -1) {
            layout.marginWidth = marginWidth;
        }
        if (marginHeight != -1) {
            layout.marginHeight = marginHeight;
        }
        layout.numColumns = nCulumns;
        parent.setLayout((Layout)layout);
    }

    private static void modifyLabelSpans(Control[][] controls, int nCulumns) {
        int i = 0;
        while (i < controls.length) {
            SwtUtil.setHorizontalSpan(controls[i][0], nCulumns);
            ++i;
        }
    }
}

