/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.internal.base.BaseNamedData;
import org.eclipse.passage.lic.internal.base.requirements.UnsatisfiableRequirement;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.internal.equinox.requirements.RequirementsFromBundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public final class BundleRequirements
implements ResolvedRequirements {
    private final Logger logger = LoggerFactory.getLogger(BundleRequirements.class);
    private Optional<BundleContext> context;

    @Activate
    public void activate(BundleContext bundle) {
        this.context = Optional.ofNullable(bundle);
    }

    @Deactivate
    public void deactivate() {
        this.context = Optional.empty();
    }

    public StringServiceId id() {
        return new StringServiceId("manifest");
    }

    public Collection<Requirement> all() {
        if (this.sabotage()) {
            return this.unsafisifiable();
        }
        return this.resolve();
    }

    private boolean sabotage() {
        return !this.context.isPresent();
    }

    private Collection<Requirement> unsafisifiable() {
        this.logger.error(EquinoxMessages.BundleRequirements_error_bundle_context);
        return Collections.singleton(new UnsatisfiableRequirement(NLS.bind((String)EquinoxMessages.BundleRequirements_no_context, (Object)this.getClass().getName()), this.getClass()).get());
    }

    private Collection<Requirement> resolve() {
        return Arrays.stream(this.context.get().getBundles()).map(RequirementsFromBundle::new).map(BaseNamedData::get).filter(Optional::isPresent).map(Optional::get).flatMap(Collection::stream).collect(Collectors.toList());
    }
}

