/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.custom.command;

import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;

public class CustomCreateContainmentLinkCommand
extends CommonDeferredCreateConnectionViewCommand {
    private final View sourceView;
    private final View targetView;

    public CustomCreateContainmentLinkCommand(TransactionalEditingDomain editingDomain, EObject element, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint, ICommand command) {
        super(editingDomain, element, sourceViewAdapter, targetViewAdapter, viewer, preferencesHint, command);
        this.sourceView = null;
        this.targetView = (View)targetViewAdapter.getAdapter(View.class);
    }

    public CustomCreateContainmentLinkCommand(TransactionalEditingDomain editingDomain, String semanticHint, View source, IAdaptable sourceCircleViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint, CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor, ICommand command) {
        super(editingDomain, semanticHint, sourceCircleViewAdapter, targetViewAdapter, viewer, preferencesHint, viewDescriptor, command);
        this.sourceView = source;
        this.targetView = (View)targetViewAdapter.getAdapter(View.class);
    }

    public boolean canExecute() {
        if (this.sourceView == null && this.targetView == null) {
            return false;
        }
        if (!(this.sourceView == null || this.sourceView.getElement() != null && this.sourceView.getElement() instanceof Element)) {
            return false;
        }
        if (!(this.targetView == null || this.targetView.getElement() != null && this.targetView.getElement() instanceof Element)) {
            return false;
        }
        Element source = this.getSourceElement();
        Element target = this.getTargetElement();
        if (source != null && target != null) {
            return !this.containsLoop(source, target);
        }
        return true;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in create link command");
        }
        Map epRegistry = this.viewer.getEditPartRegistry();
        IGraphicalEditPart targetEP = (IGraphicalEditPart)epRegistry.get(this.targetViewAdapter.getAdapter(View.class));
        IGraphicalEditPart sourceContainmentCircleEP = this.getSourceContainmentCircleEP(epRegistry);
        if (sourceContainmentCircleEP == null) {
            return null;
        }
        View targetView = (View)this.targetViewAdapter.getAdapter(View.class);
        View sourceView = (View)sourceContainmentCircleEP.getParent().getAdapter(View.class);
        PackageableElement targetElement = (PackageableElement)targetView.getElement();
        PackageableElement sourceElement = (PackageableElement)sourceView.getElement();
        EditPart sourceEP = sourceContainmentCircleEP.getParent();
        if (sourceElement instanceof Class) {
            Class container = (Class)sourceElement;
            container.getNestedClassifiers().add((Object)((Classifier)targetElement));
        } else if (sourceElement instanceof Package) {
            Package container = (Package)sourceElement;
            container.getPackagedElements().add((Object)targetElement);
        } else {
            throw new ExecutionException("Invalid source " + sourceEP);
        }
        return super.doExecuteWithResult(progressMonitor, info, sourceContainmentCircleEP, targetEP);
    }

    private boolean containsLoop(Element sourceElement, Element targetElement) {
        if (sourceElement.equals(targetElement)) {
            return true;
        }
        return EcoreUtil.isAncestor((EObject)targetElement, (EObject)sourceElement);
    }

    private IGraphicalEditPart getSourceContainmentCircleEP(Map<?, ?> epRegistry) {
        if (this.command != null) {
            return (IGraphicalEditPart)epRegistry.get(this.command.getCommandResult().getReturnValue());
        }
        return (IGraphicalEditPart)epRegistry.get(this.sourceViewAdapter.getAdapter(View.class));
    }

    private Element getSourceElement() {
        return (Element)this.sourceView.getElement();
    }

    private Element getTargetElement() {
        return (Element)this.targetView.getElement();
    }
}

